/*
 * Decompiled with CFR 0.152.
 */
package com.github.dactiv.showcase.web;

import com.github.dactiv.common.bundle.BeanResourceBundle;
import com.github.dactiv.common.spring.mvc.SpringMvcHolder;
import com.github.dactiv.common.utils.CaptchaUtils;
import com.github.dactiv.showcase.common.SystemVariableUtils;
import com.github.dactiv.showcase.common.annotation.OperatingAudit;
import com.github.dactiv.showcase.entity.account.User;
import com.github.dactiv.showcase.service.account.AccountManager;
import com.google.common.collect.Maps;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@OperatingAudit(value="\u7cfb\u7edf\u7ba1\u7406")
public class SystemCommonController {
    @Autowired
    private AccountManager accountManager;
    public final String EMPTY_PORTRAIT_PATH = "\\resource\\image\\empty.png";
    @Value(value="${file.upload.path}")
    private String fileUploadPath;

    @RequestMapping(value={"/login"})
    public String login() {
        if (!SystemVariableUtils.isAuthenticated()) {
            return "login";
        }
        return "redirect:/index";
    }

    @RequestMapping(value={"/index"})
    public void index() {
    }

    @OperatingAudit(function="\u4fee\u6539\u5bc6\u7801")
    @RequestMapping(value={"/change-password"})
    public String changePassword(String oldPassword, String newPassword) {
        this.accountManager.updateUserPassword(oldPassword, newPassword);
        return "redirect:/logout";
    }

    @ResponseBody
    @RequestMapping(value={"/change-portrait"})
    public Map<String, Object> changePortrait(HttpServletRequest request) throws IOException {
        int ch;
        User entity = SystemVariableUtils.getSessionVariable().getUser();
        HashMap result = Maps.newHashMap();
        ServletInputStream is = request.getInputStream();
        ByteArrayOutputStream bytestream = new ByteArrayOutputStream();
        while ((ch = is.read()) != -1) {
            bytestream.write(ch);
        }
        bytestream.close();
        File uploadDirectory = new File(this.fileUploadPath);
        if (!uploadDirectory.exists() || !uploadDirectory.isDirectory()) {
            uploadDirectory.mkdirs();
        }
        entity.setPortrait(this.fileUploadPath + entity.getId());
        File portraitFile = new File(this.fileUploadPath + entity.getId());
        if (!portraitFile.exists()) {
            portraitFile.createNewFile();
        }
        FileUtils.writeByteArrayToFile((File)portraitFile, (byte[])bytestream.toByteArray());
        this.accountManager.updateUser(entity);
        SystemVariableUtils.getSessionVariable().setUser(entity);
        result.put("status", "success");
        return result;
    }

    @ResponseBody
    @OperatingAudit(function="\u6539\u4fee\u4e2a\u4eba\u4fe1\u606f")
    @RequestMapping(value={"/change-profile"})
    public Map<String, Object> changeProfile(String realname, String email, @RequestParam(required=false) String portrait) throws IOException {
        User entity = SystemVariableUtils.getSessionVariable().getUser();
        entity.setRealname(realname);
        entity.setEmail(email);
        this.accountManager.updateUser(entity);
        SystemVariableUtils.getSessionVariable().setUser(entity);
        return MapUtils.toMap((ResourceBundle)new BeanResourceBundle((Object)entity, new String[]{"realname"}));
    }

    @RequestMapping(value={"/get-captcha"})
    public ResponseEntity<byte[]> getCaptcha(HttpSession session) throws IOException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.IMAGE_JPEG);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        String captcha = CaptchaUtils.getCaptcha((int)80, (int)32, (int)5, (OutputStream)outputStream).toLowerCase();
        session.setAttribute("captcha", (Object)captcha);
        byte[] bs = outputStream.toByteArray();
        outputStream.close();
        return new ResponseEntity((Object)bs, (MultiValueMap)headers, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-current-user-portrait"})
    public ResponseEntity<byte[]> getCurrentUserPortrait() throws IOException {
        String portrait = SystemVariableUtils.getSessionVariable().getUser().getPortrait();
        if (StringUtils.isEmpty((CharSequence)portrait)) {
            portrait = SpringMvcHolder.getRealPath((String)"") + "\\resource\\image\\empty.png";
        }
        File f = new File(portrait);
        byte[] b = FileUtils.readFileToByteArray((File)f);
        return new ResponseEntity((Object)b, HttpStatus.OK);
    }

    @RequestMapping(value={"/unauthorized"})
    public String unauthorized() {
        return "exception/unauthorized";
    }
}

