/*
 * Decompiled with CFR 0.152.
 */
package com.github.dactiv.showcase.service.account;

import com.github.dactiv.orm.core.Page;
import com.github.dactiv.orm.core.PageRequest;
import com.github.dactiv.orm.core.PropertyFilter;
import com.github.dactiv.orm.core.PropertyFilters;
import com.github.dactiv.showcase.common.SystemVariableUtils;
import com.github.dactiv.showcase.common.enumeration.entity.GroupType;
import com.github.dactiv.showcase.common.enumeration.entity.ResourceType;
import com.github.dactiv.showcase.dao.account.GroupDao;
import com.github.dactiv.showcase.dao.account.ResourceDao;
import com.github.dactiv.showcase.dao.account.UserDao;
import com.github.dactiv.showcase.entity.account.Group;
import com.github.dactiv.showcase.entity.account.Resource;
import com.github.dactiv.showcase.entity.account.User;
import com.github.dactiv.showcase.service.ServiceException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.crypto.hash.SimpleHash;
import org.hibernate.criterion.Order;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AccountManager {
    @Autowired
    private UserDao userDao;
    @Autowired
    private ResourceDao resourceDao;
    @Autowired
    private GroupDao groupDao;

    @CacheEvict(value={"shiroAuthenticationCache"}, key="T(com.github.dactiv.showcase.common.SystemVariableUtils).getSessionVariable().getUser().getUsername()")
    public void updateUserPassword(String oldPassword, String newPassword) {
        User user = SystemVariableUtils.getSessionVariable().getUser();
        oldPassword = new SimpleHash("MD5", (Object)oldPassword.toCharArray()).toString();
        if (!user.getPassword().equals(oldPassword)) {
            throw new ServiceException("\u65e7\u5bc6\u7801\u4e0d\u6b63\u786e.");
        }
        String temp = new SimpleHash("MD5", (Object)newPassword).toHex();
        this.userDao.updatePassword(user.getId(), temp);
        user.setPassword(temp);
    }

    public User getUser(String id) {
        return (User)this.userDao.load((Serializable)((Object)id));
    }

    public Page<User> searchUserPage(PageRequest request, List<PropertyFilter> filters) {
        return this.userDao.findPage(request, filters);
    }

    public void insertUser(User entity) {
        if (!this.isUsernameUnique(entity.getUsername())) {
            throw new ServiceException("\u7528\u6237\u540d\u5df2\u5b58\u5728");
        }
        String password = new SimpleHash("MD5", (Object)entity.getPassword()).toHex();
        entity.setPassword(password);
        this.userDao.insert((Object)entity);
    }

    @CacheEvict(value={"shiroAuthenticationCache"}, key="#entity.getUsername()")
    public void updateUser(User entity) {
        this.userDao.update((Object)entity);
    }

    public boolean isUsernameUnique(String username) {
        return this.getUserByUsername(username) == null;
    }

    public void deleteUsers(List<String> ids) {
        this.userDao.deleteAll(ids);
    }

    public User getUserByUsername(String username) {
        return (User)this.userDao.findUniqueByProperty("username", (Object)username);
    }

    public Resource getResource(String id) {
        return (Resource)this.resourceDao.load((Serializable)((Object)id));
    }

    public List<Resource> getResources(List<String> ids) {
        return this.resourceDao.get(ids);
    }

    public Page<Resource> searchResourcePage(PageRequest request, List<PropertyFilter> filters) {
        return this.resourceDao.findPage(request, filters);
    }

    public void saveResource(Resource entity) {
        if (entity.getSort() == null) {
            entity.setSort(Long.valueOf(this.resourceDao.entityCount(new PropertyFilter[0]) + 1L));
        }
        if (entity.getParent() != null) {
            entity.getParent().setLeaf(true);
        }
        this.resourceDao.save((Object)entity);
        this.resourceDao.refreshAllLeaf();
    }

    public void deleteResources(List<String> ids) {
        this.resourceDao.deleteAll(ids);
        this.resourceDao.refreshAllLeaf();
    }

    public List<Resource> getResources(String ... ignoreIdValue) {
        if (ArrayUtils.isNotEmpty((Object[])ignoreIdValue)) {
            return this.resourceDao.findByProperty("id", (Object)ignoreIdValue, "NIN", new Order[0]);
        }
        return this.resourceDao.getAll(new Order[0]);
    }

    public long getResourceCount() {
        return this.resourceDao.entityCount(new PropertyFilter[0]);
    }

    public List<Resource> getUserResources(String userId) {
        return this.resourceDao.getUserResources(userId);
    }

    public List<Resource> mergeResourcesToParent(List<Resource> list, ResourceType ignoreType) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (Resource r : list) {
            if (r.getParent() != null || StringUtils.equals((CharSequence)ignoreType.getValue(), (CharSequence)r.getType())) continue;
            this.mergeResourcesToParent(list, r, ignoreType);
            result.add(r);
        }
        return result;
    }

    private void mergeResourcesToParent(List<Resource> list, Resource parent, ResourceType ignoreType) {
        if (!parent.getLeaf().booleanValue()) {
            return;
        }
        parent.setChildren(new ArrayList());
        for (Resource r : list) {
            if (StringUtils.equals((CharSequence)r.getType(), (CharSequence)ignoreType.getValue()) || !StringUtils.equals((CharSequence)r.getParentId(), (CharSequence)parent.getId())) continue;
            r.setChildren(null);
            this.mergeResourcesToParent(list, r, ignoreType);
            parent.getChildren().add(r);
        }
    }

    public Group getGroup(String id) {
        return (Group)this.groupDao.load((Serializable)((Object)id));
    }

    public List<Group> getGroups(List<String> ids) {
        return this.groupDao.get(ids);
    }

    @CacheEvict(value={"shiroAuthorizationCache"}, allEntries=true)
    public void saveGroup(Group entity) {
        this.groupDao.save((Object)entity);
    }

    @CacheEvict(value={"shiroAuthorizationCache"}, allEntries=true)
    public void deleteGroups(List<String> ids) {
        this.groupDao.deleteAll(ids);
    }

    public Page<Group> searchGroupPage(PageRequest request, List<PropertyFilter> filters) {
        return this.groupDao.findPage(request, filters);
    }

    public List<Group> getGroup(GroupType groupType, String ... ignoreIdValue) {
        ArrayList<PropertyFilter> filters = new ArrayList<PropertyFilter>();
        if (ArrayUtils.isNotEmpty((Object[])ignoreIdValue)) {
            filters.add(PropertyFilters.build((String)"NES_id", (String)StringUtils.join((Object[])ignoreIdValue, (String)",")));
        }
        filters.add(PropertyFilters.build((String)"EQS_type", (String)groupType.getValue()));
        return this.groupDao.findByPropertyFilter(filters, new Order[0]);
    }

    public List<Group> getUserGroups(String userId) {
        return this.groupDao.getUserGorups(userId);
    }
}

