/*
 * Decompiled with CFR 0.152.
 */
package com.github.dactiv.showcase.entity.account;

import com.github.dactiv.common.utils.CollectionUtils;
import com.github.dactiv.showcase.common.SystemVariableUtils;
import com.github.dactiv.showcase.common.enumeration.entity.State;
import com.github.dactiv.showcase.entity.IdEntity;
import com.github.dactiv.showcase.entity.account.Resource;
import com.github.dactiv.showcase.entity.account.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.NamedQuery;

@Entity
@Table(name="TB_GROUP")
@NamedQuery(name="userGroups", query="select gl from User u left join u.groupsList gl  where u.id=?1 and gl.type= '03'")
public class Group
extends IdEntity {
    private static final long serialVersionUID = 1L;
    public static final String UserGroups = "userGroups";
    private String name;
    private List<User> membersList = new ArrayList();
    private Group parent;
    private List<Group> children = new ArrayList();
    private String type;
    private String remark;
    private int state;
    private List<Resource> resourcesList = new ArrayList();
    private String role;
    private String value;

    @Column(length=32, nullable=false, unique=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_PARENT_ID")
    public Group getParent() {
        return this.parent;
    }

    public void setParent(Group parent) {
        this.parent = parent;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="parent", cascade={CascadeType.ALL})
    public List<Group> getChildren() {
        return this.children;
    }

    public void setChildren(List<Group> children) {
        this.children = children;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="TB_GROUP_USER", joinColumns={@JoinColumn(name="FK_GROUP_ID")}, inverseJoinColumns={@JoinColumn(name="FK_USER_ID")})
    public List<User> getMembersList() {
        return this.membersList;
    }

    public void setMembersList(List<User> membersList) {
        this.membersList = membersList;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="TB_GROUP_RESOURCE", joinColumns={@JoinColumn(name="FK_GROUP_ID")}, inverseJoinColumns={@JoinColumn(name="FK_RESOURCE_ID")})
    public List<Resource> getResourcesList() {
        return this.resourcesList;
    }

    public void setResourcesList(List<Resource> resourcesList) {
        this.resourcesList = resourcesList;
    }

    @Column(nullable=false, length=2)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Column(length=512)
    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    @Column(nullable=false, length=1)
    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    @Transient
    public List<String> getMemberIds() {
        return CollectionUtils.extractToList((Collection)this.membersList, (String)"id");
    }

    @Transient
    public boolean getLeaf() {
        return this.children != null && this.children.size() > 0;
    }

    @Column(length=64)
    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    @Column(length=256)
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Transient
    public String getParentId() {
        return this.parent == null ? "" : this.parent.getId();
    }

    @Transient
    public String getParentName() {
        return this.parent == null ? "" : this.parent.getName();
    }

    @Transient
    public String getStateName() {
        return SystemVariableUtils.getName(State.class, (Object)this.state);
    }
}

