/*
 * Decompiled with CFR 0.152.
 */
package com.github.dactiv.showcase.common;

import com.github.dactiv.showcase.common.SessionVariable;
import com.github.dactiv.showcase.common.enumeration.SystemDictionaryCode;
import com.github.dactiv.showcase.common.enumeration.ValueEnum;
import com.github.dactiv.showcase.entity.foundation.variable.DataDictionary;
import com.github.dactiv.showcase.service.foundation.SystemVariableManager;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SystemVariableUtils {
    public static String DEFAULT_DICTIONARY_VALUE = "\u65e0";
    private static SystemVariableManager systemVariableManager;

    @Autowired
    public void setSystemVariableManager(SystemVariableManager systemDictionaryManager) {
        systemVariableManager = systemDictionaryManager;
    }

    @PostConstruct
    public void init() {
    }

    public static String getName(SystemDictionaryCode systemDictionaryCode, Object value) {
        if (value == null || systemDictionaryCode == null) {
            return DEFAULT_DICTIONARY_VALUE;
        }
        if (value instanceof String && StringUtils.isEmpty((CharSequence)value.toString())) {
            return DEFAULT_DICTIONARY_VALUE;
        }
        List dataDictionaries = systemVariableManager.getDataDictionariesByCategoryCode(systemDictionaryCode, new String[0]);
        for (DataDictionary dataDictionary : dataDictionaries) {
            if (!StringUtils.equals((CharSequence)dataDictionary.getValue(), (CharSequence)value.toString())) continue;
            return dataDictionary.getName();
        }
        return DEFAULT_DICTIONARY_VALUE;
    }

    public static String getName(Class<? extends Enum<? extends ValueEnum<?>>> enumClass, Object value) {
        Enum<? extends ValueEnum<?>>[] values;
        if (value == null || enumClass == null) {
            return DEFAULT_DICTIONARY_VALUE;
        }
        if (value instanceof String && StringUtils.isEmpty((CharSequence)value.toString())) {
            return DEFAULT_DICTIONARY_VALUE;
        }
        for (Enum<? extends ValueEnum<?>> o : values = enumClass.getEnumConstants()) {
            ValueEnum ve = (ValueEnum)o;
            if (!StringUtils.equals((CharSequence)ve.getValue().toString(), (CharSequence)value.toString())) continue;
            return ve.getName();
        }
        return DEFAULT_DICTIONARY_VALUE;
    }

    public static List<DataDictionary> getVariables(SystemDictionaryCode code, String ... ignoreValue) {
        return systemVariableManager.getDataDictionariesByCategoryCode(code, ignoreValue);
    }

    public static List<DataDictionary> getVariables(Class<? extends Enum<? extends ValueEnum<?>>> enumClass, Object ... ignoreValue) {
        Enum<? extends ValueEnum<?>>[] values;
        ArrayList result = Lists.newArrayList();
        for (Enum<? extends ValueEnum<?>> o : values = enumClass.getEnumConstants()) {
            ValueEnum ve = (ValueEnum)o;
            Object value = ve.getValue();
            if (ArrayUtils.contains((Object[])ignoreValue, (Object)value)) continue;
            String type = value.getClass().getSimpleName();
            if (type.equals("Date")) {
                type = "D";
            } else if (type.equals("Double")) {
                type = "N";
            }
            result.add(new DataDictionary(ve.getName(), value.toString(), StringUtils.substring((String)type, (int)0, (int)1)));
        }
        return result;
    }

    public static SessionVariable getSessionVariable() {
        Subject subject = SecurityUtils.getSubject();
        if (subject != null && subject.getPrincipal() != null && subject.getPrincipal() instanceof SessionVariable) {
            return (SessionVariable)subject.getPrincipal();
        }
        return null;
    }

    public static boolean isAuthenticated() {
        return SecurityUtils.getSubject().isAuthenticated();
    }
}

