/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.pd1;

import com.daxie.basis.vector.Vector;
import com.daxie.log.LogFile;
import com.daxie.tool.ByteFunctions;
import com.daxie.tool.ExceptionFunctions;
import com.daxie.xops.pd1.PD1Point;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;

class PD1Writer {
    private List<PD1Point> points;

    public PD1Writer(List<PD1Point> points) {
        this.points = points;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Write(String pd1_filename) throws FileNotFoundException {
        if (this.points == null) {
            LogFile.WriteWarn((String)"[PD1Writer-Write] Data is null.", (boolean)true);
            return;
        }
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(pd1_filename)));
        try {
            int point_num = this.points.size();
            byte[] point_num_buffer = ByteFunctions.ushort_to_byte_le((int)point_num);
            dos.write(point_num_buffer);
            for (int i = 0; i < this.points.size(); ++i) {
                PD1Point point = this.points.get(i);
                Vector position = point.GetPosition();
                float rotation = point.GetRotation();
                int[] parameters = point.GetParameters();
                byte[] b = ByteFunctions.float_to_byte_le((float)position.GetX());
                dos.write(b);
                b = ByteFunctions.float_to_byte_le((float)position.GetY());
                dos.write(b);
                b = ByteFunctions.float_to_byte_le((float)position.GetZ());
                dos.write(b);
                b = ByteFunctions.float_to_byte_le((float)rotation);
                dos.write(b);
                for (int j = 0; j < 4; ++j) {
                    byte btemp = (byte)parameters[j];
                    dos.writeByte(btemp);
                }
            }
            dos.flush();
        }
        catch (IOException e) {
            String str = ExceptionFunctions.GetPrintStackTraceString((Throwable)e);
            LogFile.WriteWarn((String)"[PD1Writer-Write] Below is the stack trace.", (boolean)true);
            LogFile.WriteWarn((String)str, (boolean)false);
            return;
        }
        finally {
            try {
                dos.close();
            }
            catch (IOException e) {
                String str = ExceptionFunctions.GetPrintStackTraceString((Throwable)e);
                LogFile.WriteWarn((String)"[PD1Writer-Write] Below is the stack trace.", (boolean)true);
                LogFile.WriteWarn((String)str, (boolean)false);
                return;
            }
        }
    }
}

