/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.mif;

import com.daxie.log.LogFile;
import com.daxie.tool.ExceptionFunctions;
import com.daxie.tool.FileFunctions;
import com.daxie.tool.XMLFunctions;
import com.daxie.xops.mif.MIFManipulator;
import com.daxie.xops.mif.MissionInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MIFList {
    public static final int MISSION_NAME = 1;
    public static final int MISSION_FORMAL_NAME = 2;
    public static final int BD1_FILENAME = 4;
    public static final int PD1_FILENAME = 8;
    public static final int SKY_TYPE = 16;
    public static final int EXTRA_HITCHECK_FLAG = 32;
    public static final int DARKEN_SCREEN_FLAG = 64;
    public static final int ARTICLE_INFO_FILENAME = 128;
    public static final int IMAGE1_FILENAME = 256;
    public static final int IMAGE2_FILENAME = 512;
    public static final int BRIEFING_TEXT = 1024;
    public static final int NONE = 0;
    public static final int ALL = 2047;
    private static String str_mission_name = "Mission name";
    private static String str_mission_formal_name = "Mission formal name";
    private static String str_bd1_filename = "BD1 filename";
    private static String str_pd1_filename = "PD1 filename";
    private static String str_sky_type = "Sky type";
    private static String str_extra_hitcheck_flag = "Extra hitcheck flag";
    private static String str_darken_screen_flag = "Darken screen flag";
    private static String str_article_info_filename = "Article info filename";
    private static String str_image1_filename = "Image 1 filename";
    private static String str_image2_filename = "Image 2 filename";
    private static String str_briefing_text = "Briefing text";
    private Map<String, MissionInfo> mission_info_map = new HashMap<String, MissionInfo>();

    public static void SetStrMissionName(String a_str_mission_name) {
        str_mission_name = a_str_mission_name;
    }

    public static void SetStrMissionFormalName(String a_str_mission_formal_name) {
        str_mission_formal_name = a_str_mission_formal_name;
    }

    public static void SetStrBD1Filename(String a_str_bd1_filename) {
        str_bd1_filename = a_str_bd1_filename;
    }

    public static void SetStrPD1Filename(String a_str_pd1_filename) {
        str_pd1_filename = a_str_pd1_filename;
    }

    public static void SetStrSkyType(String a_str_sky_type) {
        str_sky_type = a_str_sky_type;
    }

    public static void SetStrExtraHitcheckFlag(String a_str_extra_hitcheck_flag) {
        str_extra_hitcheck_flag = a_str_extra_hitcheck_flag;
    }

    public static void SetStrDarkenScreenFlag(String a_darken_screen_flag) {
        str_darken_screen_flag = a_darken_screen_flag;
    }

    public static void SetStrArticleInfoFilename(String a_article_info_filename) {
        str_article_info_filename = a_article_info_filename;
    }

    public static void SetStrImage1Filename(String a_str_image1_filename) {
        str_image1_filename = a_str_image1_filename;
    }

    public static void SetStrImage2Filename(String a_str_image2_filename) {
        str_image2_filename = a_str_image2_filename;
    }

    public static void SetStrBriefingText(String a_str_briefing_text) {
        str_briefing_text = a_str_briefing_text;
    }

    public MIFList(String directory_name, String encoding) throws UnsupportedEncodingException {
        File dir = new File(directory_name);
        if (!dir.isDirectory()) {
            LogFile.WriteWarn((String)("[MIFList-<init>] Not a directory. directory_name:" + directory_name), (boolean)true);
            return;
        }
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith("mif") || name.endsWith("MIF");
            }
        };
        File[] files = dir.listFiles(filter);
        if (files == null) {
            LogFile.WriteWarn((String)"[MIFList-<init>] listFiles() returned null.", (boolean)true);
            return;
        }
        for (File file : files) {
            MIFManipulator mif_manipulator = null;
            try {
                mif_manipulator = new MIFManipulator(file.getPath(), encoding);
            }
            catch (FileNotFoundException e) {
                LogFile.WriteWarn((String)("[MIFList-<init>] Failed to load a MIF file. filename:" + file.getPath()), (boolean)true);
                return;
            }
            MissionInfo mif = mif_manipulator.GetMissionInfo();
            this.mission_info_map.put(file.getName(), mif);
        }
    }

    public void ShowList(int flags) {
        for (Map.Entry<String, MissionInfo> entry : this.mission_info_map.entrySet()) {
            System.out.println("[" + entry.getKey() + "]");
            MissionInfo mif = entry.getValue();
            if ((flags & 1) != 0) {
                System.out.print("mission_name:");
                System.out.println(mif.GetMissionName());
            }
            if ((flags & 2) != 0) {
                System.out.print("mission_formal_name:");
                System.out.println(mif.GetMissionFormalName());
            }
            if ((flags & 4) != 0) {
                System.out.print("bd1_filename:");
                System.out.println(mif.GetBD1Filename());
            }
            if ((flags & 8) != 0) {
                System.out.print("pd1_filename:");
                System.out.println(mif.GetPD1Filename());
            }
            if ((flags & 0x10) != 0) {
                System.out.print("sky_type:");
                System.out.println(mif.GetSkyType());
            }
            if ((flags & 0x20) != 0) {
                System.out.print("extra_hitcheck_flag:");
                System.out.println(mif.GetExtraHitcheckFlag());
            }
            if ((flags & 0x40) != 0) {
                System.out.print("darken_screen_flag:");
                System.out.println(mif.GetDarkenScreenFlag());
            }
            if ((flags & 0x80) != 0) {
                System.out.print("article_info_filename:");
                System.out.println(mif.GetArticleInfoFilename());
            }
            if ((flags & 0x100) != 0) {
                System.out.print("image1_filename:");
                System.out.println(mif.GetImage1Filename());
            }
            if ((flags & 0x200) != 0) {
                System.out.print("image2_filename:");
                System.out.println(mif.GetImage2Filename());
            }
            if ((flags & 0x400) != 0) {
                System.out.println("briefing_text:");
                List<String> briefing_text = mif.GetBriefingText();
                for (String line : briefing_text) {
                    System.out.println(line);
                }
            }
            System.out.println("------------------------------");
        }
    }

    public int WriteXML(String xml_filename, int flags) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            String str = ExceptionFunctions.GetPrintStackTraceString((Throwable)e);
            LogFile.WriteWarn((String)"[MIFList-WriteXML] Below is the stack trace.", (boolean)true);
            LogFile.WriteWarn((String)str, (boolean)false);
            return -1;
        }
        Document document = builder.newDocument();
        Element el_addon_list = document.createElement("addon_list");
        document.appendChild(el_addon_list);
        for (Map.Entry<String, MissionInfo> entry : this.mission_info_map.entrySet()) {
            Element el_mission = document.createElement(entry.getKey());
            MissionInfo mif = entry.getValue();
            if ((flags & 1) != 0) {
                Element el_mission_name = document.createElement("mission_name");
                el_mission_name.appendChild(document.createTextNode(mif.GetMissionName()));
                el_mission.appendChild(el_mission_name);
            }
            if ((flags & 2) != 0) {
                Element el_mission_formal_name = document.createElement("mission_formal_name");
                el_mission_formal_name.appendChild(document.createTextNode(mif.GetMissionFormalName()));
                el_mission.appendChild(el_mission_formal_name);
            }
            if ((flags & 4) != 0) {
                Element el_bd1_filename = document.createElement("bd1_filename");
                el_bd1_filename.appendChild(document.createTextNode(mif.GetBD1Filename()));
                el_mission.appendChild(el_bd1_filename);
            }
            if ((flags & 8) != 0) {
                Element el_pd1_filename = document.createElement("pd1_filename");
                el_pd1_filename.appendChild(document.createTextNode(mif.GetPD1Filename()));
                el_mission.appendChild(el_pd1_filename);
            }
            if ((flags & 0x10) != 0) {
                Element el_sky_type = document.createElement("sky_type");
                el_sky_type.appendChild(document.createTextNode("" + mif.GetSkyType()));
                el_mission.appendChild(el_sky_type);
            }
            if ((flags & 0x20) != 0) {
                Element el_extra_hitcheck_flag = document.createElement("extra_hitcheck_flag");
                el_extra_hitcheck_flag.appendChild(document.createTextNode("" + mif.GetExtraHitcheckFlag()));
                el_mission.appendChild(el_extra_hitcheck_flag);
            }
            if ((flags & 0x40) != 0) {
                Element el_darken_screen_flag = document.createElement("darken_screen_flag");
                el_darken_screen_flag.appendChild(document.createTextNode("" + mif.GetDarkenScreenFlag()));
                el_mission.appendChild(el_darken_screen_flag);
            }
            if ((flags & 0x80) != 0) {
                Element el_article_info_filename = document.createElement("article_info_filename");
                el_article_info_filename.appendChild(document.createTextNode(mif.GetArticleInfoFilename()));
                el_mission.appendChild(el_article_info_filename);
            }
            if ((flags & 0x100) != 0) {
                Element el_image1_filename = document.createElement("image1_filename");
                el_image1_filename.appendChild(document.createTextNode(mif.GetImage1Filename()));
                el_mission.appendChild(el_image1_filename);
            }
            if ((flags & 0x200) != 0) {
                Element el_image2_filename = document.createElement("image2_filename");
                el_image2_filename.appendChild(document.createTextNode(mif.GetImage2Filename()));
                el_mission.appendChild(el_image2_filename);
            }
            if ((flags & 0x400) != 0) {
                List<String> briefing_text_lines = mif.GetBriefingText();
                int line_count = 0;
                Element el_briefing_text = document.createElement("briefing_text");
                el_mission.appendChild(el_briefing_text);
                for (String line : briefing_text_lines) {
                    Element el_briefing_line = document.createElement("line" + line_count);
                    el_briefing_line.appendChild(document.createTextNode(line));
                    el_briefing_text.appendChild(el_briefing_line);
                    ++line_count;
                }
            }
            el_addon_list.appendChild(el_mission);
        }
        File file = new File(xml_filename);
        int res = XMLFunctions.WriteXML((File)file, (Document)document);
        if (res < 0) {
            return -1;
        }
        return 0;
    }

    public int WriteCSV(String csv_filename, int flags) {
        ArrayList<String> lines = new ArrayList<String>();
        String columns = "";
        if ((flags & 1) != 0) {
            columns = columns + "\"" + str_mission_name + "\",";
        }
        if ((flags & 2) != 0) {
            columns = columns + "\"" + str_mission_formal_name + "\",";
        }
        if ((flags & 4) != 0) {
            columns = columns + "\"" + str_bd1_filename + "\",";
        }
        if ((flags & 8) != 0) {
            columns = columns + "\"" + str_pd1_filename + "\",";
        }
        if ((flags & 0x10) != 0) {
            columns = columns + "\"" + str_sky_type + "\",";
        }
        if ((flags & 0x20) != 0) {
            columns = columns + "\"" + str_extra_hitcheck_flag + "\",";
        }
        if ((flags & 0x40) != 0) {
            columns = columns + "\"" + str_darken_screen_flag + "\",";
        }
        if ((flags & 0x80) != 0) {
            columns = columns + "\"" + str_article_info_filename + "\",";
        }
        if ((flags & 0x100) != 0) {
            columns = columns + "\"" + str_image1_filename + "\",";
        }
        if ((flags & 0x200) != 0) {
            columns = columns + "\"" + str_image2_filename + "\",";
        }
        if ((flags & 0x400) != 0) {
            columns = columns + "\"" + str_briefing_text + "\",";
        }
        if (columns.charAt(columns.length() - 1) == ',') {
            columns = columns.substring(0, columns.length() - 1);
        }
        lines.add(columns);
        for (Map.Entry<String, MissionInfo> entry : this.mission_info_map.entrySet()) {
            MissionInfo mif = entry.getValue();
            String line = "";
            if ((flags & 1) != 0) {
                line = line + mif.GetMissionName() + ",";
            }
            if ((flags & 2) != 0) {
                line = line + mif.GetMissionFormalName() + ",";
            }
            if ((flags & 4) != 0) {
                line = line + mif.GetBD1Filename() + ",";
            }
            if ((flags & 8) != 0) {
                line = line + mif.GetPD1Filename() + ",";
            }
            if ((flags & 0x10) != 0) {
                line = line + mif.GetSkyType() + ",";
            }
            if ((flags & 0x20) != 0) {
                boolean extra_hitcheck_flag = mif.GetExtraHitcheckFlag();
                line = !extra_hitcheck_flag ? line + "false" : line + "true";
                line = line + ",";
            }
            if ((flags & 0x40) != 0) {
                boolean darken_screen_flag = mif.GetDarkenScreenFlag();
                line = !darken_screen_flag ? line + "false" : line + "true";
                line = line + ",";
            }
            if ((flags & 0x80) != 0) {
                line = line + mif.GetArticleInfoFilename() + ",";
            }
            if ((flags & 0x100) != 0) {
                line = line + mif.GetImage1Filename() + ",";
            }
            if ((flags & 0x200) != 0) {
                line = line + mif.GetImage2Filename() + ",";
            }
            if ((flags & 0x400) != 0) {
                line = line + "\"";
                List<String> briefing_text = mif.GetBriefingText();
                for (String btline : briefing_text) {
                    line = line + btline + "<br>";
                }
                line = line + "\",";
            }
            lines.add(line);
        }
        try {
            FileFunctions.CreateTextFile((String)csv_filename, (String)"UTF-8", lines);
        }
        catch (FileNotFoundException e) {
            String str = ExceptionFunctions.GetPrintStackTraceString((Throwable)e);
            LogFile.WriteWarn((String)"[MIFList-WriteCSV] Failed to write in a file.", (boolean)true);
            LogFile.WriteWarn((String)"Below is the stack trace.", (boolean)false);
            LogFile.WriteWarn((String)str, (boolean)false);
            return -1;
        }
        catch (UnsupportedEncodingException e) {
            LogFile.WriteWarn((String)"[MIFList-WriteCSV] Unsupported encoding specified.", (boolean)true);
            return -1;
        }
        return 0;
    }
}

