/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.bd1;

import com.daxie.basis.vector.Vector;
import com.daxie.log.LogFile;
import com.daxie.tool.ByteFunctions;
import com.daxie.tool.ExceptionFunctions;
import com.daxie.xops.bd1.BD1Block;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

class BD1Writer {
    private List<BD1Block> blocks;
    private Map<Integer, String> texture_filenames_map;

    public BD1Writer(List<BD1Block> blocks, Map<Integer, String> texture_filenames_map) {
        this.blocks = blocks;
        this.texture_filenames_map = texture_filenames_map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Write(String bd1_filename) throws FileNotFoundException {
        if (this.blocks == null || this.texture_filenames_map == null) {
            LogFile.WriteWarn((String)"[BD1Writer-Write] Data is null.", (boolean)true);
            return;
        }
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(bd1_filename)));
        try {
            int i;
            TreeMap<Integer, String> sorted_texture_filenames_map = new TreeMap<Integer, String>(this.texture_filenames_map);
            int texture_count = 0;
            Iterator iterator = sorted_texture_filenames_map.keySet().iterator();
            while (iterator.hasNext()) {
                int pos;
                int texture_id = (Integer)iterator.next();
                String texture_filename = (String)sorted_texture_filenames_map.get(texture_id);
                if (texture_filename.length() > 30) {
                    texture_filename = texture_filename.substring(0, 30);
                }
                byte[] texture_filename_buffer = new byte[31];
                for (pos = 0; pos < texture_filename.length(); ++pos) {
                    texture_filename_buffer[pos] = (byte)texture_filename.charAt(pos);
                }
                while (pos < texture_filename_buffer.length) {
                    texture_filename_buffer[pos] = 0;
                    ++pos;
                }
                dos.write(texture_filename_buffer);
                ++texture_count;
            }
            byte[] null_buffer = new byte[31];
            for (i = 0; i < 31; ++i) {
                null_buffer[i] = 0;
            }
            for (i = texture_count; i < 10; ++i) {
                dos.write(null_buffer);
            }
            int block_num = this.blocks.size();
            byte[] block_num_buffer = ByteFunctions.ushort_to_byte_le((int)block_num);
            dos.write(block_num_buffer);
            for (int i2 = 0; i2 < this.blocks.size(); ++i2) {
                byte[] b;
                int j;
                BD1Block block = this.blocks.get(i2);
                Vector[] vertex_positions = block.GetVertexPositions();
                float[] us = block.GetUs();
                float[] vs = block.GetVs();
                int[] texture_ids = block.GetTextureIDs();
                for (j = 0; j < 8; ++j) {
                    b = ByteFunctions.float_to_byte_le((float)vertex_positions[j].GetX());
                    dos.write(b);
                }
                for (j = 0; j < 8; ++j) {
                    b = ByteFunctions.float_to_byte_le((float)vertex_positions[j].GetY());
                    dos.write(b);
                }
                for (j = 0; j < 8; ++j) {
                    b = ByteFunctions.float_to_byte_le((float)vertex_positions[j].GetZ());
                    dos.write(b);
                }
                for (j = 0; j < 24; ++j) {
                    b = ByteFunctions.float_to_byte_le((float)us[j]);
                    dos.write(b);
                }
                for (j = 0; j < 24; ++j) {
                    b = ByteFunctions.float_to_byte_le((float)vs[j]);
                    dos.write(b);
                }
                for (j = 0; j < 6; ++j) {
                    dos.writeByte(texture_ids[j]);
                    for (int k = 0; k < 3; ++k) {
                        dos.writeByte(0);
                    }
                }
                if (block.GetEnabledFlag()) {
                    dos.writeByte(1);
                } else {
                    dos.writeByte(0);
                }
                for (j = 0; j < 3; ++j) {
                    dos.writeByte(0);
                }
            }
            dos.flush();
        }
        catch (IOException e) {
            String str = ExceptionFunctions.GetPrintStackTraceString((Throwable)e);
            LogFile.WriteWarn((String)"[BD1Writer-Write] Below is the stack trace.", (boolean)true);
            LogFile.WriteWarn((String)str, (boolean)false);
            return;
        }
        finally {
            try {
                dos.close();
            }
            catch (IOException e) {
                String str = ExceptionFunctions.GetPrintStackTraceString((Throwable)e);
                LogFile.WriteWarn((String)"[BD1Writer-Write] Below is the stack trace.", (boolean)true);
                LogFile.WriteWarn((String)str, (boolean)false);
                return;
            }
        }
    }
}

