/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.weapon;

import com.daxie.log.LogFile;
import com.daxie.xops.weapon.WeaponModelType;
import com.daxie.xops.weapon.WeaponScopeMode;
import com.daxie.xops.weapon.WeaponShootingStance;
import com.daxie.xops.weapon.WeaponTextureType;

public class WeaponBinSpecifierAndEnumConverter {
    public static WeaponModelType GetWeaponModelTypeFromBinSpecifier(int spc) {
        WeaponModelType model_type;
        switch (spc) {
            case 0: {
                model_type = WeaponModelType.NONE;
                break;
            }
            case 11: {
                model_type = WeaponModelType.MP5;
                break;
            }
            case 10: {
                model_type = WeaponModelType.PSG_1;
                break;
            }
            case 13: {
                model_type = WeaponModelType.M92F;
                break;
            }
            case 16: {
                model_type = WeaponModelType.GLOCK;
                break;
            }
            case 21: {
                model_type = WeaponModelType.DESERT_EAGLE;
                break;
            }
            case 14: {
                model_type = WeaponModelType.MAC10;
                break;
            }
            case 30: {
                model_type = WeaponModelType.UMP;
                break;
            }
            case 15: {
                model_type = WeaponModelType.P90;
                break;
            }
            case 29: {
                model_type = WeaponModelType.M4;
                break;
            }
            case 24: {
                model_type = WeaponModelType.AK47;
                break;
            }
            case 22: {
                model_type = WeaponModelType.AUG;
                break;
            }
            case 28: {
                model_type = WeaponModelType.M249;
                break;
            }
            case 23: {
                model_type = WeaponModelType.GRENADE;
                break;
            }
            case 25: {
                model_type = WeaponModelType.MP5SD;
                break;
            }
            case 32: {
                model_type = WeaponModelType.CASE;
                break;
            }
            case 34: {
                model_type = WeaponModelType.M1911;
                break;
            }
            case 57: {
                model_type = WeaponModelType.M1;
                break;
            }
            case 58: {
                model_type = WeaponModelType.FAMAS;
                break;
            }
            case 59: {
                model_type = WeaponModelType.MK23;
                break;
            }
            case 60: {
                model_type = WeaponModelType.MK23SD;
                break;
            }
            default: {
                LogFile.WriteWarn((String)"[WeaponBinSpecifierAndEnumConverter-GetWeaponModelTypeFromBinSpecifier]", (boolean)true);
                LogFile.WriteWarn((String)("Unknown model type specifier. specifier:" + spc), (boolean)false);
                model_type = WeaponModelType.NONE;
            }
        }
        return model_type;
    }

    public static int GetBinSpecifierFromWeaponModelType(WeaponModelType model_type) {
        int spc = 0;
        switch (model_type) {
            case NONE: {
                spc = 0;
                break;
            }
            case MP5: {
                spc = 11;
                break;
            }
            case PSG_1: {
                spc = 10;
                break;
            }
            case M92F: {
                spc = 13;
                break;
            }
            case GLOCK: {
                spc = 16;
                break;
            }
            case DESERT_EAGLE: {
                spc = 21;
                break;
            }
            case MAC10: {
                spc = 14;
                break;
            }
            case UMP: {
                spc = 30;
                break;
            }
            case P90: {
                spc = 15;
                break;
            }
            case M4: {
                spc = 29;
                break;
            }
            case AK47: {
                spc = 24;
                break;
            }
            case AUG: {
                spc = 22;
                break;
            }
            case M249: {
                spc = 28;
                break;
            }
            case GRENADE: {
                spc = 23;
                break;
            }
            case MP5SD: {
                spc = 25;
                break;
            }
            case CASE: {
                spc = 32;
                break;
            }
            case M1911: {
                spc = 34;
                break;
            }
            case M1: {
                spc = 57;
                break;
            }
            case FAMAS: {
                spc = 58;
                break;
            }
            case MK23: {
                spc = 59;
                break;
            }
            case MK23SD: {
                spc = 60;
            }
        }
        return spc;
    }

    public static WeaponTextureType GetWeaponTextureTypeFromBinSpecifier(int spc) {
        WeaponTextureType texture_type;
        switch (spc) {
            case 0: {
                texture_type = WeaponTextureType.NONE;
                break;
            }
            case 16: {
                texture_type = WeaponTextureType.MP5;
                break;
            }
            case 11: {
                texture_type = WeaponTextureType.PSG_1;
                break;
            }
            case 19: {
                texture_type = WeaponTextureType.M92F;
                break;
            }
            case 17: {
                texture_type = WeaponTextureType.GLOCK18;
                break;
            }
            case 50: {
                texture_type = WeaponTextureType.DESERT_EAGLE;
                break;
            }
            case 40: {
                texture_type = WeaponTextureType.MAC10;
                break;
            }
            case 39: {
                texture_type = WeaponTextureType.UMP;
                break;
            }
            case 36: {
                texture_type = WeaponTextureType.P90;
                break;
            }
            case 38: {
                texture_type = WeaponTextureType.M4;
                break;
            }
            case 33: {
                texture_type = WeaponTextureType.AK47;
                break;
            }
            case 51: {
                texture_type = WeaponTextureType.AUG;
                break;
            }
            case 37: {
                texture_type = WeaponTextureType.M249;
                break;
            }
            case 32: {
                texture_type = WeaponTextureType.GRENADE;
                break;
            }
            case 34: {
                texture_type = WeaponTextureType.MP5SD;
                break;
            }
            case 44: {
                texture_type = WeaponTextureType.CASE;
                break;
            }
            case 45: {
                texture_type = WeaponTextureType.M1911;
                break;
            }
            case 48: {
                texture_type = WeaponTextureType.GLOCK17;
                break;
            }
            case 54: {
                texture_type = WeaponTextureType.M1;
                break;
            }
            case 55: {
                texture_type = WeaponTextureType.FAMAS;
                break;
            }
            case 56: {
                texture_type = WeaponTextureType.MK23;
                break;
            }
            default: {
                LogFile.WriteWarn((String)"[WeaponBinSpecifierAndEnumConverter-GetWeaponTextureTypeFromBinSpecifier]", (boolean)true);
                LogFile.WriteWarn((String)("Unknown texture type specifier. specifier:" + spc), (boolean)false);
                texture_type = WeaponTextureType.NONE;
            }
        }
        return texture_type;
    }

    public static int GetBinSpecifierFromWeaponTextureType(WeaponTextureType texture_type) {
        int spc = 0;
        switch (texture_type) {
            case NONE: {
                spc = 0;
                break;
            }
            case MP5: {
                spc = 16;
                break;
            }
            case PSG_1: {
                spc = 11;
                break;
            }
            case M92F: {
                spc = 19;
                break;
            }
            case GLOCK18: {
                spc = 17;
                break;
            }
            case DESERT_EAGLE: {
                spc = 50;
                break;
            }
            case MAC10: {
                spc = 40;
                break;
            }
            case UMP: {
                spc = 39;
                break;
            }
            case P90: {
                spc = 36;
                break;
            }
            case M4: {
                spc = 38;
                break;
            }
            case AK47: {
                spc = 33;
                break;
            }
            case AUG: {
                spc = 51;
                break;
            }
            case M249: {
                spc = 37;
                break;
            }
            case GRENADE: {
                spc = 32;
                break;
            }
            case MP5SD: {
                spc = 34;
                break;
            }
            case CASE: {
                spc = 44;
                break;
            }
            case M1911: {
                spc = 45;
                break;
            }
            case GLOCK17: {
                spc = 48;
                break;
            }
            case M1: {
                spc = 54;
                break;
            }
            case FAMAS: {
                spc = 55;
                break;
            }
            case MK23: {
                spc = 56;
            }
        }
        return spc;
    }

    public static WeaponShootingStance GetWeaponShootingStanceFromBinSpecifier(int spc) {
        WeaponShootingStance shooting_stance;
        switch (spc) {
            case 8: {
                shooting_stance = WeaponShootingStance.RIFLE;
                break;
            }
            case 9: {
                shooting_stance = WeaponShootingStance.HANDGUN;
                break;
            }
            case 27: {
                shooting_stance = WeaponShootingStance.CARRY;
                break;
            }
            default: {
                LogFile.WriteWarn((String)"[WeaponBinSpecifierAndEnumConverter-GetWeaponShootingStanceFromBinSpecifier]", (boolean)true);
                LogFile.WriteWarn((String)("Unknown equipment method specifier. specifier:" + spc), (boolean)false);
                shooting_stance = WeaponShootingStance.RIFLE;
            }
        }
        return shooting_stance;
    }

    public static int GetBinSpecifierFromWeaponShootingStance(WeaponShootingStance shooting_stance) {
        int spc = 8;
        switch (shooting_stance) {
            case RIFLE: {
                spc = 8;
                break;
            }
            case HANDGUN: {
                spc = 9;
                break;
            }
            case CARRY: {
                spc = 27;
            }
        }
        return spc;
    }

    public static WeaponScopeMode GetWeaponScopeModeFromBinSpecifier(int spc) {
        WeaponScopeMode scope_mode;
        switch (spc) {
            case 0: {
                scope_mode = WeaponScopeMode.NONE;
                break;
            }
            case 1: {
                scope_mode = WeaponScopeMode.LOW;
                break;
            }
            case 2: {
                scope_mode = WeaponScopeMode.HIGH;
                break;
            }
            case 3: {
                scope_mode = WeaponScopeMode.EQUAL;
                break;
            }
            default: {
                LogFile.WriteWarn((String)"[WeaponBinSpecifierAndEnumConverter-GetWeaponScopeModeFromBinSpecifier]", (boolean)true);
                LogFile.WriteWarn((String)("Unknown scope mode specifier. specifier:" + spc), (boolean)false);
                scope_mode = WeaponScopeMode.NONE;
            }
        }
        return scope_mode;
    }

    public static int GetBinSpecifierFromWeaponScopeMode(WeaponScopeMode scope_mode) {
        int spc = 0;
        switch (scope_mode) {
            case NONE: {
                spc = 0;
                break;
            }
            case LOW: {
                spc = 1;
                break;
            }
            case HIGH: {
                spc = 2;
                break;
            }
            case EQUAL: {
                spc = 3;
            }
        }
        return spc;
    }
}

