/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.pd1;

import com.daxie.tool.ByteFunctions;
import com.daxie.tool.FileFunctions;
import com.daxie.xops.pd1.PD1Point;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;

class PD1Parser {
    private List<PD1Point> points = new ArrayList<PD1Point>();

    public PD1Parser(String pd1_filename) throws FileNotFoundException {
        List bin = FileFunctions.GetFileAllBin((String)pd1_filename);
        int count = 0;
        byte[] point_num_buffer = new byte[]{(Byte)bin.get(count), (Byte)bin.get(count + 1)};
        int point_num = ByteFunctions.byte_to_ushort_le((byte[])point_num_buffer);
        count += 2;
        for (int i = 0; i < point_num; ++i) {
            int j;
            PD1Point point = new PD1Point();
            byte[] byte_buffer = new byte[4];
            for (j = 0; j < 4; ++j) {
                byte_buffer[j] = (Byte)bin.get(count);
                ++count;
            }
            float ftemp = ByteFunctions.byte_to_float_le((byte[])byte_buffer);
            point.SetPositionX(ftemp);
            for (j = 0; j < 4; ++j) {
                byte_buffer[j] = (Byte)bin.get(count);
                ++count;
            }
            ftemp = ByteFunctions.byte_to_float_le((byte[])byte_buffer);
            point.SetPositionY(ftemp);
            for (j = 0; j < 4; ++j) {
                byte_buffer[j] = (Byte)bin.get(count);
                ++count;
            }
            ftemp = ByteFunctions.byte_to_float_le((byte[])byte_buffer);
            point.SetPositionZ(ftemp);
            for (j = 0; j < 4; ++j) {
                byte_buffer[j] = (Byte)bin.get(count);
                ++count;
            }
            ftemp = ByteFunctions.byte_to_float_le((byte[])byte_buffer);
            point.SetRotation(ftemp);
            for (int j2 = 0; j2 < 4; ++j2) {
                int itemp = Byte.toUnsignedInt((Byte)bin.get(count));
                ++count;
                point.SetParameter(j2, itemp);
            }
            this.points.add(point);
        }
    }

    public List<PD1Point> GetPoints() {
        return new ArrayList<PD1Point>(this.points);
    }
}

