/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.exe;

import com.daxie.basis.vector.Vector;
import com.daxie.tool.ByteFunctions;
import com.daxie.xops.weapon.WeaponBinSpecifierAndEnumConverter;
import com.daxie.xops.weapon.WeaponData;
import com.daxie.xops.weapon.WeaponModelFilenamesStock;
import com.daxie.xops.weapon.WeaponModelType;
import com.daxie.xops.weapon.WeaponScopeMode;
import com.daxie.xops.weapon.WeaponShootingStance;
import com.daxie.xops.weapon.WeaponTextureFilenamesStock;
import com.daxie.xops.weapon.WeaponTextureType;
import java.util.List;

class XOPSExeWeaponDataParser {
    private WeaponData[] weapon_data_array = new WeaponData[23];

    public XOPSExeWeaponDataParser(List<Byte> bin, int weapon_data_start_pos, int weapon_name_start_pos) {
        for (int i = 0; i < 23; ++i) {
            this.weapon_data_array[i] = new WeaponData();
        }
        int pos = weapon_data_start_pos;
        for (int i = 0; i < 23; ++i) {
            byte[] b = new byte[]{bin.get(pos), bin.get(pos + 1)};
            short itemp = ByteFunctions.byte_to_short_le(b);
            this.weapon_data_array[i].SetAttackPower(itemp);
            b[0] = bin.get(pos += 2);
            b[1] = bin.get(pos + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            this.weapon_data_array[i].SetPenetration(itemp);
            b[0] = bin.get(pos += 2);
            b[1] = bin.get(pos + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            this.weapon_data_array[i].SetFiringInterval(itemp);
            b[0] = bin.get(pos += 2);
            b[1] = bin.get(pos + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            this.weapon_data_array[i].SetBulletSpeed(itemp);
            b[0] = bin.get(pos += 2);
            b[1] = bin.get(pos + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            this.weapon_data_array[i].SetNumberOfBullets(itemp);
            b[0] = bin.get(pos += 2);
            b[1] = bin.get(pos + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            this.weapon_data_array[i].SetReloadingTime(itemp);
            b[0] = bin.get(pos += 2);
            b[1] = bin.get(pos + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            this.weapon_data_array[i].SetRecoil(itemp);
            b[0] = bin.get(pos += 2);
            b[1] = bin.get(pos + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            this.weapon_data_array[i].SetErrorRangeMin(itemp);
            b[0] = bin.get(pos += 2);
            b[1] = bin.get(pos + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            this.weapon_data_array[i].SetErrorRangeMax(itemp);
            Vector vtemp = new Vector();
            b[0] = bin.get(pos += 2);
            b[1] = bin.get(pos + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            vtemp.SetX(itemp);
            b[0] = bin.get(pos += 2);
            b[1] = bin.get(pos + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            vtemp.SetY(itemp);
            b[0] = bin.get(pos += 2);
            b[1] = bin.get(pos + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            vtemp.SetZ(itemp);
            this.weapon_data_array[i].SetPosition(vtemp);
            vtemp = new Vector();
            b[0] = bin.get(pos += 2);
            b[1] = bin.get(pos + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            vtemp.SetX(itemp);
            b[0] = bin.get(pos += 2);
            b[1] = bin.get(pos + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            vtemp.SetY(itemp);
            b[0] = bin.get(pos += 2);
            b[1] = bin.get(pos + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            vtemp.SetZ(itemp);
            this.weapon_data_array[i].SetFlashPosition(vtemp);
            vtemp = new Vector();
            b[0] = bin.get(pos += 2);
            b[1] = bin.get(pos + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            vtemp.SetX(itemp);
            b[0] = bin.get(pos += 2);
            b[1] = bin.get(pos + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            vtemp.SetY(itemp);
            b[0] = bin.get(pos += 2);
            b[1] = bin.get(pos + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            vtemp.SetZ(itemp);
            this.weapon_data_array[i].SetCartridgePosition(vtemp);
            b[0] = bin.get(pos += 2);
            b[1] = bin.get(pos + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            WeaponShootingStance shooting_stance = WeaponBinSpecifierAndEnumConverter.GetWeaponShootingStanceFromBinSpecifier(itemp);
            this.weapon_data_array[i].SetShootingStance(shooting_stance);
            b[0] = bin.get(pos += 2);
            b[1] = bin.get(pos + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            if (itemp == 0) {
                this.weapon_data_array[i].SetRapidFireEnabledFlag(true);
            } else {
                this.weapon_data_array[i].SetRapidFireEnabledFlag(false);
            }
            b[0] = bin.get(pos += 2);
            b[1] = bin.get(pos + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            WeaponScopeMode scope_mode = WeaponBinSpecifierAndEnumConverter.GetWeaponScopeModeFromBinSpecifier(itemp);
            this.weapon_data_array[i].SetScopeMode(scope_mode);
            b[0] = bin.get(pos += 2);
            b[1] = bin.get(pos + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            WeaponTextureType texture_type = WeaponBinSpecifierAndEnumConverter.GetWeaponTextureTypeFromBinSpecifier(itemp);
            String texture_filename = WeaponTextureFilenamesStock.GetTextureFilename(texture_type);
            this.weapon_data_array[i].SetTextureFilename(texture_filename);
            b[0] = bin.get(pos += 2);
            b[1] = bin.get(pos + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            WeaponModelType model_type = WeaponBinSpecifierAndEnumConverter.GetWeaponModelTypeFromBinSpecifier(itemp);
            String model_filename = WeaponModelFilenamesStock.GetModelFilename(model_type);
            this.weapon_data_array[i].SetModelFilename(model_filename);
            b[0] = bin.get(pos += 2);
            b[1] = bin.get(pos + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            this.weapon_data_array[i].SetScale((float)itemp * 0.1f);
            vtemp = new Vector();
            b[0] = bin.get(pos += 2);
            b[1] = bin.get(pos + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            vtemp.SetX(itemp);
            b[0] = bin.get(pos += 2);
            b[1] = bin.get(pos + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            vtemp.SetY(itemp);
            vtemp.SetZ(0.0f);
            this.weapon_data_array[i].SetCartridgeVelocity(vtemp);
            b[0] = bin.get(pos += 2);
            b[1] = bin.get(pos + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            this.weapon_data_array[i].SetSoundID(itemp);
            b[0] = bin.get(pos += 2);
            b[1] = bin.get(pos + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            this.weapon_data_array[i].SetSoundVolume(itemp);
            b[0] = bin.get(pos += 2);
            b[1] = bin.get(pos + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            if (itemp == 0) {
                this.weapon_data_array[i].SetSuppressorEnabledFlag(false);
            } else {
                this.weapon_data_array[i].SetSuppressorEnabledFlag(true);
            }
            pos += 2;
            if (i == 4) {
                this.weapon_data_array[i].SetChangeableWeapon(16);
            } else if (i == 16) {
                this.weapon_data_array[i].SetChangeableWeapon(4);
            }
            if (i != 19) continue;
            this.weapon_data_array[i].SetNumberOfProjectiles(6);
        }
        pos = weapon_name_start_pos;
        for (int i = 0; i < 23; ++i) {
            byte[] name_buffer = new byte[16];
            for (int j = 0; j < 15; ++j) {
                name_buffer[j] = bin.get(pos + j);
            }
            name_buffer[15] = 0;
            pos += 16;
            String strtemp = new String(name_buffer);
            int first_null_pos = 15;
            for (int j = 0; j < 16; ++j) {
                if (strtemp.charAt(j) != '\u0000') continue;
                first_null_pos = j;
                break;
            }
            strtemp = strtemp.substring(0, first_null_pos);
            this.weapon_data_array[22 - i].SetName(strtemp);
        }
    }

    public WeaponData[] GetWeaponDataArray() {
        WeaponData[] ret = new WeaponData[this.weapon_data_array.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new WeaponData(this.weapon_data_array[i]);
        }
        return ret;
    }
}

