/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.openxops;

import com.daxie.basis.vector.Vector;
import com.daxie.log.LogFile;
import com.daxie.tool.StringFunctions;
import com.daxie.xops.openxops.WeaponSpecifierConverter;
import com.daxie.xops.weapon.WeaponData;
import java.util.List;

public class WeaponDataCodeOutputter {
    private List<WeaponData> weapon_data_list;

    public WeaponDataCodeOutputter(List<WeaponData> weapon_data_list) {
        this.weapon_data_list = weapon_data_list;
    }

    public String GetWeaponDataSourceCode() {
        String ret = "";
        if (this.weapon_data_list == null) {
            LogFile.WriteError("[OutputWeaponDataSourceCode-GetWeaponDataSourceCode] Data is null.");
            return ret;
        }
        String array_name = "Weapon";
        String separator = System.getProperty("line.separator");
        for (int i = 0; i < this.weapon_data_list.size(); ++i) {
            WeaponData weapon_data = this.weapon_data_list.get(i);
            ret = ret + StringFunctions.GetCPPArrayFormatString("Weapon", i, "name", weapon_data.GetName()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString("Weapon", i, "model", weapon_data.GetModelFilename()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString("Weapon", i, "texture", weapon_data.GetTextureFilename()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString("Weapon", i, "attacks", weapon_data.GetAttackPower()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString("Weapon", i, "penetration", weapon_data.GetPenetration()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString("Weapon", i, "blazings", weapon_data.GetFiringInterval()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString("Weapon", i, "speed", weapon_data.GetBulletSpeed()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString("Weapon", i, "nbsmax", weapon_data.GetNumberOfBullets()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString("Weapon", i, "reloads", weapon_data.GetReloadingTime()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString("Weapon", i, "reaction", weapon_data.GetRecoil()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString("Weapon", i, "ErrorRangeMIN", weapon_data.GetErrorRangeMin()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString("Weapon", i, "ErrorRangeMAX", weapon_data.GetErrorRangeMax()) + separator;
            Vector position = weapon_data.GetPosition();
            Vector flash_position = weapon_data.GetFlashPosition();
            Vector cartridge_position = weapon_data.GetCartridgePosition();
            Vector cartridge_velocity = weapon_data.GetCartridgeVelocity();
            ret = ret + StringFunctions.GetCPPArrayFormatString("Weapon", i, "mx", position.GetX()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString("Weapon", i, "my", position.GetY()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString("Weapon", i, "mz", position.GetZ()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString("Weapon", i, "flashx", flash_position.GetX()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString("Weapon", i, "flashy", flash_position.GetY()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString("Weapon", i, "flashz", flash_position.GetZ()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString("Weapon", i, "yakkyou_px", cartridge_position.GetX()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString("Weapon", i, "yakkyou_py", cartridge_position.GetY()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString("Weapon", i, "yakkyou_pz", cartridge_position.GetZ()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString("Weapon", i, "yakkyou_sx", cartridge_velocity.GetX()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString("Weapon", i, "yakkyou_sy", cartridge_velocity.GetY()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString("Weapon", i, "blazingmode", weapon_data.GetRapidFireEnabledFlag()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString("Weapon", i, "scopemode", weapon_data.GetScopeMode().ordinal()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString("Weapon", i, "size", weapon_data.GetScale()) + separator;
            int sound_id = weapon_data.GetSoundID();
            sound_id = WeaponSpecifierConverter.GetOpenXOPSSoundIDFromXOPSSoundID(sound_id);
            ret = ret + StringFunctions.GetCPPArrayFormatString("Weapon", i, "soundid", sound_id) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString("Weapon", i, "soundvolume", weapon_data.GetSoundVolume()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString("Weapon", i, "silencer", weapon_data.GetSuppressorEnabledFlag()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString("Weapon", i, "WeaponP", weapon_data.GetShootingStance().ordinal()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString("Weapon", i, "ChangeWeapon", weapon_data.GetChangeableWeapon()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString("Weapon", i, "burst", weapon_data.GetNumberOfProjectiles()) + separator;
        }
        return ret;
    }
}

