/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.exe;

import com.daxie.log.LogFile;
import com.daxie.tool.DateFunctions;
import com.daxie.tool.ExceptionFunctions;
import com.daxie.tool.FileFunctions;
import com.daxie.tool.FilenameFunctions;
import com.daxie.xops.character.CharacterData;
import com.daxie.xops.exe.XOPSExeCharacterDataParser;
import com.daxie.xops.exe.XOPSExeCharacterDataWriter;
import com.daxie.xops.exe.XOPSExeFunctions;
import com.daxie.xops.exe.XOPSExeWeaponDataParser;
import com.daxie.xops.exe.XOPSExeWeaponDataWriter;
import com.daxie.xops.exe.XOPSVersion;
import com.daxie.xops.weapon.WeaponData;
import java.io.FileNotFoundException;
import java.util.List;

public class XOPSExeManipulator {
    private WeaponData[] weapon_data_array = null;
    private CharacterData[] character_data_array = null;

    public XOPSExeManipulator(String xops_filename) throws FileNotFoundException {
        int character_data_start_pos;
        int weapon_name_start_pos;
        int weapon_data_start_pos;
        List<Byte> bin = FileFunctions.GetFileAllBin(xops_filename);
        XOPSVersion version = XOPSExeFunctions.GetXOPSVersion(bin);
        if (version == XOPSVersion.UNKNOWN_VERSION) {
            int i;
            LogFile.WriteError("[XOPSExeManipulator-<init>] Unknown version of X operations.");
            this.weapon_data_array = new WeaponData[23];
            for (i = 0; i < this.weapon_data_array.length; ++i) {
                this.weapon_data_array[i] = new WeaponData();
            }
            this.character_data_array = new CharacterData[43];
            for (i = 0; i < this.character_data_array.length; ++i) {
                this.character_data_array[i] = new CharacterData();
            }
            return;
        }
        switch (version) {
            case XOPS096: {
                weapon_data_start_pos = 381740;
                weapon_name_start_pos = 418276;
                character_data_start_pos = 383076;
                break;
            }
            case XOPS096T: {
                weapon_data_start_pos = 381740;
                weapon_name_start_pos = 418276;
                character_data_start_pos = 383076;
                break;
            }
            case XOPS097FT: {
                weapon_data_start_pos = 385836;
                weapon_name_start_pos = 422372;
                character_data_start_pos = 387172;
                break;
            }
            case XOPS0975T: {
                weapon_data_start_pos = 491440;
                weapon_name_start_pos = 495936;
                character_data_start_pos = 492776;
                break;
            }
            case XOPSOLT18F2: {
                weapon_data_start_pos = 418828;
                weapon_name_start_pos = 454532;
                character_data_start_pos = 420164;
                break;
            }
            case XOPSOLT19F2: {
                weapon_data_start_pos = 489448;
                weapon_name_start_pos = 488304;
                character_data_start_pos = 490784;
                break;
            }
            default: {
                weapon_data_start_pos = 0;
                weapon_name_start_pos = 0;
                character_data_start_pos = 0;
            }
        }
        XOPSExeWeaponDataParser weapon_data_parser = new XOPSExeWeaponDataParser(bin, weapon_data_start_pos, weapon_name_start_pos);
        XOPSExeCharacterDataParser character_data_parser = new XOPSExeCharacterDataParser(bin, character_data_start_pos);
        this.weapon_data_array = weapon_data_parser.GetWeaponDataArray();
        this.character_data_array = character_data_parser.GetCharacterDataArray();
    }

    public XOPSExeManipulator(String xops_filename, int weapon_data_start_pos, int weapon_name_start_pos, int character_data_start_pos) throws FileNotFoundException {
        List<Byte> bin = FileFunctions.GetFileAllBin(xops_filename);
        XOPSExeWeaponDataParser weapon_data_parser = null;
        XOPSExeCharacterDataParser character_data_parser = null;
        try {
            weapon_data_parser = new XOPSExeWeaponDataParser(bin, weapon_data_start_pos, weapon_name_start_pos);
            character_data_parser = new XOPSExeCharacterDataParser(bin, character_data_start_pos);
        }
        catch (IndexOutOfBoundsException e) {
            String str = ExceptionFunctions.GetPrintStackTraceString(e);
            LogFile.WriteFatal("[XOPSExeManipulator-<init>] Index out of bounds. Below is the stack trace.");
            LogFile.WriteLine(str);
            LogFile.CloseLogFile();
            System.exit(1);
        }
        this.weapon_data_array = weapon_data_parser.GetWeaponDataArray();
        this.character_data_array = character_data_parser.GetCharacterDataArray();
    }

    public XOPSExeManipulator() {
    }

    public WeaponData[] GetWeaponDataArray() {
        if (this.weapon_data_array == null) {
            return null;
        }
        WeaponData[] ret = new WeaponData[this.weapon_data_array.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new WeaponData(this.weapon_data_array[i]);
        }
        return ret;
    }

    public CharacterData[] GetCharacterDataArray() {
        if (this.character_data_array == null) {
            return null;
        }
        CharacterData[] ret = new CharacterData[this.character_data_array.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new CharacterData(this.character_data_array[i]);
        }
        return ret;
    }

    public void SetWeaponDataArray(WeaponData[] weapon_data_array) {
        if (weapon_data_array == null) {
            LogFile.WriteError("[XOPSExeManipulator-SetWeaponDataArray] Null argument where non-null required.");
            return;
        }
        this.weapon_data_array = weapon_data_array;
    }

    public void SetCharacterDataArray(CharacterData[] character_data_array) {
        if (character_data_array == null) {
            LogFile.WriteError("[XOPSExeManipulator-SetCharacterDataArray] Null argument where non-null required.");
            return;
        }
        this.character_data_array = character_data_array;
    }

    public void Write(String xops_filename, boolean create_backup_flag) throws FileNotFoundException {
        int character_data_start_pos;
        int weapon_name_start_pos;
        int weapon_data_start_pos;
        List<Byte> bin = FileFunctions.GetFileAllBin(xops_filename);
        if (create_backup_flag) {
            String date = DateFunctions.GetDateStringWithoutDelimiters();
            String filename_without_extension = FilenameFunctions.GetFilenameWithoutExtension(xops_filename);
            String backup_filename = filename_without_extension + "_" + date + ".exe";
            FileFunctions.CreateBinFile(backup_filename, bin);
        }
        XOPSExeWeaponDataWriter weapon_data_writer = new XOPSExeWeaponDataWriter(this.weapon_data_array);
        XOPSExeCharacterDataWriter character_data_writer = new XOPSExeCharacterDataWriter(this.character_data_array);
        XOPSVersion version = XOPSExeFunctions.GetXOPSVersion(bin);
        switch (version) {
            case XOPS096: {
                weapon_data_start_pos = 381740;
                weapon_name_start_pos = 418276;
                character_data_start_pos = 383076;
                break;
            }
            case XOPS096T: {
                weapon_data_start_pos = 381740;
                weapon_name_start_pos = 418276;
                character_data_start_pos = 383076;
                break;
            }
            case XOPS097FT: {
                weapon_data_start_pos = 385836;
                weapon_name_start_pos = 422372;
                character_data_start_pos = 387172;
                break;
            }
            case XOPS0975T: {
                weapon_data_start_pos = 491440;
                weapon_name_start_pos = 495936;
                character_data_start_pos = 492776;
                break;
            }
            case XOPSOLT18F2: {
                weapon_data_start_pos = 418828;
                weapon_name_start_pos = 454532;
                character_data_start_pos = 420164;
                break;
            }
            case XOPSOLT19F2: {
                weapon_data_start_pos = 489448;
                weapon_name_start_pos = 488304;
                character_data_start_pos = 490784;
                break;
            }
            default: {
                weapon_data_start_pos = 0;
                weapon_name_start_pos = 0;
                character_data_start_pos = 0;
            }
        }
        weapon_data_writer.Write(bin, weapon_data_start_pos, weapon_name_start_pos);
        character_data_writer.Write(bin, character_data_start_pos);
        FileFunctions.CreateBinFile(xops_filename, bin);
    }

    public void Write(String xops_filename, int weapon_data_start_pos, int weapon_name_start_pos, int character_data_start_pos, boolean create_backup_flag) throws FileNotFoundException {
        List<Byte> bin = FileFunctions.GetFileAllBin(xops_filename);
        if (create_backup_flag) {
            String date = DateFunctions.GetDateStringWithoutDelimiters();
            String filename_without_extension = FilenameFunctions.GetFilenameWithoutExtension(xops_filename);
            String backup_filename = filename_without_extension + "_" + date + ".exe";
            FileFunctions.CreateBinFile(backup_filename, bin);
        }
        XOPSExeWeaponDataWriter weapon_data_writer = new XOPSExeWeaponDataWriter(this.weapon_data_array);
        XOPSExeCharacterDataWriter character_data_writer = new XOPSExeCharacterDataWriter(this.character_data_array);
        try {
            weapon_data_writer.Write(bin, weapon_data_start_pos, weapon_name_start_pos);
            character_data_writer.Write(bin, character_data_start_pos);
        }
        catch (IndexOutOfBoundsException e) {
            String str = ExceptionFunctions.GetPrintStackTraceString(e);
            LogFile.WriteFatal("[XOPSExeManipulator-<init>] Index out of bounds. Below is the stack trace.");
            LogFile.WriteLine(str);
            LogFile.CloseLogFile();
            System.exit(1);
        }
        FileFunctions.CreateBinFile(xops_filename, bin);
    }
}

