/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.bd1;

import com.daxie.basis.matrix.Matrix;
import com.daxie.basis.matrix.MatrixFunctions;
import com.daxie.basis.vector.Vector;
import com.daxie.basis.vector.VectorFunctions;
import com.daxie.log.LogFile;
import com.daxie.tool.ExceptionFunctions;
import com.daxie.xops.bd1.BD1Block;
import com.daxie.xops.bd1.BD1Functions;
import com.daxie.xops.bd1.BD1OBJWriter;
import com.daxie.xops.bd1.BD1Parser;
import com.daxie.xops.bd1.BD1Writer;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BD1Manipulator {
    private List<BD1Block> blocks;
    private Map<Integer, String> texture_filenames_map;

    public BD1Manipulator(String bd1_filename) throws FileNotFoundException {
        BD1Parser bd1_parser = new BD1Parser(bd1_filename);
        this.blocks = bd1_parser.GetBlocks();
        this.texture_filenames_map = bd1_parser.GetTextureFilenamesMap();
    }

    public BD1Manipulator() {
        this.blocks = new ArrayList<BD1Block>();
        this.texture_filenames_map = new HashMap<Integer, String>();
    }

    public List<BD1Block> GetBlocks() {
        return new ArrayList<BD1Block>(this.blocks);
    }

    public void SetBlocks(List<BD1Block> blocks) {
        if (blocks == null) {
            LogFile.WriteError("[BD1Manipulator-SetBlocks] Null argument where non-null required.");
            return;
        }
        this.blocks = blocks;
    }

    public int GetBlockNum() {
        return this.blocks.size();
    }

    public String GetTextureFilename(int texture_id) {
        if (!this.texture_filenames_map.containsKey(texture_id)) {
            return "";
        }
        String texture_filename = this.texture_filenames_map.get(texture_id);
        return texture_filename;
    }

    public void SetTextureFilename(int texture_id, String texture_filename) {
        if (0 > texture_id || texture_id >= 10) {
            return;
        }
        this.texture_filenames_map.put(texture_id, texture_filename);
    }

    public void Translate(Vector translate) {
        for (BD1Block block : this.blocks) {
            int i;
            Vector[] vertex_positions = block.GetVertexPositions();
            for (i = 0; i < vertex_positions.length; ++i) {
                vertex_positions[i] = VectorFunctions.VAdd(vertex_positions[i], translate);
            }
            for (i = 0; i < vertex_positions.length; ++i) {
                block.SetVertexPosition(i, vertex_positions[i]);
            }
        }
    }

    public void Rotate(Vector rotate) {
        Matrix rot_x = MatrixFunctions.MGetRotX(rotate.GetX());
        Matrix rot_y = MatrixFunctions.MGetRotY(rotate.GetY());
        Matrix rot_z = MatrixFunctions.MGetRotZ(rotate.GetZ());
        for (BD1Block block : this.blocks) {
            int i;
            Vector[] vertex_positions = block.GetVertexPositions();
            for (i = 0; i < vertex_positions.length; ++i) {
                vertex_positions[i] = VectorFunctions.VTransform(vertex_positions[i], rot_x);
                vertex_positions[i] = VectorFunctions.VTransform(vertex_positions[i], rot_y);
                vertex_positions[i] = VectorFunctions.VTransform(vertex_positions[i], rot_z);
            }
            for (i = 0; i < vertex_positions.length; ++i) {
                block.SetVertexPosition(i, vertex_positions[i]);
            }
        }
    }

    public void Rescale(Vector scale) {
        for (BD1Block block : this.blocks) {
            int i;
            Vector[] vertex_positions = block.GetVertexPositions();
            for (i = 0; i < vertex_positions.length; ++i) {
                float x = vertex_positions[i].GetX();
                float y = vertex_positions[i].GetY();
                float z = vertex_positions[i].GetZ();
                vertex_positions[i].SetX(x * scale.GetX());
                vertex_positions[i].SetY(y * scale.GetY());
                vertex_positions[i].SetZ(z * scale.GetZ());
            }
            for (i = 0; i < vertex_positions.length; ++i) {
                block.SetVertexPosition(i, vertex_positions[i]);
            }
        }
    }

    public void SetMatrix(Matrix m) {
        for (BD1Block block : this.blocks) {
            int i;
            Vector[] vertex_positions = block.GetVertexPositions();
            for (i = 0; i < vertex_positions.length; ++i) {
                vertex_positions[i] = VectorFunctions.VTransform(vertex_positions[i], m);
            }
            for (i = 0; i < vertex_positions.length; ++i) {
                block.SetVertexPosition(i, vertex_positions[i]);
            }
        }
    }

    public void InvertZ() {
        Vector[] vertex_positions;
        for (BD1Block block : this.blocks) {
            int i;
            vertex_positions = block.GetVertexPositions();
            for (i = 0; i < 8; ++i) {
                vertex_positions[i].SetZ(vertex_positions[i].GetZ() * -1.0f);
            }
            for (i = 0; i < 8; ++i) {
                block.SetVertexPosition(i, vertex_positions[i]);
            }
        }
        for (BD1Block block : this.blocks) {
            int i;
            int i2;
            vertex_positions = block.GetVertexPositions();
            float[] us = block.GetUs();
            float[] vs = block.GetVs();
            int[] texture_ids = block.GetTextureIDs();
            for (i2 = 0; i2 < 4; ++i2) {
                block.SetVertexPosition(i2, vertex_positions[3 - i2]);
            }
            for (i2 = 0; i2 < 4; ++i2) {
                block.SetVertexPosition(i2 + 4, vertex_positions[7 - i2]);
            }
            float[] us_orig = (float[])us.clone();
            float[] vs_orig = (float[])vs.clone();
            for (i = 0; i < 6; ++i) {
                int[] uv_indices = i == 2 ? BD1Functions.GetFaceCorrespondingUVIndices(4) : (i == 4 ? BD1Functions.GetFaceCorrespondingUVIndices(2) : BD1Functions.GetFaceCorrespondingUVIndices(i));
                for (int j = 0; j < 4; ++j) {
                    int index = i * 4 + j;
                    us[index] = us_orig[uv_indices[j]];
                    vs[index] = vs_orig[uv_indices[j]];
                }
            }
            for (i = 0; i < 24; ++i) {
                block.SetUVs(i, us[i], vs[i]);
            }
            block.SetTextureID(2, texture_ids[4]);
            block.SetTextureID(4, texture_ids[2]);
        }
    }

    public int WriteAsBD1(String bd1_filename) {
        BD1Writer bd1_writer = new BD1Writer(this.blocks, this.texture_filenames_map);
        try {
            bd1_writer.Write(bd1_filename);
        }
        catch (FileNotFoundException e) {
            String str = ExceptionFunctions.GetPrintStackTraceString(e);
            LogFile.WriteError("[BD1Manipulator-Write] Failed to write data.");
            LogFile.WriteLine("Below is the stack trace.");
            LogFile.WriteLine(str);
            return -1;
        }
        return 0;
    }

    public int WriteAsOBJ(String obj_filename) {
        BD1OBJWriter obj_writer = new BD1OBJWriter(this.texture_filenames_map, this.blocks);
        int ret = obj_writer.Write(obj_filename);
        if (ret < 0) {
            LogFile.WriteError("[BD1Manipulator-WriteAsOBJ] Failed to write blocks in an OBJ file.");
            return -1;
        }
        return 0;
    }
}

