/*
 * Decompiled with CFR 0.152.
 */
package com.github.dabasan.xops.properties.xms.xcs;

import com.github.dabasan.tool.ByteFunctions;
import com.github.dabasan.tool.FileFunctions;
import com.github.dabasan.xops.properties.entity.character.CharacterAILevel;
import com.github.dabasan.xops.properties.entity.character.CharacterBinSpecifierAndEnumConverter;
import com.github.dabasan.xops.properties.entity.character.CharacterData;
import com.github.dabasan.xops.properties.entity.character.CharacterModelType;
import com.github.dabasan.xops.properties.entity.character.CharacterTextureType;
import com.github.dabasan.xops.properties.entity.character.CharacterType;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class XCSReader {
    private final Logger logger = LoggerFactory.getLogger(XCSReader.class);
    private CharacterData[] character_data_array = new CharacterData[43];

    public XCSReader(String xcs_filename) throws IOException {
        for (int i = 0; i < 43; ++i) {
            this.character_data_array[i] = new CharacterData();
        }
        List bin = FileFunctions.GetFileAllBin((String)xcs_filename);
        if (bin.size() != 614) {
            this.logger.warn("Invalid file size. xcs_filename={}", (Object)xcs_filename);
            return;
        }
        int pos = 12;
        for (int i = 0; i < 43; ++i) {
            int itemp = ByteFunctions.GetShortValueFromBin_LE((List)bin, (int)pos);
            CharacterTextureType texture_type = CharacterBinSpecifierAndEnumConverter.GetCharacterTextureTypeFromBinSpecifier(itemp);
            this.character_data_array[i].SetTextureType(texture_type);
            itemp = ByteFunctions.GetShortValueFromBin_LE((List)bin, (int)(pos += 2));
            CharacterModelType model_type = CharacterBinSpecifierAndEnumConverter.GetCharacterModelTypeFromBinSpecifier(itemp);
            this.character_data_array[i].SetModelType(model_type);
            itemp = ByteFunctions.GetUShortValueFromBin_LE((List)bin, (int)(pos += 2));
            this.character_data_array[i].SetHP(itemp);
            itemp = ByteFunctions.GetShortValueFromBin_LE((List)bin, (int)(pos += 2));
            CharacterAILevel ai_level = CharacterBinSpecifierAndEnumConverter.GetCharacterAILevelFromBinSpecifier(itemp);
            this.character_data_array[i].SetAILevel(ai_level);
            itemp = ByteFunctions.GetShortValueFromBin_LE((List)bin, (int)(pos += 2));
            this.character_data_array[i].SetWeaponID(0, itemp);
            itemp = ByteFunctions.GetShortValueFromBin_LE((List)bin, (int)(pos += 2));
            this.character_data_array[i].SetWeaponID(1, itemp);
            itemp = ByteFunctions.GetShortValueFromBin_LE((List)bin, (int)(pos += 2));
            pos += 2;
            CharacterType type = CharacterBinSpecifierAndEnumConverter.GetCharacterTypeFromBinSpecifier(itemp);
            this.character_data_array[i].SetType(type);
        }
    }

    public CharacterData[] GetCharacterData() {
        return this.character_data_array;
    }
}

