/*
 * Decompiled with CFR 0.152.
 */
package com.github.dabasan.xops.properties.xms.ids;

import com.github.dabasan.xops.properties.entity.weapon.WeaponData;
import com.github.dabasan.xops.properties.xms.ids.IDSReader;
import com.github.dabasan.xops.properties.xms.ids.IDSWriter;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IDSManipulator {
    private final Logger logger = LoggerFactory.getLogger(IDSManipulator.class);
    private WeaponData weapon_data;

    public IDSManipulator(String ids_filename) throws IOException {
        IDSReader ids_parser = new IDSReader(ids_filename);
        this.weapon_data = ids_parser.GetWeaponData();
    }

    public IDSManipulator() {
    }

    public WeaponData GetWeaponData() {
        if (this.weapon_data == null) {
            return null;
        }
        return new WeaponData(this.weapon_data);
    }

    public void SetWeaponData(WeaponData weapon_data) {
        if (weapon_data == null) {
            this.logger.warn("Null argument where non-null required.");
            return;
        }
        this.weapon_data = weapon_data;
    }

    public int Write(String ids_filename) {
        IDSWriter ids_writer = new IDSWriter(this.weapon_data);
        int ret = ids_writer.Write(ids_filename);
        if (ret == -1) {
            this.logger.error("Failed to write data in an IDS file. ids_filename={}", (Object)ids_filename);
            return -1;
        }
        return 0;
    }
}

