/*
 * Decompiled with CFR 0.152.
 */
package com.github.dabasan.xops.properties.exe;

import com.github.dabasan.basis.vector.Vector;
import com.github.dabasan.tool.ByteFunctions;
import com.github.dabasan.xops.properties.entity.weapon.WeaponBinSpecifierAndEnumConverter;
import com.github.dabasan.xops.properties.entity.weapon.WeaponData;
import com.github.dabasan.xops.properties.entity.weapon.WeaponModelFilenamesStock;
import com.github.dabasan.xops.properties.entity.weapon.WeaponModelType;
import com.github.dabasan.xops.properties.entity.weapon.WeaponScopeMode;
import com.github.dabasan.xops.properties.entity.weapon.WeaponShootingStance;
import com.github.dabasan.xops.properties.entity.weapon.WeaponTextureFilenamesStock;
import com.github.dabasan.xops.properties.entity.weapon.WeaponTextureType;
import java.util.List;

class XOPSExeWeaponDataReader {
    private final WeaponData[] weapon_data_array = new WeaponData[23];

    public XOPSExeWeaponDataReader(List<Byte> bin, int weapon_data_start_pos, int weapon_name_start_pos) {
        for (int i = 0; i < 23; ++i) {
            this.weapon_data_array[i] = new WeaponData();
        }
        int pos = weapon_data_start_pos;
        for (int i = 0; i < 23; ++i) {
            short itemp = ByteFunctions.GetShortValueFromBin_LE(bin, (int)pos);
            this.weapon_data_array[i].SetAttackPower(itemp);
            itemp = ByteFunctions.GetShortValueFromBin_LE(bin, (int)(pos += 2));
            this.weapon_data_array[i].SetPenetration(itemp);
            itemp = ByteFunctions.GetShortValueFromBin_LE(bin, (int)(pos += 2));
            this.weapon_data_array[i].SetFiringInterval(itemp);
            itemp = ByteFunctions.GetShortValueFromBin_LE(bin, (int)(pos += 2));
            this.weapon_data_array[i].SetBulletSpeed(itemp);
            itemp = ByteFunctions.GetShortValueFromBin_LE(bin, (int)(pos += 2));
            this.weapon_data_array[i].SetNumberOfBullets(itemp);
            itemp = ByteFunctions.GetShortValueFromBin_LE(bin, (int)(pos += 2));
            this.weapon_data_array[i].SetReloadingTime(itemp);
            itemp = ByteFunctions.GetShortValueFromBin_LE(bin, (int)(pos += 2));
            this.weapon_data_array[i].SetRecoil(itemp);
            itemp = ByteFunctions.GetShortValueFromBin_LE(bin, (int)(pos += 2));
            this.weapon_data_array[i].SetErrorRangeMin(itemp);
            itemp = ByteFunctions.GetShortValueFromBin_LE(bin, (int)(pos += 2));
            this.weapon_data_array[i].SetErrorRangeMax(itemp);
            Vector vtemp = new Vector();
            itemp = ByteFunctions.GetShortValueFromBin_LE(bin, (int)(pos += 2));
            vtemp.SetX((float)itemp);
            itemp = ByteFunctions.GetShortValueFromBin_LE(bin, (int)(pos += 2));
            vtemp.SetY((float)itemp);
            itemp = ByteFunctions.GetShortValueFromBin_LE(bin, (int)(pos += 2));
            vtemp.SetZ((float)itemp);
            this.weapon_data_array[i].SetPosition(vtemp);
            vtemp = new Vector();
            itemp = ByteFunctions.GetShortValueFromBin_LE(bin, (int)(pos += 2));
            vtemp.SetX((float)itemp);
            itemp = ByteFunctions.GetShortValueFromBin_LE(bin, (int)(pos += 2));
            vtemp.SetY((float)itemp);
            itemp = ByteFunctions.GetShortValueFromBin_LE(bin, (int)(pos += 2));
            vtemp.SetZ((float)itemp);
            this.weapon_data_array[i].SetFlashPosition(vtemp);
            vtemp = new Vector();
            itemp = ByteFunctions.GetShortValueFromBin_LE(bin, (int)(pos += 2));
            vtemp.SetX((float)itemp);
            itemp = ByteFunctions.GetShortValueFromBin_LE(bin, (int)(pos += 2));
            vtemp.SetY((float)itemp);
            itemp = ByteFunctions.GetShortValueFromBin_LE(bin, (int)(pos += 2));
            vtemp.SetZ((float)itemp);
            this.weapon_data_array[i].SetCartridgePosition(vtemp);
            itemp = ByteFunctions.GetShortValueFromBin_LE(bin, (int)(pos += 2));
            WeaponShootingStance shooting_stance = WeaponBinSpecifierAndEnumConverter.GetWeaponShootingStanceFromBinSpecifier(itemp);
            this.weapon_data_array[i].SetShootingStance(shooting_stance);
            itemp = ByteFunctions.GetShortValueFromBin_LE(bin, (int)(pos += 2));
            if (itemp == 0) {
                this.weapon_data_array[i].SetRapidFireEnabledFlag(true);
            } else {
                this.weapon_data_array[i].SetRapidFireEnabledFlag(false);
            }
            itemp = ByteFunctions.GetShortValueFromBin_LE(bin, (int)(pos += 2));
            WeaponScopeMode scope_mode = WeaponBinSpecifierAndEnumConverter.GetWeaponScopeModeFromBinSpecifier(itemp);
            this.weapon_data_array[i].SetScopeMode(scope_mode);
            itemp = ByteFunctions.GetShortValueFromBin_LE(bin, (int)(pos += 2));
            WeaponTextureType texture_type = WeaponBinSpecifierAndEnumConverter.GetWeaponTextureTypeFromBinSpecifier(itemp);
            String texture_filename = WeaponTextureFilenamesStock.GetTextureFilename(texture_type);
            this.weapon_data_array[i].SetTextureFilename(texture_filename);
            itemp = ByteFunctions.GetShortValueFromBin_LE(bin, (int)(pos += 2));
            WeaponModelType model_type = WeaponBinSpecifierAndEnumConverter.GetWeaponModelTypeFromBinSpecifier(itemp);
            String model_filename = WeaponModelFilenamesStock.GetModelFilename(model_type);
            this.weapon_data_array[i].SetModelFilename(model_filename);
            itemp = ByteFunctions.GetShortValueFromBin_LE(bin, (int)(pos += 2));
            this.weapon_data_array[i].SetScale((float)itemp * 0.1f);
            vtemp = new Vector();
            itemp = ByteFunctions.GetShortValueFromBin_LE(bin, (int)(pos += 2));
            vtemp.SetX((float)itemp);
            itemp = ByteFunctions.GetShortValueFromBin_LE(bin, (int)(pos += 2));
            vtemp.SetY((float)itemp);
            vtemp.SetZ(0.0f);
            this.weapon_data_array[i].SetCartridgeVelocity(vtemp);
            itemp = ByteFunctions.GetShortValueFromBin_LE(bin, (int)(pos += 2));
            this.weapon_data_array[i].SetSoundID(itemp);
            itemp = ByteFunctions.GetShortValueFromBin_LE(bin, (int)(pos += 2));
            this.weapon_data_array[i].SetSoundVolume(itemp);
            itemp = ByteFunctions.GetShortValueFromBin_LE(bin, (int)(pos += 2));
            if (itemp == 0) {
                this.weapon_data_array[i].SetSuppressorEnabledFlag(false);
            } else {
                this.weapon_data_array[i].SetSuppressorEnabledFlag(true);
            }
            pos += 2;
            if (i == 4) {
                this.weapon_data_array[i].SetChangeableWeapon(16);
            } else if (i == 16) {
                this.weapon_data_array[i].SetChangeableWeapon(4);
            }
            if (i != 19) continue;
            this.weapon_data_array[i].SetNumberOfProjectiles(6);
        }
        pos = weapon_name_start_pos;
        for (int i = 0; i < 23; ++i) {
            byte[] name_buffer = new byte[16];
            for (int j = 0; j < 15; ++j) {
                name_buffer[j] = bin.get(pos + j);
            }
            name_buffer[15] = 0;
            pos += 16;
            String strtemp = new String(name_buffer);
            int first_null_pos = 15;
            for (int j = 0; j < 16; ++j) {
                if (strtemp.charAt(j) != '\u0000') continue;
                first_null_pos = j;
                break;
            }
            strtemp = strtemp.substring(0, first_null_pos);
            this.weapon_data_array[22 - i].SetName(strtemp);
        }
    }

    public WeaponData[] GetWeaponData() {
        return this.weapon_data_array;
    }
}

