/*
 * Decompiled with CFR 0.152.
 */
package com.github.dabasan.xops.properties.openxops;

import com.github.dabasan.tool.StringFunctions;
import com.github.dabasan.xops.properties.entity.character.CharacterAILevel;
import com.github.dabasan.xops.properties.entity.character.CharacterData;
import com.github.dabasan.xops.properties.entity.character.CharacterTextureType;
import com.github.dabasan.xops.properties.openxops.CharacterSpecifierConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharacterDataCodeOutputter {
    private final Logger logger = LoggerFactory.getLogger(CharacterDataCodeOutputter.class);
    private List<CharacterData> character_data_list;

    public CharacterDataCodeOutputter(List<CharacterData> character_data_list) {
        this.character_data_list = character_data_list;
    }

    public CharacterDataCodeOutputter(CharacterData[] character_data) {
        if (character_data == null) {
            this.logger.warn("Null argument where non-null required.");
            return;
        }
        this.character_data_list = new ArrayList<CharacterData>();
        for (int i = 0; i < character_data.length; ++i) {
            this.character_data_list.add(character_data[i]);
        }
    }

    public String GetConcatCode() {
        String ret = "";
        if (this.character_data_list == null) {
            this.logger.warn("Data not prepared.");
            return ret;
        }
        String array_name = "Human";
        String separator = System.getProperty("line.separator");
        for (int i = 0; i < this.character_data_list.size(); ++i) {
            CharacterData character_data = this.character_data_list.get(i);
            CharacterTextureType xops_texture_type = character_data.GetTextureType();
            CharacterAILevel xops_ai_level = character_data.GetAILevel();
            int openxops_texture_id = CharacterSpecifierConverter.GetOpenXOPSTextureIDFromXOPSTextureType(xops_texture_type);
            int openxops_ai_level = CharacterSpecifierConverter.GetOpenXOPSAILevelFromXOPSAILevel(xops_ai_level);
            ret = ret + StringFunctions.GetCPPArrayFormatString((String)"Human", (int)i, (String)"texture", (int)openxops_texture_id) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString((String)"Human", (int)i, (String)"model", (int)character_data.GetModelType().ordinal()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString((String)"Human", (int)i, (String)"hp", (int)character_data.GetHP()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString((String)"Human", (int)i, (String)"AIlevel", (int)openxops_ai_level) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString((String)"Human", (int)i, (String)"Weapon[0]", (int)character_data.GetWeaponID(0)) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString((String)"Human", (int)i, (String)"Weapon[1]", (int)character_data.GetWeaponID(1)) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString((String)"Human", (int)i, (String)"type", (int)character_data.GetType().ordinal()) + separator;
        }
        return ret;
    }

    public List<String> GetCode() {
        String separator = System.getProperty("line.separator");
        String code = this.GetConcatCode();
        String[] split = code.split(separator);
        List<String> ret = Arrays.asList(split);
        return ret;
    }
}

