/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.properties.xms.xgs;

import com.daxie.basis.vector.Vector;
import com.daxie.tool.ByteFunctions;
import com.daxie.tool.FileFunctions;
import com.daxie.xops.properties.entity.weapon.WeaponBinSpecifierAndEnumConverter;
import com.daxie.xops.properties.entity.weapon.WeaponData;
import com.daxie.xops.properties.entity.weapon.WeaponModelFilenamesStock;
import com.daxie.xops.properties.entity.weapon.WeaponModelType;
import com.daxie.xops.properties.entity.weapon.WeaponScopeMode;
import com.daxie.xops.properties.entity.weapon.WeaponShootingStance;
import com.daxie.xops.properties.entity.weapon.WeaponTextureFilenamesStock;
import com.daxie.xops.properties.entity.weapon.WeaponTextureType;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class XGSWriter {
    private Logger logger = LoggerFactory.getLogger(XGSWriter.class);
    private WeaponData[] weapon_data_array = null;

    public XGSWriter(WeaponData[] weapon_data_array) {
        this.weapon_data_array = weapon_data_array;
    }

    public int Write(String xgs_filename) {
        int i;
        if (this.weapon_data_array == null) {
            this.logger.warn("Data not prepared.");
            return -1;
        }
        if (this.weapon_data_array.length != 23) {
            this.logger.warn("Invalid number of data. data_num={}", (Object)this.weapon_data_array.length);
            return -1;
        }
        ArrayList<Byte> bin = new ArrayList<Byte>();
        bin.add((byte)88);
        bin.add((byte)71);
        bin.add((byte)83);
        bin.add((byte)0);
        bin.add((byte)1);
        bin.add((byte)0);
        bin.add((byte)14);
        bin.add((byte)0);
        bin.add((byte)23);
        bin.add((byte)0);
        bin.add((byte)29);
        bin.add((byte)0);
        bin.add((byte)8);
        bin.add((byte)0);
        for (i = 0; i < 23; ++i) {
            int itemp = this.weapon_data_array[i].GetAttackPower();
            ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
            itemp = this.weapon_data_array[i].GetPenetration();
            ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
            itemp = this.weapon_data_array[i].GetFiringInterval();
            ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
            itemp = this.weapon_data_array[i].GetBulletSpeed();
            ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
            itemp = this.weapon_data_array[i].GetNumberOfBullets();
            ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
            itemp = this.weapon_data_array[i].GetReloadingTime();
            ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
            itemp = this.weapon_data_array[i].GetRecoil();
            ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
            itemp = this.weapon_data_array[i].GetErrorRangeMin();
            ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
            itemp = this.weapon_data_array[i].GetErrorRangeMax();
            ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
            Vector vtemp = this.weapon_data_array[i].GetPosition();
            itemp = Math.round(vtemp.GetX());
            ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
            itemp = Math.round(vtemp.GetY());
            ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
            itemp = Math.round(vtemp.GetZ());
            ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
            vtemp = this.weapon_data_array[i].GetFlashPosition();
            itemp = Math.round(vtemp.GetX());
            ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
            itemp = Math.round(vtemp.GetY());
            ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
            itemp = Math.round(vtemp.GetZ());
            ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
            vtemp = this.weapon_data_array[i].GetCartridgePosition();
            itemp = Math.round(vtemp.GetX());
            ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
            itemp = Math.round(vtemp.GetY());
            ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
            itemp = Math.round(vtemp.GetZ());
            ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
            WeaponShootingStance shooting_stance = this.weapon_data_array[i].GetShootingStance();
            itemp = WeaponBinSpecifierAndEnumConverter.GetBinSpecifierFromWeaponShootingStance(shooting_stance);
            ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
            itemp = !this.weapon_data_array[i].GetRapidFireEnabledFlag() ? 1 : 0;
            ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
            WeaponScopeMode scope_mode = this.weapon_data_array[i].GetScopeMode();
            itemp = WeaponBinSpecifierAndEnumConverter.GetBinSpecifierFromWeaponScopeMode(scope_mode);
            ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
            String texture_filename = this.weapon_data_array[i].GetTextureFilename();
            WeaponTextureType texture_type = WeaponTextureFilenamesStock.GetWeaponTextureTypeFromFilename(texture_filename);
            itemp = WeaponBinSpecifierAndEnumConverter.GetBinSpecifierFromWeaponTextureType(texture_type);
            ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
            String model_filename = this.weapon_data_array[i].GetModelFilename();
            WeaponModelType model_type = WeaponModelFilenamesStock.GetWeaponModelTypeFromFilename(model_filename);
            itemp = WeaponBinSpecifierAndEnumConverter.GetBinSpecifierFromWeaponModelType(model_type);
            ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
            itemp = Math.round(this.weapon_data_array[i].GetScale() * 10.0f);
            ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
            vtemp = this.weapon_data_array[i].GetCartridgeVelocity();
            itemp = Math.round(vtemp.GetX());
            ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
            itemp = Math.round(vtemp.GetY());
            ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
            itemp = this.weapon_data_array[i].GetSoundID();
            ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
            itemp = this.weapon_data_array[i].GetSoundVolume();
            ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
            itemp = !this.weapon_data_array[i].GetSuppressorEnabledFlag() ? 0 : 1;
            ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
        }
        for (i = 0; i < 23; ++i) {
            int j;
            String name = this.weapon_data_array[22 - i].GetName();
            byte[] name_buffer = new byte[16];
            for (j = 0; j < 16; ++j) {
                name_buffer[j] = 0;
            }
            for (j = 0; j < name.length() && j < 15; ++j) {
                name_buffer[j] = (byte)name.charAt(j);
            }
            for (j = 0; j < 16; ++j) {
                bin.add(name_buffer[j]);
            }
        }
        for (i = 0; i < 16; ++i) {
            bin.add((byte)0);
        }
        try {
            FileFunctions.CreateBinFile((String)xgs_filename, bin);
        }
        catch (IOException e) {
            this.logger.error("Error while writing.", (Throwable)e);
            return -1;
        }
        return 0;
    }
}

