/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.properties.xms.xcs;

import com.daxie.tool.ByteFunctions;
import com.daxie.tool.FileFunctions;
import com.daxie.xops.properties.entity.character.CharacterAILevel;
import com.daxie.xops.properties.entity.character.CharacterBinSpecifierAndEnumConverter;
import com.daxie.xops.properties.entity.character.CharacterData;
import com.daxie.xops.properties.entity.character.CharacterModelType;
import com.daxie.xops.properties.entity.character.CharacterTextureType;
import com.daxie.xops.properties.entity.character.CharacterType;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class XCSWriter {
    private Logger logger = LoggerFactory.getLogger(XCSWriter.class);
    private CharacterData[] character_data_array = null;

    public XCSWriter(CharacterData[] character_data_array) {
        this.character_data_array = character_data_array;
    }

    public int Write(String xcs_filename) {
        if (this.character_data_array == null) {
            this.logger.warn("Data not prepared.");
            return -1;
        }
        if (this.character_data_array.length != 43) {
            this.logger.warn("Invalid number of data. data_num={}", (Object)this.character_data_array.length);
            return -1;
        }
        ArrayList<Byte> bin = new ArrayList<Byte>();
        bin.add((byte)88);
        bin.add((byte)67);
        bin.add((byte)83);
        bin.add((byte)0);
        bin.add((byte)1);
        bin.add((byte)0);
        bin.add((byte)12);
        bin.add((byte)0);
        bin.add((byte)43);
        bin.add((byte)0);
        bin.add((byte)7);
        bin.add((byte)0);
        for (int i = 0; i < 43; ++i) {
            CharacterTextureType texture_type = this.character_data_array[i].GetTextureType();
            int itemp = CharacterBinSpecifierAndEnumConverter.GetBinSpecifierFromCharacterTextureType(texture_type);
            ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
            CharacterModelType model_type = this.character_data_array[i].GetModelType();
            itemp = CharacterBinSpecifierAndEnumConverter.GetBinSpecifierFromCharacterModelType(model_type);
            ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
            itemp = this.character_data_array[i].GetHP();
            ByteFunctions.AddUShortValueToBin_LE(bin, (int)itemp);
            CharacterAILevel ai_level = this.character_data_array[i].GetAILevel();
            itemp = CharacterBinSpecifierAndEnumConverter.GetBinSpecifierFromCharacterAILevel(ai_level);
            ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
            itemp = this.character_data_array[i].GetWeaponID(0);
            ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
            itemp = this.character_data_array[i].GetWeaponID(1);
            ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
            CharacterType type = this.character_data_array[i].GetType();
            itemp = CharacterBinSpecifierAndEnumConverter.GetBinSpecifierFromCharacterType(type);
            ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
        }
        try {
            FileFunctions.CreateBinFile((String)xcs_filename, bin);
        }
        catch (IOException e) {
            this.logger.error("Error while writing.", (Throwable)e);
            return -1;
        }
        return 0;
    }
}

