/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.properties.exe;

import com.daxie.basis.vector.Vector;
import com.daxie.tool.ByteFunctions;
import com.daxie.xops.properties.entity.weapon.WeaponBinSpecifierAndEnumConverter;
import com.daxie.xops.properties.entity.weapon.WeaponData;
import com.daxie.xops.properties.entity.weapon.WeaponModelFilenamesStock;
import com.daxie.xops.properties.entity.weapon.WeaponModelType;
import com.daxie.xops.properties.entity.weapon.WeaponScopeMode;
import com.daxie.xops.properties.entity.weapon.WeaponShootingStance;
import com.daxie.xops.properties.entity.weapon.WeaponTextureFilenamesStock;
import com.daxie.xops.properties.entity.weapon.WeaponTextureType;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class XOPSExeWeaponDataWriter {
    private Logger logger = LoggerFactory.getLogger(XOPSExeWeaponDataWriter.class);
    private WeaponData[] weapon_data_array;

    public XOPSExeWeaponDataWriter(WeaponData[] weapon_data_array) {
        this.weapon_data_array = weapon_data_array;
    }

    public int Write(List<Byte> bin, int weapon_data_start_pos, int weapon_name_start_pos) {
        int i;
        if (this.weapon_data_array == null) {
            this.logger.warn("Data not prepared.");
            return -1;
        }
        if (this.weapon_data_array.length != 23) {
            this.logger.warn("Invalid number of data. data_num={}", (Object)this.weapon_data_array.length);
            return -1;
        }
        int pos = weapon_data_start_pos;
        for (i = 0; i < 23; ++i) {
            int itemp = this.weapon_data_array[i].GetAttackPower();
            ByteFunctions.SetShortValueToBin_LE(bin, (int)pos, (short)((short)itemp));
            itemp = this.weapon_data_array[i].GetPenetration();
            ByteFunctions.SetShortValueToBin_LE(bin, (int)(pos += 2), (short)((short)itemp));
            itemp = this.weapon_data_array[i].GetFiringInterval();
            ByteFunctions.SetShortValueToBin_LE(bin, (int)(pos += 2), (short)((short)itemp));
            itemp = this.weapon_data_array[i].GetBulletSpeed();
            ByteFunctions.SetShortValueToBin_LE(bin, (int)(pos += 2), (short)((short)itemp));
            itemp = this.weapon_data_array[i].GetNumberOfBullets();
            ByteFunctions.SetShortValueToBin_LE(bin, (int)(pos += 2), (short)((short)itemp));
            itemp = this.weapon_data_array[i].GetReloadingTime();
            ByteFunctions.SetShortValueToBin_LE(bin, (int)(pos += 2), (short)((short)itemp));
            itemp = this.weapon_data_array[i].GetRecoil();
            ByteFunctions.SetShortValueToBin_LE(bin, (int)(pos += 2), (short)((short)itemp));
            itemp = this.weapon_data_array[i].GetErrorRangeMin();
            ByteFunctions.SetShortValueToBin_LE(bin, (int)(pos += 2), (short)((short)itemp));
            itemp = this.weapon_data_array[i].GetErrorRangeMax();
            ByteFunctions.SetShortValueToBin_LE(bin, (int)(pos += 2), (short)((short)itemp));
            Vector vtemp = this.weapon_data_array[i].GetPosition();
            itemp = Math.round(vtemp.GetX());
            ByteFunctions.SetShortValueToBin_LE(bin, (int)(pos += 2), (short)((short)itemp));
            itemp = Math.round(vtemp.GetY());
            ByteFunctions.SetShortValueToBin_LE(bin, (int)(pos += 2), (short)((short)itemp));
            itemp = Math.round(vtemp.GetZ());
            ByteFunctions.SetShortValueToBin_LE(bin, (int)(pos += 2), (short)((short)itemp));
            vtemp = this.weapon_data_array[i].GetFlashPosition();
            itemp = Math.round(vtemp.GetX());
            ByteFunctions.SetShortValueToBin_LE(bin, (int)(pos += 2), (short)((short)itemp));
            itemp = Math.round(vtemp.GetY());
            ByteFunctions.SetShortValueToBin_LE(bin, (int)(pos += 2), (short)((short)itemp));
            itemp = Math.round(vtemp.GetZ());
            ByteFunctions.SetShortValueToBin_LE(bin, (int)(pos += 2), (short)((short)itemp));
            vtemp = this.weapon_data_array[i].GetCartridgePosition();
            itemp = Math.round(vtemp.GetX());
            ByteFunctions.SetShortValueToBin_LE(bin, (int)(pos += 2), (short)((short)itemp));
            itemp = Math.round(vtemp.GetY());
            ByteFunctions.SetShortValueToBin_LE(bin, (int)(pos += 2), (short)((short)itemp));
            itemp = Math.round(vtemp.GetZ());
            ByteFunctions.SetShortValueToBin_LE(bin, (int)(pos += 2), (short)((short)itemp));
            WeaponShootingStance shooting_stance = this.weapon_data_array[i].GetShootingStance();
            itemp = WeaponBinSpecifierAndEnumConverter.GetBinSpecifierFromWeaponShootingStance(shooting_stance);
            ByteFunctions.SetShortValueToBin_LE(bin, (int)(pos += 2), (short)((short)itemp));
            itemp = !this.weapon_data_array[i].GetRapidFireEnabledFlag() ? 1 : 0;
            ByteFunctions.SetShortValueToBin_LE(bin, (int)(pos += 2), (short)((short)itemp));
            WeaponScopeMode scope_mode = this.weapon_data_array[i].GetScopeMode();
            itemp = WeaponBinSpecifierAndEnumConverter.GetBinSpecifierFromWeaponScopeMode(scope_mode);
            ByteFunctions.SetShortValueToBin_LE(bin, (int)(pos += 2), (short)((short)itemp));
            String texture_filename = this.weapon_data_array[i].GetTextureFilename();
            WeaponTextureType texture_type = WeaponTextureFilenamesStock.GetWeaponTextureTypeFromFilename(texture_filename);
            itemp = WeaponBinSpecifierAndEnumConverter.GetBinSpecifierFromWeaponTextureType(texture_type);
            ByteFunctions.SetShortValueToBin_LE(bin, (int)(pos += 2), (short)((short)itemp));
            String model_filename = this.weapon_data_array[i].GetModelFilename();
            WeaponModelType model_type = WeaponModelFilenamesStock.GetWeaponModelTypeFromFilename(model_filename);
            itemp = WeaponBinSpecifierAndEnumConverter.GetBinSpecifierFromWeaponModelType(model_type);
            ByteFunctions.SetShortValueToBin_LE(bin, (int)(pos += 2), (short)((short)itemp));
            itemp = Math.round(this.weapon_data_array[i].GetScale() * 10.0f);
            ByteFunctions.SetShortValueToBin_LE(bin, (int)(pos += 2), (short)((short)itemp));
            vtemp = this.weapon_data_array[i].GetCartridgeVelocity();
            itemp = Math.round(vtemp.GetX());
            ByteFunctions.SetShortValueToBin_LE(bin, (int)(pos += 2), (short)((short)itemp));
            itemp = Math.round(vtemp.GetY());
            ByteFunctions.SetShortValueToBin_LE(bin, (int)(pos += 2), (short)((short)itemp));
            itemp = this.weapon_data_array[i].GetSoundID();
            ByteFunctions.SetShortValueToBin_LE(bin, (int)(pos += 2), (short)((short)itemp));
            itemp = this.weapon_data_array[i].GetSoundVolume();
            ByteFunctions.SetShortValueToBin_LE(bin, (int)(pos += 2), (short)((short)itemp));
            itemp = !this.weapon_data_array[i].GetSuppressorEnabledFlag() ? 0 : 1;
            ByteFunctions.SetShortValueToBin_LE(bin, (int)(pos += 2), (short)((short)itemp));
            pos += 2;
        }
        pos = weapon_name_start_pos;
        for (i = 0; i < 23; ++i) {
            int j;
            String name = this.weapon_data_array[22 - i].GetName();
            byte[] name_buffer = new byte[16];
            for (j = 0; j < 16; ++j) {
                name_buffer[j] = 0;
            }
            for (j = 0; j < name.length() && j < 15; ++j) {
                name_buffer[j] = (byte)name.charAt(j);
            }
            for (j = 0; j < 16; ++j) {
                bin.set(pos + j, name_buffer[j]);
            }
            pos += 16;
        }
        return 0;
    }
}

