/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.properties.exe;

import com.daxie.tool.ByteFunctions;
import com.daxie.xops.properties.entity.character.CharacterAILevel;
import com.daxie.xops.properties.entity.character.CharacterBinSpecifierAndEnumConverter;
import com.daxie.xops.properties.entity.character.CharacterData;
import com.daxie.xops.properties.entity.character.CharacterModelType;
import com.daxie.xops.properties.entity.character.CharacterTextureType;
import com.daxie.xops.properties.entity.character.CharacterType;
import java.util.List;

class XOPSExeCharacterDataParser {
    private CharacterData[] character_data_array = new CharacterData[43];

    public XOPSExeCharacterDataParser(List<Byte> bin, int character_data_start_pos) {
        for (int i = 0; i < 43; ++i) {
            this.character_data_array[i] = new CharacterData();
        }
        int pos = character_data_start_pos;
        for (int i = 0; i < 43; ++i) {
            int itemp = ByteFunctions.GetShortValueFromBin_LE(bin, (int)pos);
            CharacterTextureType texture_type = CharacterBinSpecifierAndEnumConverter.GetCharacterTextureTypeFromBinSpecifier(itemp);
            this.character_data_array[i].SetTextureType(texture_type);
            itemp = ByteFunctions.GetShortValueFromBin_LE(bin, (int)(pos += 2));
            CharacterModelType model_type = CharacterBinSpecifierAndEnumConverter.GetCharacterModelTypeFromBinSpecifier(itemp);
            this.character_data_array[i].SetModelType(model_type);
            itemp = ByteFunctions.GetUShortValueFromBin_LE(bin, (int)(pos += 2));
            this.character_data_array[i].SetHP(itemp);
            itemp = ByteFunctions.GetShortValueFromBin_LE(bin, (int)(pos += 2));
            CharacterAILevel ai_level = CharacterBinSpecifierAndEnumConverter.GetCharacterAILevelFromBinSpecifier(itemp);
            this.character_data_array[i].SetAILevel(ai_level);
            itemp = ByteFunctions.GetShortValueFromBin_LE(bin, (int)(pos += 2));
            this.character_data_array[i].SetWeaponID(0, itemp);
            itemp = ByteFunctions.GetShortValueFromBin_LE(bin, (int)(pos += 2));
            this.character_data_array[i].SetWeaponID(1, itemp);
            itemp = ByteFunctions.GetShortValueFromBin_LE(bin, (int)(pos += 2));
            CharacterType type = CharacterBinSpecifierAndEnumConverter.GetCharacterTypeFromBinSpecifier(itemp);
            this.character_data_array[i].SetType(type);
            pos += 2;
        }
    }

    public CharacterData[] GetCharacterDataArray() {
        CharacterData[] ret = new CharacterData[this.character_data_array.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new CharacterData(this.character_data_array[i]);
        }
        return ret;
    }
}

