/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.properties.config;

import com.daxie.tool.FileFunctions;
import com.daxie.xops.properties.config.Config;
import com.daxie.xops.properties.config.KeyCode;
import com.daxie.xops.properties.config.WindowMode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfigWriter {
    private Logger logger = LoggerFactory.getLogger(ConfigWriter.class);
    private Config config;

    public ConfigWriter(Config config) {
        this.config = config;
    }

    public int Write(String config_filename) {
        if (this.config == null) {
            this.logger.warn("Data not prepared.");
            return -1;
        }
        ArrayList<Byte> bin = new ArrayList<Byte>();
        this.AddKeyCodeToBin(bin, this.config.GetTurnUp());
        this.AddKeyCodeToBin(bin, this.config.GetTurnDown());
        this.AddKeyCodeToBin(bin, this.config.GetTurnLeft());
        this.AddKeyCodeToBin(bin, this.config.GetTurnRight());
        this.AddKeyCodeToBin(bin, this.config.GetMoveForward());
        this.AddKeyCodeToBin(bin, this.config.GetMoveBackward());
        this.AddKeyCodeToBin(bin, this.config.GetMoveLeft());
        this.AddKeyCodeToBin(bin, this.config.GetMoveRight());
        this.AddKeyCodeToBin(bin, this.config.GetWalk());
        this.AddKeyCodeToBin(bin, this.config.GetJump());
        this.AddKeyCodeToBin(bin, this.config.GetReload());
        this.AddKeyCodeToBin(bin, this.config.GetDropWeapon());
        this.AddKeyCodeToBin(bin, this.config.GetZoom());
        this.AddKeyCodeToBin(bin, this.config.GetFireMode());
        this.AddKeyCodeToBin(bin, this.config.GetSwitchWeapon());
        this.AddKeyCodeToBin(bin, this.config.GetWeapon1());
        this.AddKeyCodeToBin(bin, this.config.GetWeapon2());
        this.AddKeyCodeToBin(bin, this.config.GetFire());
        bin.add((byte)this.config.GetMouseSensitivity());
        this.AddWindowModeToBin(bin, this.config.GetWindowMode());
        this.AddFlagToBin(bin, this.config.GetEnableSound());
        this.AddFlagToBin(bin, this.config.GetEnableBlood());
        bin.add((byte)this.config.GetBrightness());
        this.AddFlagToBin(bin, this.config.GetInvertMouse());
        this.AddFlagToBin(bin, this.config.GetFrameSkip());
        this.AddFlagToBin(bin, this.config.GetAnotherGunsight());
        this.AddNameToBin(bin, this.config.GetName());
        try {
            FileFunctions.CreateBinFile((String)config_filename, bin);
        }
        catch (IOException e) {
            this.logger.error("Error while writing.", (Throwable)e);
            return -1;
        }
        return 0;
    }

    private void AddKeyCodeToBin(List<Byte> bin, KeyCode key_code) {
        int ordinal = key_code.ordinal();
        bin.add((byte)ordinal);
    }

    private void AddWindowModeToBin(List<Byte> bin, WindowMode window_mode) {
        int ordinal = window_mode.ordinal();
        bin.add((byte)ordinal);
    }

    private void AddFlagToBin(List<Byte> bin, boolean flag) {
        if (!flag) {
            bin.add((byte)0);
        } else {
            bin.add((byte)1);
        }
    }

    private void AddNameToBin(List<Byte> bin, String name) {
        int i;
        byte[] name_buffer = new byte[21];
        for (i = 0; i < 21; ++i) {
            name_buffer[i] = 0;
        }
        for (i = 0; i < name.length() && i < 20; ++i) {
            name_buffer[i] = (byte)name.charAt(i);
        }
        for (i = 0; i < 21; ++i) {
            bin.add(name_buffer[i]);
        }
    }
}

