/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.properties.xms.xcs;

import com.daxie.log.LogFile;
import com.daxie.tool.ByteFunctions;
import com.daxie.tool.FileFunctions;
import com.daxie.xops.properties.entity.character.CharacterAILevel;
import com.daxie.xops.properties.entity.character.CharacterBinSpecifierAndEnumConverter;
import com.daxie.xops.properties.entity.character.CharacterData;
import com.daxie.xops.properties.entity.character.CharacterModelType;
import com.daxie.xops.properties.entity.character.CharacterTextureType;
import com.daxie.xops.properties.entity.character.CharacterType;
import java.io.IOException;
import java.util.List;

class XCSParser {
    private CharacterData[] character_data_array = null;

    public XCSParser(String xcs_filename) throws IOException {
        List bin = FileFunctions.GetFileAllBin((String)xcs_filename);
        if (bin.size() != 614) {
            LogFile.WriteWarn((String)("[XCSParser-<init>] Invalid file size. filename:" + xcs_filename), (boolean)true);
            return;
        }
        byte[] b = new byte[2];
        int count = 12;
        for (int i = 0; i < 43; ++i) {
            b[0] = (Byte)bin.get(count);
            b[1] = (Byte)bin.get(count + 1);
            int itemp = ByteFunctions.byte_to_short_le((byte[])b);
            CharacterTextureType texture_type = CharacterBinSpecifierAndEnumConverter.GetCharacterTextureTypeFromBinSpecifier(itemp);
            this.character_data_array[i].SetTextureType(texture_type);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le((byte[])b);
            CharacterModelType model_type = CharacterBinSpecifierAndEnumConverter.GetCharacterModelTypeFromBinSpecifier(itemp);
            this.character_data_array[i].SetModelType(model_type);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_ushort_le((byte[])b);
            this.character_data_array[i].SetHP(itemp);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le((byte[])b);
            CharacterAILevel ai_level = CharacterBinSpecifierAndEnumConverter.GetCharacterAILevelFromBinSpecifier(itemp);
            this.character_data_array[i].SetAILevel(ai_level);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le((byte[])b);
            this.character_data_array[i].SetWeaponID(0, itemp);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le((byte[])b);
            this.character_data_array[i].SetWeaponID(1, itemp);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le((byte[])b);
            count += 2;
            CharacterType type = CharacterBinSpecifierAndEnumConverter.GetCharacterTypeFromBinSpecifier(itemp);
            this.character_data_array[i].SetType(type);
        }
    }

    public CharacterData[] GetCharacterDataArray() {
        CharacterData[] ret = new CharacterData[this.character_data_array.length];
        for (int i = 0; i < this.character_data_array.length; ++i) {
            ret[i] = new CharacterData(this.character_data_array[i]);
        }
        return ret;
    }
}

