/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.properties.xms.xcs;

import com.daxie.log.LogFile;
import com.daxie.tool.ExceptionFunctions;
import com.daxie.xops.properties.entity.character.CharacterData;
import com.daxie.xops.properties.xms.xcs.XCSParser;
import com.daxie.xops.properties.xms.xcs.XCSWriter;
import java.io.FileNotFoundException;

public class XCSManipulator {
    private CharacterData[] character_data_array = null;

    public XCSManipulator(String xcs_filename) throws FileNotFoundException {
        XCSParser xcs_parser = new XCSParser(xcs_filename);
        this.character_data_array = xcs_parser.GetCharacterDataArray();
    }

    public XCSManipulator() {
    }

    public CharacterData[] GetCharacterDataArray() {
        if (this.character_data_array == null) {
            return null;
        }
        CharacterData[] ret = new CharacterData[this.character_data_array.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new CharacterData(this.character_data_array[i]);
        }
        return ret;
    }

    public void SetCharacterDataArray(CharacterData[] character_data_array) {
        if (character_data_array == null) {
            LogFile.WriteWarn((String)"[XCSManipulator-SetCharacterDataArray] Null argument where non-null required.", (boolean)true);
            return;
        }
        this.character_data_array = character_data_array;
    }

    public int Write(String xcs_filename) {
        XCSWriter xcs_writer = new XCSWriter(this.character_data_array);
        try {
            xcs_writer.Write(xcs_filename);
        }
        catch (FileNotFoundException e) {
            String str = ExceptionFunctions.GetPrintStackTraceString((Throwable)e);
            LogFile.WriteWarn((String)"[XCSManipulator-Write] Failed to write data.", (boolean)true);
            LogFile.WriteWarn((String)"Below is the stack trace.", (boolean)false);
            LogFile.WriteWarn((String)str, (boolean)false);
            return -1;
        }
        return 0;
    }
}

