/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.properties.entity.weapon;

import com.daxie.basis.vector.Vector;
import com.daxie.xops.properties.entity.weapon.WeaponScopeMode;
import com.daxie.xops.properties.entity.weapon.WeaponShootingStance;

public class WeaponData {
    private String name;
    private String model_filename;
    private String texture_filename;
    private int attack_power;
    private int penetration;
    private int firing_interval;
    private int bullet_speed;
    private int number_of_bullets;
    private int reloading_time;
    private int recoil;
    private int error_range_min;
    private int error_range_max;
    private Vector position;
    private Vector flash_position;
    private Vector cartridge_position;
    private Vector cartridge_velocity;
    private boolean rapid_fire_enabled_flag;
    private WeaponScopeMode scope_mode;
    private float scale;
    private int sound_id;
    private int sound_volume;
    private boolean suppressor_enabled_flag;
    private WeaponShootingStance shooting_stance;
    private int changeable_weapon;
    private int number_of_projectiles;

    public WeaponData() {
        this.name = "";
        this.model_filename = "";
        this.texture_filename = "";
        this.attack_power = 0;
        this.penetration = 0;
        this.firing_interval = 0;
        this.bullet_speed = 0;
        this.number_of_bullets = 0;
        this.reloading_time = 0;
        this.recoil = 0;
        this.error_range_min = 0;
        this.error_range_max = 0;
        this.position = new Vector();
        this.flash_position = new Vector();
        this.cartridge_position = new Vector();
        this.cartridge_velocity = new Vector();
        this.rapid_fire_enabled_flag = false;
        this.scope_mode = WeaponScopeMode.NONE;
        this.scale = 1.0f;
        this.sound_id = 0;
        this.sound_volume = 0;
        this.suppressor_enabled_flag = false;
        this.shooting_stance = WeaponShootingStance.RIFLE;
        this.changeable_weapon = -1;
        this.number_of_projectiles = 1;
    }

    public WeaponData(WeaponData w) {
        this.name = w.GetName();
        this.model_filename = w.GetModelFilename();
        this.texture_filename = w.GetTextureFilename();
        this.attack_power = w.GetAttackPower();
        this.penetration = w.GetPenetration();
        this.firing_interval = w.GetFiringInterval();
        this.bullet_speed = w.GetBulletSpeed();
        this.number_of_bullets = w.GetNumberOfBullets();
        this.reloading_time = w.GetReloadingTime();
        this.recoil = w.GetRecoil();
        this.error_range_min = w.GetErrorRangeMin();
        this.error_range_max = w.GetErrorRangeMax();
        this.position = w.GetPosition();
        this.flash_position = w.GetFlashPosition();
        this.cartridge_position = w.GetCartridgePosition();
        this.cartridge_velocity = w.GetCartridgeVelocity();
        this.rapid_fire_enabled_flag = w.GetRapidFireEnabledFlag();
        this.scope_mode = w.GetScopeMode();
        this.scale = w.GetScale();
        this.sound_id = w.GetSoundID();
        this.sound_volume = w.GetSoundVolume();
        this.suppressor_enabled_flag = w.GetSuppressorEnabledFlag();
        this.shooting_stance = w.GetShootingStance();
        this.changeable_weapon = w.GetChangeableWeapon();
        this.number_of_projectiles = w.GetNumberOfProjectiles();
    }

    public String toString() {
        String ret = "";
        String separator = System.getProperty("line.separator");
        ret = ret + "name:" + this.name + separator;
        ret = ret + "model_filename:" + this.model_filename + separator;
        ret = ret + "texture_filename:" + this.texture_filename + separator;
        ret = ret + "attack_power:" + this.attack_power + separator;
        ret = ret + "penetration:" + this.penetration + separator;
        ret = ret + "firing_interval:" + this.firing_interval + separator;
        ret = ret + "bullet_speed:" + this.bullet_speed + separator;
        ret = ret + "number_of_bullets:" + this.number_of_bullets + separator;
        ret = ret + "reloading_time:" + this.reloading_time + separator;
        ret = ret + "recoil:" + this.recoil + separator;
        ret = ret + "error_range_min:" + this.error_range_min + separator;
        ret = ret + "error_range_max:" + this.error_range_max + separator;
        ret = ret + "position:" + this.position + separator;
        ret = ret + "flash_position:" + this.flash_position + separator;
        ret = ret + "cartridge_position:" + this.cartridge_position + separator;
        ret = ret + "cartridge_velocity:" + this.cartridge_velocity + separator;
        ret = ret + "rapid_fire_enabled_flag:" + this.rapid_fire_enabled_flag + separator;
        ret = ret + "scope_mode:";
        ret = ret + this.scope_mode.toString().toLowerCase();
        ret = ret + separator;
        ret = ret + "scale:" + this.scale + separator;
        ret = ret + "sound_id:" + this.sound_id + separator;
        ret = ret + "sound_volume:" + this.sound_volume + separator;
        ret = ret + "suppressor_enabled_flag:" + this.suppressor_enabled_flag + separator;
        ret = ret + "shooting_stance:";
        ret = ret + this.shooting_stance.toString().toLowerCase();
        ret = ret + separator;
        ret = ret + "changeable_weapon:" + this.changeable_weapon + separator;
        ret = ret + "number_of_projectiles:" + this.number_of_projectiles;
        return ret;
    }

    public void SetName(String name) {
        this.name = name;
    }

    public void SetModelFilename(String model_filename) {
        this.model_filename = model_filename;
    }

    public void SetTextureFilename(String texture_filename) {
        this.texture_filename = texture_filename;
    }

    public void SetAttackPower(int attack_power) {
        this.attack_power = attack_power;
    }

    public void SetPenetration(int penetration) {
        this.penetration = penetration;
    }

    public void SetFiringInterval(int firing_interval) {
        this.firing_interval = firing_interval;
    }

    public void SetBulletSpeed(int bullet_speed) {
        this.bullet_speed = bullet_speed;
    }

    public void SetNumberOfBullets(int number_of_bullets) {
        this.number_of_bullets = number_of_bullets;
    }

    public void SetReloadingTime(int reloading_time) {
        this.reloading_time = reloading_time;
    }

    public void SetRecoil(int recoil) {
        this.recoil = recoil;
    }

    public void SetErrorRangeMin(int error_range_min) {
        this.error_range_min = error_range_min;
    }

    public void SetErrorRangeMax(int error_range_max) {
        this.error_range_max = error_range_max;
    }

    public void SetPosition(Vector position) {
        this.position = position;
    }

    public void SetFlashPosition(Vector flash_position) {
        this.flash_position = flash_position;
    }

    public void SetCartridgePosition(Vector cartridge_position) {
        this.cartridge_position = cartridge_position;
    }

    public void SetCartridgeVelocity(Vector cartridge_velocity) {
        this.cartridge_velocity = cartridge_velocity;
    }

    public void SetRapidFireEnabledFlag(boolean rapid_fire_enabled_flag) {
        this.rapid_fire_enabled_flag = rapid_fire_enabled_flag;
    }

    public void SetScopeMode(WeaponScopeMode scope_mode) {
        this.scope_mode = scope_mode;
    }

    public void SetScale(float scale) {
        this.scale = scale;
    }

    public void SetSoundID(int sound_id) {
        this.sound_id = sound_id;
    }

    public void SetSoundVolume(int sound_volume) {
        this.sound_volume = sound_volume;
    }

    public void SetSuppressorEnabledFlag(boolean suppressor_enabled_flag) {
        this.suppressor_enabled_flag = suppressor_enabled_flag;
    }

    public void SetShootingStance(WeaponShootingStance shooting_stance) {
        this.shooting_stance = shooting_stance;
    }

    public void SetChangeableWeapon(int changeable_weapon) {
        this.changeable_weapon = changeable_weapon;
    }

    public void SetNumberOfProjectiles(int number_of_projectiles) {
        this.number_of_projectiles = number_of_projectiles;
    }

    public String GetName() {
        return this.name;
    }

    public String GetModelFilename() {
        return this.model_filename;
    }

    public String GetTextureFilename() {
        return this.texture_filename;
    }

    public int GetAttackPower() {
        return this.attack_power;
    }

    public int GetPenetration() {
        return this.penetration;
    }

    public int GetFiringInterval() {
        return this.firing_interval;
    }

    public int GetBulletSpeed() {
        return this.bullet_speed;
    }

    public int GetNumberOfBullets() {
        return this.number_of_bullets;
    }

    public int GetReloadingTime() {
        return this.reloading_time;
    }

    public int GetRecoil() {
        return this.recoil;
    }

    public int GetErrorRangeMin() {
        return this.error_range_min;
    }

    public int GetErrorRangeMax() {
        return this.error_range_max;
    }

    public Vector GetPosition() {
        return new Vector(this.position);
    }

    public Vector GetFlashPosition() {
        return new Vector(this.flash_position);
    }

    public Vector GetCartridgePosition() {
        return new Vector(this.cartridge_position);
    }

    public Vector GetCartridgeVelocity() {
        return new Vector(this.cartridge_velocity);
    }

    public boolean GetRapidFireEnabledFlag() {
        return this.rapid_fire_enabled_flag;
    }

    public WeaponScopeMode GetScopeMode() {
        return this.scope_mode;
    }

    public float GetScale() {
        return this.scale;
    }

    public int GetSoundID() {
        return this.sound_id;
    }

    public int GetSoundVolume() {
        return this.sound_volume;
    }

    public boolean GetSuppressorEnabledFlag() {
        return this.suppressor_enabled_flag;
    }

    public WeaponShootingStance GetShootingStance() {
        return this.shooting_stance;
    }

    public int GetChangeableWeapon() {
        return this.changeable_weapon;
    }

    public int GetNumberOfProjectiles() {
        return this.number_of_projectiles;
    }
}

