/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.properties.xms.xgs;

import com.daxie.log.LogFile;
import com.daxie.tool.ExceptionFunctions;
import com.daxie.xops.properties.entity.weapon.WeaponData;
import com.daxie.xops.properties.xms.xgs.XGSParser;
import com.daxie.xops.properties.xms.xgs.XGSWriter;
import java.io.FileNotFoundException;

public class XGSManipulator {
    private WeaponData[] weapon_data_array = null;

    public XGSManipulator(String xgs_filename) throws FileNotFoundException {
        XGSParser xgs_parser = new XGSParser(xgs_filename);
        this.weapon_data_array = xgs_parser.GetWeaponDataArray();
    }

    public XGSManipulator() {
    }

    public WeaponData[] GetWeaponDataArray() {
        if (this.weapon_data_array == null) {
            return null;
        }
        WeaponData[] ret = new WeaponData[this.weapon_data_array.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new WeaponData(this.weapon_data_array[i]);
        }
        return ret;
    }

    public void SetWeaponDataArray(WeaponData[] weapon_data_array) {
        if (weapon_data_array == null) {
            LogFile.WriteWarn((String)"[XGSManipulator-SetWeaponDataArray] Null argument where non-null required.", (boolean)true);
            return;
        }
        this.weapon_data_array = weapon_data_array;
    }

    public int Write(String xgs_filename) {
        XGSWriter xgs_writer = new XGSWriter(this.weapon_data_array);
        try {
            xgs_writer.Write(xgs_filename);
        }
        catch (FileNotFoundException e) {
            String str = ExceptionFunctions.GetPrintStackTraceString((Throwable)e);
            LogFile.WriteWarn((String)"[XGSManipulator-Write] Failed to write data.", (boolean)true);
            LogFile.WriteWarn((String)"Below is the stack trace.", (boolean)false);
            LogFile.WriteWarn((String)str, (boolean)false);
            return -1;
        }
        return 0;
    }
}

