/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.properties.xml;

import com.daxie.log.LogFile;
import com.daxie.tool.ExceptionFunctions;
import com.daxie.xops.properties.entity.character.CharacterAILevel;
import com.daxie.xops.properties.entity.character.CharacterData;
import com.daxie.xops.properties.entity.character.CharacterModelType;
import com.daxie.xops.properties.entity.character.CharacterTextureType;
import com.daxie.xops.properties.entity.character.CharacterType;
import com.daxie.xops.properties.openxops.CharacterSpecifierConverter;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CharacterDataXMLParser {
    private Map<Integer, CharacterData> character_data_map = new HashMap<Integer, CharacterData>();
    private boolean openxops_compatible_flag = true;

    public void SetOpenXOPSCompatibleFlag(boolean openxops_compatible_flag) {
        this.openxops_compatible_flag = openxops_compatible_flag;
    }

    public int LoadCharacterDataXML(String xml_filename) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            String str = ExceptionFunctions.GetPrintStackTraceString((Throwable)e);
            LogFile.WriteWarn((String)"[CharacterDataXMLParser-LoadCharacterDataXML] Below is the stack trace.", (boolean)true);
            LogFile.WriteWarn((String)str, (boolean)false);
            return -1;
        }
        Document document = null;
        try {
            document = builder.parse(Paths.get(xml_filename, new String[0]).toFile());
        }
        catch (Exception e) {
            String str = ExceptionFunctions.GetPrintStackTraceString((Throwable)e);
            LogFile.WriteWarn((String)"[CharacterDataXMLParser-LoadCharacterDataXML] Below is the stack trace.", (boolean)true);
            LogFile.WriteWarn((String)str, (boolean)false);
            return -1;
        }
        Element el_character_data_list = document.getDocumentElement();
        NodeList node_list = el_character_data_list.getChildNodes();
        for (int i = 0; i < node_list.getLength(); ++i) {
            Element element;
            String element_name;
            Node node = node_list.item(i);
            if (node.getNodeType() != 1 || !(element_name = (element = (Element)node).getNodeName()).equals("character")) continue;
            int character_id = -1;
            CharacterData character_data = new CharacterData();
            String strtemp = element.getAttribute("id");
            try {
                character_id = Integer.parseInt(strtemp);
            }
            catch (NumberFormatException e) {
                LogFile.WriteWarn((String)("[CharacterDataXMLParser] Invalid format of number. id:" + strtemp), (boolean)true);
                continue;
            }
            NodeList node_list_sub = element.getChildNodes();
            for (int j = 0; j < node_list_sub.getLength(); ++j) {
                String str;
                Enum[] values;
                int itemp;
                Node node_sub = node_list_sub.item(j);
                if (node_sub.getNodeType() != 1) continue;
                Element element_sub = (Element)node_sub;
                String element_sub_name = element_sub.getNodeName();
                strtemp = element_sub.getTextContent();
                if (element_sub_name.equals("texture")) {
                    itemp = Integer.parseInt(strtemp);
                    if (this.openxops_compatible_flag) {
                        CharacterTextureType texture_type = CharacterSpecifierConverter.GetXOPSTextureTypeFromOpenXOPSTextureID(itemp);
                        character_data.SetTextureType(texture_type);
                        continue;
                    }
                    values = CharacterTextureType.values();
                    if (0 > itemp || itemp >= values.length) {
                        LogFile.WriteWarn((String)"[CharacterDataXMLParser-LoadCharacterDataXML] Specifier out of bounds.", (boolean)true);
                        str = "";
                        str = str + "character_id" + character_id + " ";
                        str = str + "texture:" + itemp;
                        LogFile.WriteLine((String)str);
                        character_data.SetTextureType(CharacterTextureType.SOLDIER_BLACK);
                        continue;
                    }
                    character_data.SetTextureType((CharacterTextureType)values[itemp]);
                    continue;
                }
                if (element_sub_name.equals("model")) {
                    itemp = Integer.parseInt(strtemp);
                    values = CharacterModelType.values();
                    if (0 > itemp || itemp >= values.length) {
                        LogFile.WriteWarn((String)"[CharacterDataXMLParser-LoadCharacterDataXML] Specifier out of bounds.", (boolean)true);
                        str = "";
                        str = str + "character_id:" + character_id + " ";
                        str = str + "model:" + itemp;
                        LogFile.WriteLine((String)str);
                        character_data.SetModelType(CharacterModelType.MALE);
                        continue;
                    }
                    character_data.SetModelType((CharacterModelType)values[itemp]);
                    continue;
                }
                if (element_sub_name.equals("hp")) {
                    itemp = Integer.parseInt(strtemp);
                    character_data.SetHP(itemp);
                    continue;
                }
                if (element_sub_name.equals("AIlevel")) {
                    itemp = Integer.parseInt(strtemp);
                    if (this.openxops_compatible_flag) {
                        CharacterAILevel ai_level = CharacterSpecifierConverter.GetXOPSAILevelFromOpenXOPSAILevel(itemp);
                        character_data.SetAILevel(ai_level);
                        continue;
                    }
                    values = CharacterAILevel.values();
                    if (0 > itemp || itemp >= values.length) {
                        LogFile.WriteWarn((String)"[CharacterDataXMLParser-LoadCharacterDataXML] Specifier out of bounds.", (boolean)true);
                        str = "";
                        str = str + "character_id:" + character_id + " ";
                        str = str + "ai_level:" + itemp;
                        LogFile.WriteLine((String)str);
                        character_data.SetAILevel(CharacterAILevel.C);
                        continue;
                    }
                    character_data.SetAILevel((CharacterAILevel)values[itemp]);
                    continue;
                }
                if (element_sub_name.equals("WeaponA")) {
                    itemp = Integer.parseInt(strtemp);
                    character_data.SetWeaponID(0, itemp);
                    continue;
                }
                if (element_sub_name.equals("WeaponB")) {
                    itemp = Integer.parseInt(strtemp);
                    character_data.SetWeaponID(1, itemp);
                    continue;
                }
                if (!element_sub_name.equals("type")) continue;
                itemp = Integer.parseInt(strtemp);
                values = CharacterType.values();
                if (0 > itemp || itemp >= values.length) {
                    LogFile.WriteWarn((String)"[CharacterDataXMLParser-LoadCharacterDataXML] Specifier out of bounds.", (boolean)true);
                    str = "";
                    str = str + "character_id:" + character_id + " ";
                    str = str + "type:" + itemp;
                    LogFile.WriteLine((String)str);
                    character_data.SetType(CharacterType.HUMAN);
                    continue;
                }
                character_data.SetType((CharacterType)values[itemp]);
            }
            this.character_data_map.put(character_id, character_data);
        }
        return 0;
    }

    public Map<Integer, CharacterData> GetCharacterDataMap() {
        return new HashMap<Integer, CharacterData>(this.character_data_map);
    }
}

