/*
 * Decompiled with CFR 0.152.
 */
package com.github.dabasan.joglfaddon.pointlight;

import com.github.dabasan.basis.coloru8.ColorU8;
import com.github.dabasan.basis.vector.Vector;
import com.github.dabasan.joglf.gl.front.CameraFront;
import com.github.dabasan.joglf.gl.shader.ShaderProgram;
import com.github.dabasan.joglfaddon.pointlight.PointLight;
import com.github.dabasan.joglfaddon.pointlight.PointLightShadingMethod;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PointLightMgr {
    private final Logger logger = LoggerFactory.getLogger(PointLightMgr.class);
    public final int MAX_POINT_LIGHT_NUM = 256;
    private int count = 0;
    private final Map<Integer, PointLight> lights_map = new HashMap<Integer, PointLight>();
    private final ShaderProgram gouraud_program = new ShaderProgram("dabasan/point_light/gouraud", "./Data/Shader/330/addon/dabasan/point_light/gouraud/vshader.glsl", "./Data/Shader/330/addon/dabasan/point_light/gouraud/fshader.glsl");
    private final ShaderProgram phong_program = new ShaderProgram("dabasan/point_light/phong", "./Data/Shader/330/addon/dabasan/point_light/phong/vshader.glsl", "./Data/Shader/330/addon/dabasan/point_light/phong/fshader.glsl");

    public PointLightMgr() {
        CameraFront.AddProgram((ShaderProgram)this.gouraud_program);
        CameraFront.AddProgram((ShaderProgram)this.phong_program);
        this.SetColorSumClamp(0.0f, 1.0f);
    }

    public void Dispose() {
        CameraFront.RemoveProgram((ShaderProgram)this.gouraud_program);
        CameraFront.RemoveProgram((ShaderProgram)this.phong_program);
    }

    public int CreatePointLight(PointLightShadingMethod method) {
        if (this.lights_map.size() > 256) {
            this.logger.warn("No more point lights can be created.");
            return -1;
        }
        int light_handle = this.count;
        PointLight light = new PointLight();
        if (method == PointLightShadingMethod.GOURAUD) {
            light.AddProgram(this.gouraud_program);
        } else {
            light.AddProgram(this.phong_program);
        }
        this.lights_map.put(light_handle, light);
        ++this.count;
        this.gouraud_program.Enable();
        this.gouraud_program.SetUniform("current_point_light_num", this.lights_map.size());
        this.gouraud_program.Disable();
        this.phong_program.Enable();
        this.phong_program.SetUniform("current_point_light_num", this.lights_map.size());
        this.phong_program.Disable();
        return light_handle;
    }

    public int DeletePointLight(int point_light_handle) {
        if (!this.lights_map.containsKey(point_light_handle)) {
            this.logger.trace("No such point light. point_light_handle={}", (Object)point_light_handle);
            return -1;
        }
        this.lights_map.remove(point_light_handle);
        this.gouraud_program.Enable();
        this.gouraud_program.SetUniform("current_point_light_num", this.lights_map.size());
        this.gouraud_program.Disable();
        this.phong_program.Enable();
        this.phong_program.SetUniform("current_point_light_num", this.lights_map.size());
        this.phong_program.Disable();
        return 0;
    }

    public void DeleteAllPointLights() {
        this.lights_map.clear();
        this.count = 0;
        this.gouraud_program.Enable();
        this.gouraud_program.SetUniform("current_point_light_num", 0);
        this.gouraud_program.Disable();
        this.phong_program.Enable();
        this.phong_program.SetUniform("current_point_light_num", 0);
        this.phong_program.Disable();
    }

    public int AddProgram(int point_light_handle, ShaderProgram program) {
        if (!this.lights_map.containsKey(point_light_handle)) {
            this.logger.trace("No such point light. point_light_handle={}", (Object)point_light_handle);
            return -1;
        }
        PointLight light = this.lights_map.get(point_light_handle);
        light.AddProgram(program);
        return 0;
    }

    public int RemoveAllPrograms(int point_light_handle) {
        if (!this.lights_map.containsKey(point_light_handle)) {
            this.logger.trace("No such point light. point_light_handle={}", (Object)point_light_handle);
            return -1;
        }
        PointLight light = this.lights_map.get(point_light_handle);
        light.RemoveAllPrograms();
        return 0;
    }

    public int SetPosition(int point_light_handle, Vector position) {
        if (!this.lights_map.containsKey(point_light_handle)) {
            this.logger.trace("No such point light. point_light_handle={}", (Object)point_light_handle);
            return -1;
        }
        PointLight light = this.lights_map.get(point_light_handle);
        light.SetPosition(position);
        return 0;
    }

    public int SetK(int point_light_handle, float k0, float k1, float k2) {
        if (!this.lights_map.containsKey(point_light_handle)) {
            this.logger.trace("No such point light. point_light_handle={}", (Object)point_light_handle);
            return -1;
        }
        PointLight light = this.lights_map.get(point_light_handle);
        light.SetK(k0, k1, k2);
        return 0;
    }

    public int SetDiffuseColor(int point_light_handle, ColorU8 diffuse_color) {
        if (!this.lights_map.containsKey(point_light_handle)) {
            this.logger.trace("No such point light. point_light_handle={}", (Object)point_light_handle);
            return -1;
        }
        PointLight light = this.lights_map.get(point_light_handle);
        light.SetDiffuseColor(diffuse_color);
        return 0;
    }

    public int SetDiffusePower(int point_light_handle, float diffuse_power) {
        if (!this.lights_map.containsKey(point_light_handle)) {
            this.logger.trace("No such point light. point_light_handle={}", (Object)point_light_handle);
            return -1;
        }
        PointLight light = this.lights_map.get(point_light_handle);
        light.SetDiffusePower(diffuse_power);
        return 0;
    }

    public int SetColorClamp(int point_light_handle, float min, float max) {
        if (!this.lights_map.containsKey(point_light_handle)) {
            this.logger.trace("No such point light. point_light_handle={}", (Object)point_light_handle);
            return -1;
        }
        PointLight light = this.lights_map.get(point_light_handle);
        light.SetColorClamp(min, max);
        return 0;
    }

    public void SetColorSumClamp(float min, float max) {
        this.gouraud_program.Enable();
        this.gouraud_program.SetUniform("point_light_color_sum_clamp_min", min);
        this.gouraud_program.SetUniform("point_light_color_sum_clamp_max", max);
        this.gouraud_program.Disable();
        this.phong_program.Enable();
        this.phong_program.SetUniform("point_light_color_sum_clamp_min", min);
        this.phong_program.SetUniform("point_light_color_sum_clamp_max", max);
        this.phong_program.Disable();
    }

    public void Update() {
        int index = 0;
        for (PointLight light : this.lights_map.values()) {
            light.Update(index);
            ++index;
        }
    }
}

