/*
 * Decompiled with CFR 0.152.
 */
package com.github.curiousoddman.rgxgen.generator.nodes;

import com.github.curiousoddman.rgxgen.generator.nodes.Node;
import com.github.curiousoddman.rgxgen.generator.visitors.NodeVisitor;
import com.github.curiousoddman.rgxgen.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class SymbolSet
extends Node {
    private static final String[] ALL_SYMBOLS = new String[95];
    private static final int SPACE_ASCII_CODE = 32;
    private static final int DEL_ASCII_CODE = 127;
    private final String[] aSymbols;

    public static String[] getAllSymbols() {
        return (String[])ALL_SYMBOLS.clone();
    }

    public SymbolSet() {
        this(".", (String[])ALL_SYMBOLS.clone(), TYPE.POSITIVE);
    }

    public SymbolSet(String pattern, String[] symbols, TYPE type) {
        this(pattern, Collections.emptyList(), symbols, type);
    }

    public SymbolSet(String pattern, Collection<SymbolRange> symbolRanges, TYPE type) {
        this(pattern, symbolRanges, Util.ZERO_LENGTH_STRING_ARRAY, type);
    }

    public SymbolSet(String pattern, Collection<SymbolRange> symbolRanges, String[] symbols, TYPE type) {
        super(pattern);
        ArrayList<String> initial = type == TYPE.NEGATIVE ? new ArrayList<String>(Arrays.asList(ALL_SYMBOLS)) : new ArrayList(ALL_SYMBOLS.length);
        SymbolSet.filterOrPut(initial, Arrays.asList(symbols), type);
        SymbolSet.filterOrPut(initial, symbolRanges.stream().flatMapToInt(r -> IntStream.rangeClosed(r.getFrom(), r.getTo())).mapToObj(i -> Character.valueOf((char)i)).map(Object::toString).collect(Collectors.toList()), type);
        this.aSymbols = initial.toArray(Util.ZERO_LENGTH_STRING_ARRAY);
    }

    private static void filterOrPut(Collection<String> input, List<String> symbols, TYPE type) {
        if (type == TYPE.POSITIVE) {
            input.addAll(symbols);
        } else {
            input.removeIf(symbols::contains);
        }
    }

    @Override
    public void visit(NodeVisitor visitor) {
        visitor.visit(this);
    }

    public String[] getSymbols() {
        return this.aSymbols;
    }

    public String toString() {
        return "SymbolSet{" + Arrays.toString(this.aSymbols) + '}';
    }

    public boolean isEmpty() {
        return this.aSymbols.length == 0;
    }

    static {
        for (int i = 32; i < 127; ++i) {
            Character character = Character.valueOf((char)i);
            SymbolSet.ALL_SYMBOLS[i - 32] = character.toString();
        }
    }

    public static class SymbolRange {
        public static final SymbolRange SMALL_LETTERS = new SymbolRange('a', 'z');
        public static final SymbolRange CAPITAL_LETTERS = new SymbolRange('A', 'Z');
        public static final SymbolRange DIGITS = new SymbolRange('0', '9');
        private final int aFrom;
        private final int aTo;

        public SymbolRange(char from, char to) {
            this.aFrom = from;
            this.aTo = to;
        }

        int getFrom() {
            return this.aFrom;
        }

        int getTo() {
            return this.aTo;
        }

        public String toString() {
            return "SymbolRange{" + this.aFrom + ':' + this.aTo + '}';
        }
    }

    public static enum TYPE {
        POSITIVE,
        NEGATIVE;

    }
}

