/*
 * Decompiled with CFR 0.152.
 */
package com.github.curiousoddman.rgxgen.parsing.dflt;

import com.github.curiousoddman.rgxgen.generator.nodes.Choice;
import com.github.curiousoddman.rgxgen.generator.nodes.FinalSymbol;
import com.github.curiousoddman.rgxgen.generator.nodes.Group;
import com.github.curiousoddman.rgxgen.generator.nodes.GroupRef;
import com.github.curiousoddman.rgxgen.generator.nodes.Node;
import com.github.curiousoddman.rgxgen.generator.nodes.NotSymbol;
import com.github.curiousoddman.rgxgen.generator.nodes.Repeat;
import com.github.curiousoddman.rgxgen.generator.nodes.Sequence;
import com.github.curiousoddman.rgxgen.generator.nodes.SymbolSet;
import com.github.curiousoddman.rgxgen.parsing.NodeTreeBuilder;
import com.github.curiousoddman.rgxgen.parsing.dflt.CharIterator;
import com.github.curiousoddman.rgxgen.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.IntStream;

public class DefaultTreeBuilder
implements NodeTreeBuilder {
    private final CharIterator aCharIterator;
    private Node aNode;
    private int aNextGroupIndex = 1;

    public DefaultTreeBuilder(String expr) {
        this.aCharIterator = new CharIterator(expr);
    }

    private static void sbToFinal(StringBuilder sb, List<Node> nodes) {
        if (sb.length() != 0) {
            nodes.add(new FinalSymbol(sb.toString()));
            sb.delete(0, sb.length());
        }
    }

    private GroupType processGroupType() {
        switch (this.aCharIterator.next(2)) {
            case "?=": {
                return GroupType.POSITIVE_LOOKAHEAD;
            }
            case "?:": {
                return GroupType.NON_CAPTURE_GROUP;
            }
            case "?!": {
                return GroupType.NEGATIVE_LOOKAHEAD;
            }
            case "?<": {
                GroupType res = GroupType.POSITIVE_LOOKBEHIND;
                char next = this.aCharIterator.next().charValue();
                if (next == '!') {
                    res = GroupType.NEGATIVE_LOOKBEHIND;
                } else if (next != '=') {
                    throw new RuntimeException("Unexpected symbol in pattern: " + this.aCharIterator.context());
                }
                return res;
            }
        }
        this.aCharIterator.move(-2);
        return GroupType.CAPTURE_GROUP;
    }

    public Node parseGroup(GroupType currentGroupType) {
        Integer captureGroupIndex = null;
        if (currentGroupType == GroupType.CAPTURE_GROUP) {
            captureGroupIndex = this.aNextGroupIndex++;
        }
        ArrayList<Node> choices = new ArrayList<Node>();
        ArrayList<Node> nodes = new ArrayList<Node>();
        StringBuilder sb = new StringBuilder(this.aCharIterator.remaining());
        boolean isChoice = false;
        block9: while (this.aCharIterator.hasNext()) {
            char c = this.aCharIterator.next().charValue();
            switch (c) {
                case '[': {
                    DefaultTreeBuilder.sbToFinal(sb, nodes);
                    nodes.add(this.handleCharacterVariations());
                    continue block9;
                }
                case '(': {
                    DefaultTreeBuilder.sbToFinal(sb, nodes);
                    GroupType groupType = this.processGroupType();
                    if (groupType.isNegative()) {
                        String subPattern = this.aCharIterator.nextUntil(')');
                        nodes.add(new NotSymbol(subPattern));
                        this.aCharIterator.next();
                        continue block9;
                    }
                    nodes.add(this.parseGroup(groupType));
                    continue block9;
                }
                case '|': {
                    if (sb.length() == 0 && nodes.isEmpty()) {
                        choices.add(new FinalSymbol(""));
                    } else {
                        DefaultTreeBuilder.sbToFinal(sb, nodes);
                        choices.add(this.sequenceOrNot(nodes, choices, false, null));
                        nodes.clear();
                    }
                    isChoice = true;
                    continue block9;
                }
                case ')': {
                    DefaultTreeBuilder.sbToFinal(sb, nodes);
                    if (isChoice) {
                        choices.add(this.sequenceOrNot(nodes, choices, false, null));
                        nodes.clear();
                    }
                    return this.sequenceOrNot(nodes, choices, isChoice, captureGroupIndex);
                }
                case '*': 
                case '+': 
                case '?': 
                case '{': {
                    Node repeatNode = null;
                    if (sb.length() == 0) {
                        repeatNode = nodes.remove(nodes.size() - 1);
                    } else {
                        char charToRepeat = sb.charAt(sb.length() - 1);
                        sb.deleteCharAt(sb.length() - 1);
                        DefaultTreeBuilder.sbToFinal(sb, nodes);
                        repeatNode = new FinalSymbol(String.valueOf(charToRepeat));
                    }
                    nodes.add(this.handleRepeat(c, repeatNode));
                    continue block9;
                }
                case '.': {
                    DefaultTreeBuilder.sbToFinal(sb, nodes);
                    nodes.add(new SymbolSet());
                    continue block9;
                }
                case '\\': {
                    this.handleEscapedCharacter(sb, nodes, true);
                    continue block9;
                }
            }
            sb.append(c);
        }
        DefaultTreeBuilder.sbToFinal(sb, nodes);
        return this.sequenceOrNot(nodes, choices, isChoice, captureGroupIndex);
    }

    private void handleEscapedCharacter(StringBuilder sb, List<Node> nodes, boolean groupRefAllowed) {
        char c = this.aCharIterator.next().charValue();
        switch (c) {
            case 'D': 
            case 'd': {
                DefaultTreeBuilder.sbToFinal(sb, nodes);
                String[] digits = (String[])IntStream.rangeClosed(0, 9).mapToObj(Integer::toString).toArray(String[]::new);
                nodes.add(new SymbolSet(digits, c == 'd' ? SymbolSet.TYPE.POSITIVE : SymbolSet.TYPE.NEGATIVE));
                break;
            }
            case 'S': 
            case 's': {
                DefaultTreeBuilder.sbToFinal(sb, nodes);
                String[] whiteSpaces = new String[]{" ", "\t", "\n"};
                nodes.add(new SymbolSet(whiteSpaces, c == 's' ? SymbolSet.TYPE.POSITIVE : SymbolSet.TYPE.NEGATIVE));
                break;
            }
            case 'W': 
            case 'w': {
                DefaultTreeBuilder.sbToFinal(sb, nodes);
                String[] wordSymbols = new String[]{"_"};
                nodes.add(new SymbolSet(Arrays.asList(new SymbolSet.SymbolRange('a', 'z'), new SymbolSet.SymbolRange('A', 'Z'), new SymbolSet.SymbolRange('0', '9')), wordSymbols, c == 'w' ? SymbolSet.TYPE.POSITIVE : SymbolSet.TYPE.NEGATIVE));
                break;
            }
            case 'x': {
                String hexValue;
                c = this.aCharIterator.peek();
                if (c == '{') {
                    this.aCharIterator.move();
                    hexValue = this.aCharIterator.nextUntil('}');
                    this.aCharIterator.move();
                } else {
                    hexValue = this.aCharIterator.next(2);
                }
                int value = Integer.parseInt(hexValue, 16);
                sb.append((char)value);
                break;
            }
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                DefaultTreeBuilder.sbToFinal(sb, nodes);
                if (groupRefAllowed) {
                    String digitsSubstring = this.aCharIterator.takeWhile(Character::isDigit);
                    nodes.add(new GroupRef(Integer.parseInt(c + digitsSubstring)));
                    break;
                }
                throw new RuntimeException("Group ref is not expected here. " + this.aCharIterator.context());
            }
            default: {
                sb.append(c);
            }
        }
    }

    private Repeat handleRepeat(char c, Node repeatNode) {
        if (c == '*') {
            return Repeat.minimum(repeatNode, 0);
        }
        if (c == '?') {
            return new Repeat(repeatNode, 0, 1);
        }
        if (c == '+') {
            return Repeat.minimum(repeatNode, 1);
        }
        if (c == '{') {
            StringBuilder sb = new StringBuilder();
            int min = -1;
            block5: while (this.aCharIterator.hasNext()) {
                char tmpc = this.aCharIterator.next().charValue();
                switch (tmpc) {
                    case ',': {
                        min = Integer.parseInt(sb.toString());
                        sb.delete(0, sb.length());
                        continue block5;
                    }
                    case '}': {
                        if (min == -1) {
                            return new Repeat(repeatNode, Integer.parseInt(sb.toString()));
                        }
                        if (sb.length() == 0) {
                            return Repeat.minimum(repeatNode, min);
                        }
                        return new Repeat(repeatNode, min, Integer.parseInt(sb.toString()));
                    }
                    case '\\': {
                        tmpc = this.aCharIterator.next().charValue();
                    }
                }
                sb.append(tmpc);
            }
            throw new RuntimeException("Unbalanced '{' - missing '}'");
        }
        throw new RuntimeException("Unknown repetition character '" + c + '\'');
    }

    private Node sequenceOrNot(List<Node> nodes, List<Node> choices, boolean isChoice, Integer captureGroupIndex) {
        Node resultNode;
        if (nodes.size() == 1) {
            resultNode = nodes.get(0);
        } else if (isChoice) {
            if (choices.isEmpty()) {
                throw new RuntimeException("Empty nodes");
            }
            resultNode = new Choice(choices.toArray(new Node[0]));
        } else {
            if (nodes.isEmpty()) {
                throw new RuntimeException("Empty nodes");
            }
            resultNode = new Sequence(nodes.toArray(new Node[0]));
        }
        if (captureGroupIndex == null) {
            return resultNode;
        }
        return new Group(captureGroupIndex, resultNode);
    }

    private static boolean handleRange(boolean rangeStarted, StringBuilder sb, List<SymbolSet.SymbolRange> symbolRanges) {
        if (rangeStarted) {
            char lastChar = sb.charAt(sb.length() - 1);
            char firstChar = sb.charAt(sb.length() - 2);
            sb.delete(sb.length() - 2, sb.length());
            symbolRanges.add(new SymbolSet.SymbolRange(firstChar, lastChar));
        }
        return false;
    }

    private Node handleCharacterVariations() {
        SymbolSet.TYPE symbolSetType = SymbolSet.TYPE.POSITIVE;
        if (this.aCharIterator.peek() == '^') {
            symbolSetType = SymbolSet.TYPE.NEGATIVE;
            this.aCharIterator.next();
        }
        StringBuilder sb = new StringBuilder(this.aCharIterator.remaining());
        LinkedList<SymbolSet.SymbolRange> symbolRanges = new LinkedList<SymbolSet.SymbolRange>();
        boolean rangeStarted = false;
        block5: while (this.aCharIterator.hasNext()) {
            char c = this.aCharIterator.next().charValue();
            switch (c) {
                case ']': {
                    DefaultTreeBuilder.handleRange(rangeStarted, sb, symbolRanges);
                    String[] strings = sb.length() == 0 ? new String[]{} : Util.stringToCharsSubstrings(sb.toString());
                    return new SymbolSet(symbolRanges, strings, symbolSetType);
                }
                case '-': {
                    if (this.aCharIterator.peek() == ']' || this.aCharIterator.peek(-2) == '[') {
                        sb.append(c);
                        break;
                    }
                    rangeStarted = true;
                    break;
                }
                case '\\': {
                    LinkedList<Node> nodes = new LinkedList<Node>();
                    this.handleEscapedCharacter(sb, nodes, false);
                    if (rangeStarted) {
                        if (!nodes.isEmpty()) {
                            throw new RuntimeException("Cannot make range with a shorthand escape sequences before '" + this.aCharIterator.context() + '\'');
                        }
                        rangeStarted = DefaultTreeBuilder.handleRange(rangeStarted, sb, symbolRanges);
                    }
                    if (nodes.isEmpty()) continue block5;
                    if (nodes.size() > 1) {
                        throw new RuntimeException("Multiple nodes found inside square brackets escape sequence before '" + this.aCharIterator.context() + '\'');
                    }
                    if (nodes.get(0) instanceof SymbolSet) {
                        for (String symbol : ((SymbolSet)nodes.get(0)).getSymbols()) {
                            sb.append(symbol);
                        }
                        continue block5;
                    }
                    throw new RuntimeException("Unexpected node found inside square brackets escape sequence before '" + this.aCharIterator.context() + '\'');
                }
                default: {
                    sb.append(c);
                    rangeStarted = DefaultTreeBuilder.handleRange(rangeStarted, sb, symbolRanges);
                }
            }
        }
        throw new RuntimeException("Unexpected End Of Expression. Didn't find closing ']'");
    }

    public void build() {
        if (this.aCharIterator.peek() == '^') {
            this.aCharIterator.next();
        }
        if (this.aCharIterator.last() == '$') {
            this.aCharIterator.setBound(-1);
        }
        this.aNode = this.parseGroup(GroupType.NON_CAPTURE_GROUP);
        if (this.aCharIterator.hasNext()) {
            throw new RuntimeException("Expression was not fully parsed");
        }
    }

    @Override
    public Node get() {
        if (this.aNode == null) {
            this.build();
        }
        return this.aNode;
    }

    private static enum GroupType {
        POSITIVE_LOOKAHEAD,
        NEGATIVE_LOOKAHEAD,
        POSITIVE_LOOKBEHIND,
        NEGATIVE_LOOKBEHIND,
        CAPTURE_GROUP,
        NON_CAPTURE_GROUP;


        public boolean isNegative() {
            return this == NEGATIVE_LOOKAHEAD || this == NEGATIVE_LOOKBEHIND;
        }
    }
}

