/*
 * Decompiled with CFR 0.152.
 */
package com.github.curiousoddman.rgxgen.generator.visitors;

import com.github.curiousoddman.rgxgen.generator.nodes.Choice;
import com.github.curiousoddman.rgxgen.generator.nodes.FinalSymbol;
import com.github.curiousoddman.rgxgen.generator.nodes.Group;
import com.github.curiousoddman.rgxgen.generator.nodes.GroupRef;
import com.github.curiousoddman.rgxgen.generator.nodes.Node;
import com.github.curiousoddman.rgxgen.generator.nodes.NotSymbol;
import com.github.curiousoddman.rgxgen.generator.nodes.Repeat;
import com.github.curiousoddman.rgxgen.generator.nodes.Sequence;
import com.github.curiousoddman.rgxgen.generator.nodes.SymbolSet;
import com.github.curiousoddman.rgxgen.generator.visitors.NodeVisitor;
import com.github.curiousoddman.rgxgen.util.Util;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;

public class GenerationVisitor
implements NodeVisitor {
    private final StringBuilder aStringBuilder = new StringBuilder();
    private final Map<Integer, String> aGroupValues = new HashMap<Integer, String>();

    @Override
    public void visit(SymbolSet node) {
        String[] allSymbols = node.getSymbols();
        int idx = ThreadLocalRandom.current().nextInt(allSymbols.length);
        this.aStringBuilder.append(allSymbols[idx]);
    }

    @Override
    public void visit(Choice node) {
        Node[] nodes = node.getNodes();
        int idx = ThreadLocalRandom.current().nextInt(nodes.length);
        nodes[idx].visit(this);
    }

    @Override
    public void visit(FinalSymbol node) {
        this.aStringBuilder.append(node.getValue());
    }

    @Override
    public void visit(Repeat node) {
        int max = node.getMax() == -1 ? 100 : node.getMax();
        int repeat = node.getMin() >= max ? node.getMin() : ThreadLocalRandom.current().nextInt(node.getMin(), max + 1);
        for (long i = 0L; i < (long)repeat; ++i) {
            node.getNode().visit(this);
        }
    }

    @Override
    public void visit(Sequence node) {
        for (Node n : node.getNodes()) {
            n.visit(this);
        }
    }

    @Override
    public void visit(NotSymbol notSymbol) {
        String value = notSymbol.getSubPattern().pattern();
        String result = Util.randomString(value);
        while (!notSymbol.getSubPattern().matcher(value).matches()) {
            result = Util.randomString(result);
        }
        this.aStringBuilder.append(result);
    }

    @Override
    public void visit(GroupRef groupRef) {
        this.aStringBuilder.append(this.aGroupValues.get(groupRef.getIndex()));
    }

    @Override
    public void visit(Group group) {
        int start = this.aStringBuilder.length();
        group.getNode().visit(this);
        this.aGroupValues.put(group.getIndex(), this.aStringBuilder.substring(start));
    }

    public String getString() {
        return this.aStringBuilder.toString();
    }
}

