/*
 * Decompiled with CFR 0.152.
 */
package com.github.curiousoddman.rgxgen.generator.visitors;

import com.github.curiousoddman.rgxgen.generator.nodes.AnySymbol;
import com.github.curiousoddman.rgxgen.generator.nodes.Choice;
import com.github.curiousoddman.rgxgen.generator.nodes.FinalSymbol;
import com.github.curiousoddman.rgxgen.generator.nodes.Node;
import com.github.curiousoddman.rgxgen.generator.nodes.Repeat;
import com.github.curiousoddman.rgxgen.generator.nodes.Sequence;
import com.github.curiousoddman.rgxgen.generator.visitors.NodeVisitor;
import com.github.curiousoddman.rgxgen.iterators.ArrayIterator;
import com.github.curiousoddman.rgxgen.iterators.ChoiceIterator;
import com.github.curiousoddman.rgxgen.iterators.IncrementalLengthIterator;
import com.github.curiousoddman.rgxgen.iterators.PermutationsIterator;
import com.github.curiousoddman.rgxgen.iterators.SingleValueIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;

public class UniqueGenerationVisitor
implements NodeVisitor {
    private List<Supplier<Iterator<String>>> aIterators = new ArrayList<Supplier<Iterator<String>>>();

    private static Iterator<String> permutationsOrFlat(List<Supplier<Iterator<String>>> itSupp) {
        if (itSupp.size() == 1) {
            return itSupp.get(0).get();
        }
        return new PermutationsIterator(itSupp);
    }

    @Override
    public void visit(AnySymbol node) {
        this.aIterators.add(() -> new ArrayIterator(AnySymbol.ALL_SYMBOLS));
    }

    @Override
    public void visit(Choice node) {
        ArrayList<List<Supplier<Iterator<String>>>> nodeIterators = new ArrayList<List<Supplier<Iterator<String>>>>(node.getNodes().length);
        for (Node n : node.getNodes()) {
            UniqueGenerationVisitor v = new UniqueGenerationVisitor();
            n.visit(v);
            nodeIterators.add(v.aIterators);
        }
        this.aIterators.add(() -> new ChoiceIterator(nodeIterators));
    }

    @Override
    public void visit(FinalSymbol node) {
        this.aIterators.add(() -> new SingleValueIterator(node.getValue()));
    }

    @Override
    public void visit(Repeat node) {
        UniqueGenerationVisitor v = new UniqueGenerationVisitor();
        node.getNode().visit(v);
        List<Supplier<Iterator<String>>> iterators = v.aIterators;
        this.aIterators.add(() -> new IncrementalLengthIterator(() -> UniqueGenerationVisitor.permutationsOrFlat(v.aIterators), node.getMin(), node.getMax()));
    }

    @Override
    public void visit(Sequence node) {
        for (Node n : node.getNodes()) {
            n.visit(this);
        }
    }

    public Iterator<String> getUniqueStrings() {
        return UniqueGenerationVisitor.permutationsOrFlat(this.aIterators);
    }
}

