/*
 * Decompiled with CFR 0.152.
 */
package com.github.cukedoctor.util;

import com.github.cukedoctor.api.DocWriter;
import com.github.cukedoctor.util.Constants;

public class DocWriterImpl
implements DocWriter<StringBuilder> {
    private static DocWriterImpl instance;
    private StringBuilder doc;

    private DocWriterImpl() {
    }

    public static synchronized DocWriterImpl getInstance(StringBuilder doc) {
        instance = new DocWriterImpl();
        DocWriterImpl.instance.doc = doc;
        return instance;
    }

    @Override
    public DocWriterImpl write(Object value) {
        if (value != null) {
            this.doc.append(value);
        }
        return instance;
    }

    @Override
    public DocWriterImpl write(Object ... value) {
        for (Object s : value) {
            if (s != null && (s.toString() == Constants.newLine() || !s.toString().trim().equals(""))) continue;
            return instance;
        }
        for (Object s : value) {
            this.write(s);
        }
        return instance;
    }

    @Override
    public StringBuilder getCurrentDoc() {
        return this.doc;
    }

    @Override
    public void clear() {
        this.doc = new StringBuilder();
    }
}

