/*
 * Decompiled with CFR 0.152.
 */
package com.github.cukedoctor.api.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.github.cukedoctor.util.Constants;

@JsonFormat(shape=JsonFormat.Shape.OBJECT)
public enum Status {
    passed,
    failed,
    skipped,
    pending,
    undefined,
    missing;


    public static String getStatusColor(Status status) {
        switch (status) {
            case passed: {
                return Constants.Markup.style("green", Constants.Markup.bold(passed.name()));
            }
            case failed: {
                return Constants.Markup.style("red", Constants.Markup.bold(failed.name()));
            }
        }
        return "";
    }

    public static String getStatusIcon(Status status) {
        switch (status) {
            case passed: {
                return "icon:thumbs-up[role=\"green\",title=\"Passed\"]";
            }
            case failed: {
                return "icon:thumbs-down[role=\"red\",title=\"Failed\"]";
            }
            case skipped: {
                return "icon:thumbs-down[role=\"purple\",title=\"Skipped\"]";
            }
            case pending: {
                return "icon:thumbs-down[role=\"orange\",title=\"Pending\"]";
            }
            case undefined: {
                return "icon:thumbs-down[role=\"yellow\",title=\"Undefined\"]";
            }
            case missing: {
                return "icon:thumbs-down[role=\"blue\",title=\"Missing\"]";
            }
        }
        return "";
    }
}

