/*
 * Decompiled with CFR 0.152.
 */
package io.crossbar.autobahn.websocket;

import android.os.Handler;
import android.os.Message;
import android.util.Pair;
import io.crossbar.autobahn.utils.ABLogger;
import io.crossbar.autobahn.utils.IABLogger;
import io.crossbar.autobahn.websocket.exceptions.WebSocketException;
import io.crossbar.autobahn.websocket.messages.BinaryMessage;
import io.crossbar.autobahn.websocket.messages.Close;
import io.crossbar.autobahn.websocket.messages.ConnectionLost;
import io.crossbar.autobahn.websocket.messages.Error;
import io.crossbar.autobahn.websocket.messages.Ping;
import io.crossbar.autobahn.websocket.messages.Pong;
import io.crossbar.autobahn.websocket.messages.ProtocolViolation;
import io.crossbar.autobahn.websocket.messages.RawTextMessage;
import io.crossbar.autobahn.websocket.messages.ServerError;
import io.crossbar.autobahn.websocket.messages.ServerHandshake;
import io.crossbar.autobahn.websocket.messages.TextMessage;
import io.crossbar.autobahn.websocket.types.WebSocketOptions;
import io.crossbar.autobahn.websocket.utils.Utf8Validator;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

class WebSocketReader
extends Thread {
    private static final IABLogger LOGGER = ABLogger.getLogger(WebSocketReader.class.getName());
    private final Handler mMaster;
    private final WebSocketOptions mOptions;
    private BufferedInputStream mBufferedStream;
    private Socket mSocket;
    private int mPosition;
    private byte[] mMessageData;
    private ByteArrayOutputStream mMessagePayload;
    private static final int STATE_CLOSED = 0;
    private static final int STATE_CONNECTING = 1;
    private static final int STATE_CLOSING = 2;
    private static final int STATE_OPEN = 3;
    private boolean mStopped = false;
    private int mState;
    private long mLastReadTime;
    private boolean mInsideMessage = false;
    private int mMessageOpcode;
    private FrameHeader mFrameHeader;
    private Utf8Validator mUtf8Validator = new Utf8Validator();

    public WebSocketReader(Handler master, Socket socket, WebSocketOptions options, String threadName) throws IOException {
        super(threadName);
        this.mMaster = master;
        this.mOptions = options;
        this.mSocket = socket;
        this.mMessageData = new byte[this.mOptions.getMaxFramePayloadSize() + 14];
        this.mBufferedStream = new BufferedInputStream(this.mSocket.getInputStream(), this.mOptions.getMaxFramePayloadSize() + 14);
        this.mMessagePayload = new ByteArrayOutputStream(options.getMaxMessagePayloadSize());
        this.mFrameHeader = null;
        this.mState = 1;
        LOGGER.d("Created");
    }

    double getTimeSinceLastRead() {
        return (double)(System.currentTimeMillis() - this.mLastReadTime) / 1000.0;
    }

    public void quit() {
        this.mState = 0;
        LOGGER.d("Quit");
    }

    protected void notify(Object message) {
        Message msg = this.mMaster.obtainMessage();
        msg.obj = message;
        this.mMaster.sendMessage(msg);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean processData() throws Exception {
        if (this.mFrameHeader == null) {
            long payload_len;
            int header_len;
            int mask_len;
            if (this.mPosition < 2) return false;
            byte b0 = this.mMessageData[0];
            boolean fin = (b0 & 0x80) != 0;
            int rsv = (b0 & 0x70) >> 4;
            int opcode = b0 & 0xF;
            byte b1 = this.mMessageData[1];
            boolean masked = (b1 & 0x80) != 0;
            int payload_len1 = b1 & 0x7F;
            if (rsv != 0) {
                throw new WebSocketException("RSV != 0 and no extension negotiated");
            }
            if (masked) {
                throw new WebSocketException("masked server frame");
            }
            if (opcode > 7) {
                if (!fin) {
                    throw new WebSocketException("fragmented control frame");
                }
                if (payload_len1 > 125) {
                    throw new WebSocketException("control frame with payload length > 125 octets");
                }
                if (opcode != 8 && opcode != 9 && opcode != 10) {
                    throw new WebSocketException("control frame using reserved opcode " + opcode);
                }
                if (opcode == 8 && payload_len1 == 1) {
                    throw new WebSocketException("received close control frame with payload len 1");
                }
            } else {
                if (opcode != 0 && opcode != 1 && opcode != 2) {
                    throw new WebSocketException("data frame using reserved opcode " + opcode);
                }
                if (!this.mInsideMessage && opcode == 0) {
                    throw new WebSocketException("received continuation data frame outside fragmented message");
                }
                if (this.mInsideMessage && opcode != 0) {
                    throw new WebSocketException("received non-continuation data frame while inside fragmented message");
                }
            }
            int n = mask_len = masked ? 4 : 0;
            if (payload_len1 < 126) {
                header_len = 2 + mask_len;
            } else if (payload_len1 == 126) {
                header_len = 4 + mask_len;
            } else {
                if (payload_len1 != 127) throw new Exception("logic error");
                header_len = 10 + mask_len;
            }
            if (this.mPosition < header_len) return false;
            int i = 2;
            if (payload_len1 == 126) {
                payload_len = (0xFF & this.mMessageData[i]) << 8 | 0xFF & this.mMessageData[i + 1];
                if (payload_len < 126L) {
                    throw new WebSocketException("invalid data frame length (not using minimal length encoding)");
                }
                i += 2;
            } else if (payload_len1 == 127) {
                if ((0x80 & this.mMessageData[i]) != 0) {
                    throw new WebSocketException("invalid data frame length (> 2^63)");
                }
                payload_len = (long)(0xFF & this.mMessageData[i]) << 56 | (long)(0xFF & this.mMessageData[i + 1]) << 48 | (long)(0xFF & this.mMessageData[i + 2]) << 40 | (long)(0xFF & this.mMessageData[i + 3]) << 32 | (long)(0xFF & this.mMessageData[i + 4]) << 24 | (long)(0xFF & this.mMessageData[i + 5]) << 16 | (long)(0xFF & this.mMessageData[i + 6]) << 8 | (long)(0xFF & this.mMessageData[i + 7]);
                if (payload_len < 65536L) {
                    throw new WebSocketException("invalid data frame length (not using minimal length encoding)");
                }
                i += 8;
            } else {
                payload_len = payload_len1;
            }
            if (payload_len > (long)this.mOptions.getMaxFramePayloadSize()) {
                throw new WebSocketException("frame payload too large");
            }
            this.mFrameHeader = new FrameHeader();
            this.mFrameHeader.mOpcode = opcode;
            this.mFrameHeader.mFin = fin;
            this.mFrameHeader.mReserved = rsv;
            this.mFrameHeader.mPayloadLen = (int)payload_len;
            this.mFrameHeader.mHeaderLen = header_len;
            this.mFrameHeader.mTotalLen = this.mFrameHeader.mHeaderLen + this.mFrameHeader.mPayloadLen;
            if (masked) {
                this.mFrameHeader.mMask = new byte[4];
                for (int j = 0; j < 4; ++j) {
                    this.mFrameHeader.mMask[i] = (byte)(0xFF & this.mMessageData[i + j]);
                }
                i += 4;
            } else {
                this.mFrameHeader.mMask = null;
            }
            if (this.mFrameHeader.mPayloadLen == 0) return true;
            if (this.mPosition < this.mFrameHeader.mTotalLen) return false;
            return true;
        }
        if (this.mPosition < this.mFrameHeader.mTotalLen) return false;
        byte[] framePayload = null;
        if (this.mFrameHeader.mPayloadLen > 0) {
            framePayload = new byte[this.mFrameHeader.mPayloadLen];
            System.arraycopy(this.mMessageData, this.mFrameHeader.mHeaderLen, framePayload, 0, this.mFrameHeader.mPayloadLen);
        }
        this.mMessageData = Arrays.copyOfRange(this.mMessageData, this.mFrameHeader.mTotalLen, this.mMessageData.length + this.mFrameHeader.mTotalLen);
        this.mPosition -= this.mFrameHeader.mTotalLen;
        if (this.mFrameHeader.mOpcode > 7) {
            if (this.mFrameHeader.mOpcode == 8) {
                int code = 1005;
                String reason = null;
                if (this.mFrameHeader.mPayloadLen >= 2) {
                    code = (framePayload[0] & 0xFF) * 256 + (framePayload[1] & 0xFF);
                    if (code < 1000) throw new WebSocketException("invalid close code " + code);
                    if (code >= 1000 && code <= 2999 && code != 1000 && code != 1001 && code != 1002 && code != 1003 && code != 1007 && code != 1008 && code != 1009 && code != 1010) {
                        if (code != 1011) throw new WebSocketException("invalid close code " + code);
                    }
                    if (code >= 5000) {
                        throw new WebSocketException("invalid close code " + code);
                    }
                    if (this.mFrameHeader.mPayloadLen > 2) {
                        byte[] ra = new byte[this.mFrameHeader.mPayloadLen - 2];
                        System.arraycopy(framePayload, 2, ra, 0, this.mFrameHeader.mPayloadLen - 2);
                        Utf8Validator val = new Utf8Validator();
                        val.validate(ra);
                        if (!val.isValid()) {
                            throw new WebSocketException("invalid close reasons (not UTF-8)");
                        }
                        reason = new String(ra, "UTF-8");
                    }
                }
                this.onClose(code, reason);
                this.mState = 0;
            } else if (this.mFrameHeader.mOpcode == 9) {
                this.onPing(framePayload);
            } else {
                if (this.mFrameHeader.mOpcode != 10) throw new Exception("logic error");
                this.onPong(framePayload);
            }
        } else {
            if (!this.mInsideMessage) {
                this.mInsideMessage = true;
                this.mMessageOpcode = this.mFrameHeader.mOpcode;
                if (this.mMessageOpcode == 1 && this.mOptions.getValidateIncomingUtf8()) {
                    this.mUtf8Validator.reset();
                }
            }
            if (framePayload != null) {
                if (this.mMessagePayload.size() + framePayload.length > this.mOptions.getMaxMessagePayloadSize()) {
                    throw new WebSocketException("message payload too large");
                }
                if (this.mMessageOpcode == 1 && this.mOptions.getValidateIncomingUtf8() && !this.mUtf8Validator.validate(framePayload)) {
                    throw new WebSocketException("invalid UTF-8 in text message payload");
                }
                this.mMessagePayload.write(framePayload);
            }
            if (this.mFrameHeader.mFin) {
                if (this.mMessageOpcode == 1) {
                    if (this.mOptions.getValidateIncomingUtf8() && !this.mUtf8Validator.isValid()) {
                        throw new WebSocketException("UTF-8 text message payload ended within Unicode code point");
                    }
                    if (this.mOptions.getReceiveTextMessagesRaw()) {
                        this.onRawTextMessage(this.mMessagePayload.toByteArray());
                    } else {
                        String s = new String(this.mMessagePayload.toByteArray(), "UTF-8");
                        this.onTextMessage(s);
                    }
                } else {
                    if (this.mMessageOpcode != 2) throw new Exception("logic error");
                    this.onBinaryMessage(this.mMessagePayload.toByteArray());
                }
                this.mInsideMessage = false;
                this.mMessagePayload.reset();
            }
        }
        this.mFrameHeader = null;
        if (this.mPosition <= 0) return false;
        return true;
    }

    protected void onHandshake(Map<String, String> handshakeParams, boolean success) {
        this.notify(new ServerHandshake(handshakeParams, success));
    }

    protected void onClose(int code, String reason) {
        this.notify(new Close(code, reason));
    }

    protected void onPing(byte[] payload) {
        this.notify(new Ping(payload));
    }

    protected void onPong(byte[] payload) {
        this.notify(new Pong(payload));
    }

    protected void onTextMessage(String payload) {
        this.notify(new TextMessage(payload));
    }

    protected void onRawTextMessage(byte[] payload) {
        this.notify(new RawTextMessage(payload));
    }

    protected void onBinaryMessage(byte[] payload) {
        this.notify(new BinaryMessage(payload));
    }

    private boolean processHandshake() throws UnsupportedEncodingException {
        boolean res = false;
        for (int pos = this.mPosition - 4; pos >= 0; --pos) {
            if (this.mMessageData[pos] != 13 || this.mMessageData[pos + 1] != 10 || this.mMessageData[pos + 2] != 13 || this.mMessageData[pos + 3] != 10) continue;
            boolean serverError = false;
            String rawHeaders = new String(Arrays.copyOf(this.mMessageData, pos + 4), "UTF-8");
            String[] headers = rawHeaders.split("\r\n");
            if (headers[0].startsWith("HTTP")) {
                Pair<Integer, String> status = this.parseHttpStatus(headers[0]);
                if ((Integer)status.first >= 300) {
                    this.notify(new ServerError((Integer)status.first, (String)status.second));
                    serverError = true;
                }
            }
            Map<String, String> handshakeParams = this.parseHttpHeaders(Arrays.copyOfRange(headers, 1, headers.length));
            this.mMessageData = Arrays.copyOfRange(this.mMessageData, pos + 4, this.mMessageData.length + pos + 4);
            this.mPosition -= pos + 4;
            if (!serverError) {
                res = this.mPosition > 0;
                this.mState = 3;
            } else {
                res = true;
                this.mState = 0;
                this.mStopped = true;
            }
            this.onHandshake(handshakeParams, !serverError);
            break;
        }
        return res;
    }

    private Map<String, String> parseHttpHeaders(String[] httpResponse) throws UnsupportedEncodingException {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (String line : httpResponse) {
            String[] h;
            if (line.length() <= 0 || (h = line.split(": ")).length != 2) continue;
            headers.put(h[0], h[1]);
            LOGGER.d(String.format("'%s'='%s'", h[0], h[1]));
        }
        return headers;
    }

    private Pair<Integer, String> parseHttpStatus(String statusLine) throws UnsupportedEncodingException {
        String[] statusLineParts = statusLine.split(" ");
        int statusCode = Integer.valueOf(statusLineParts[1]);
        StringBuilder statusMessageBuilder = new StringBuilder();
        for (int i = 2; i < statusLineParts.length; ++i) {
            statusMessageBuilder.append(statusLineParts[i]);
            statusMessageBuilder.append(" ");
        }
        String statusMessage = statusMessageBuilder.toString().trim();
        LOGGER.d(String.format("Status: %d (%s)", statusCode, statusMessage));
        return new Pair((Object)statusCode, (Object)statusMessage);
    }

    private boolean consumeData() throws Exception {
        if (this.mState == 3 || this.mState == 2) {
            return this.processData();
        }
        if (this.mState == 1) {
            return this.processHandshake();
        }
        if (this.mState == 0) {
            return false;
        }
        return false;
    }

    @Override
    public void run() {
        LOGGER.d("Running");
        try {
            do {
                int len = this.mBufferedStream.read(this.mMessageData, this.mPosition, this.mMessageData.length - this.mPosition);
                this.mPosition += len;
                if (len > 0) {
                    this.mLastReadTime = System.currentTimeMillis();
                    while (this.consumeData()) {
                    }
                } else {
                    if (this.mState == 0) {
                        this.mStopped = true;
                        continue;
                    }
                    if (len >= 0) continue;
                    LOGGER.d("run() : ConnectionLost");
                    this.notify(new ConnectionLost(null));
                    this.mStopped = true;
                }
            } while (!this.mStopped);
        }
        catch (WebSocketException e) {
            LOGGER.d("run() : WebSocketException (" + e.toString() + ")");
            this.notify(new ProtocolViolation(e));
        }
        catch (SocketException e) {
            if (this.mState != 0 && !this.mSocket.isClosed()) {
                LOGGER.d("run() : SocketException (" + e.toString() + ")");
                this.notify(new ConnectionLost(null));
            }
        }
        catch (Exception e) {
            LOGGER.d("run() : Exception (" + e.toString() + ")");
            this.notify(new Error(e));
        }
        finally {
            this.mStopped = true;
        }
        LOGGER.d("Ended");
    }

    private static class FrameHeader {
        public int mOpcode;
        public boolean mFin;
        public int mReserved;
        public int mHeaderLen;
        public int mPayloadLen;
        public int mTotalLen;
        public byte[] mMask;

        private FrameHeader() {
        }
    }
}

