/*
 * Decompiled with CFR 0.152.
 */
package io.crossbar.autobahn.websocket;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import io.crossbar.autobahn.utils.ABLogger;
import io.crossbar.autobahn.utils.IABLogger;
import io.crossbar.autobahn.websocket.WebSocketReader;
import io.crossbar.autobahn.websocket.WebSocketWriter;
import io.crossbar.autobahn.websocket.exceptions.WebSocketException;
import io.crossbar.autobahn.websocket.interfaces.IWebSocket;
import io.crossbar.autobahn.websocket.interfaces.IWebSocketConnectionHandler;
import io.crossbar.autobahn.websocket.messages.BinaryMessage;
import io.crossbar.autobahn.websocket.messages.CannotConnect;
import io.crossbar.autobahn.websocket.messages.ClientHandshake;
import io.crossbar.autobahn.websocket.messages.Close;
import io.crossbar.autobahn.websocket.messages.ConnectionLost;
import io.crossbar.autobahn.websocket.messages.Error;
import io.crossbar.autobahn.websocket.messages.Ping;
import io.crossbar.autobahn.websocket.messages.Pong;
import io.crossbar.autobahn.websocket.messages.ProtocolViolation;
import io.crossbar.autobahn.websocket.messages.Quit;
import io.crossbar.autobahn.websocket.messages.RawTextMessage;
import io.crossbar.autobahn.websocket.messages.ServerError;
import io.crossbar.autobahn.websocket.messages.ServerHandshake;
import io.crossbar.autobahn.websocket.messages.TextMessage;
import io.crossbar.autobahn.websocket.types.ConnectionResponse;
import io.crossbar.autobahn.websocket.types.WebSocketOptions;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class WebSocketConnection
implements IWebSocket {
    private static final IABLogger LOGGER = ABLogger.getLogger(WebSocketConnection.class.getName());
    private Handler mMasterHandler;
    private WebSocketReader mReader;
    private WebSocketWriter mWriter;
    private HandlerThread mWriterThread;
    private Socket mSocket;
    private URI mWsUri;
    private String mWsScheme;
    private String mWsHost;
    private int mWsPort;
    private String mWsPath;
    private String mWsQuery;
    private String[] mWsSubprotocols;
    private Map<String, String> mWsHeaders;
    private IWebSocketConnectionHandler mWsHandler;
    private WebSocketOptions mOptions;
    private boolean mActive;
    private boolean mPrevConnected;
    private boolean onCloseCalled;
    private ScheduledExecutorService mExecutor;
    private final long mIdleTimeout = 10L;
    private final Runnable mAutoPinger = new Runnable(){

        @Override
        public void run() {
            if (WebSocketConnection.this.mReader != null && WebSocketConnection.this.mReader.getTimeSinceLastRead() >= 9.0) {
                WebSocketConnection.this.sendPing();
                WebSocketConnection.this.mExecutor.schedule(new Runnable(){

                    @Override
                    public void run() {
                        if (WebSocketConnection.this.mReader.getTimeSinceLastRead() < 10.0) {
                            return;
                        }
                        WebSocketConnection.this.forward(new ConnectionLost("AutoPing timed out."));
                    }
                }, 2L, TimeUnit.SECONDS);
            }
        }
    };

    private void forward(Object message) {
        Message msg = this.mMasterHandler.obtainMessage();
        msg.obj = message;
        this.mMasterHandler.sendMessage(msg);
    }

    public WebSocketConnection() {
        LOGGER.d("Created");
        this.createHandler();
        this.mActive = false;
        this.mPrevConnected = false;
    }

    @Override
    public void sendMessage(String payload) {
        this.mWriter.forward(new TextMessage(payload));
    }

    @Override
    public void sendMessage(byte[] payload, boolean isBinary) {
        if (isBinary) {
            this.mWriter.forward(new BinaryMessage(payload));
        } else {
            this.mWriter.forward(new RawTextMessage(payload));
        }
    }

    @Override
    public void sendPing() {
        this.mWriter.forward(new Ping());
    }

    @Override
    public void sendPing(byte[] payload) {
        this.mWriter.forward(new Ping(payload));
    }

    @Override
    public void sendPong() {
        this.mWriter.forward(new Pong());
    }

    @Override
    public void sendPong(byte[] payload) {
        this.mWriter.forward(new Pong(payload));
    }

    @Override
    public boolean isConnected() {
        return this.mSocket != null && this.mSocket.isConnected() && !this.mSocket.isClosed();
    }

    private void closeReaderThread(boolean waitForQuit) {
        if (this.mReader != null) {
            this.mReader.quit();
            if (waitForQuit) {
                try {
                    this.mReader.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        } else {
            LOGGER.d("mReader already NULL");
        }
    }

    private void closeUnderlyingSocket() throws IOException, InterruptedException {
        Thread cleaner = new Thread(new Runnable(){

            @Override
            public void run() {
                if (WebSocketConnection.this.isConnected()) {
                    try {
                        WebSocketConnection.this.mSocket.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        cleaner.start();
        cleaner.join();
    }

    private void closeWriterThread() {
        if (this.mWriter != null) {
            this.mWriter.forward(new Quit());
            try {
                this.mWriterThread.join();
            }
            catch (InterruptedException e) {
                LOGGER.v(e.getMessage(), e);
            }
        } else {
            LOGGER.d("mWriter already NULL");
        }
    }

    private void failConnection(int code, String reason) {
        LOGGER.d("fail connection [code = " + code + ", reason = " + reason);
        this.closeReaderThread(false);
        this.closeWriterThread();
        if (this.isConnected()) {
            try {
                this.closeUnderlyingSocket();
            }
            catch (IOException | InterruptedException e) {
                LOGGER.v(e.getMessage(), e);
            }
        } else {
            LOGGER.d("Socket already closed");
        }
        this.closeReaderThread(true);
        this.onClose(code, reason);
        LOGGER.d("Worker threads stopped");
    }

    @Override
    public void connect(String wsUri, IWebSocketConnectionHandler wsHandler) throws WebSocketException {
        this.connect(wsUri, null, wsHandler, new WebSocketOptions(), null);
    }

    @Override
    public void connect(String wsUri, IWebSocketConnectionHandler wsHandler, WebSocketOptions options) throws WebSocketException {
        this.connect(wsUri, null, wsHandler, options, null);
    }

    @Override
    public void connect(String wsUri, String[] wsSubprotocols, IWebSocketConnectionHandler wsHandler) throws WebSocketException {
        this.connect(wsUri, wsSubprotocols, wsHandler, new WebSocketOptions(), null);
    }

    @Override
    public void connect(String wsUri, String[] wsSubprotocols, IWebSocketConnectionHandler wsHandler, WebSocketOptions options, Map<String, String> headers) throws WebSocketException {
        if (this.isConnected()) {
            throw new WebSocketException("already connected");
        }
        try {
            this.mWsUri = new URI(wsUri);
            if (!this.mWsUri.getScheme().equals("ws") && !this.mWsUri.getScheme().equals("wss")) {
                throw new WebSocketException("unsupported scheme for WebSockets URI");
            }
            this.mWsScheme = this.mWsUri.getScheme();
            this.mWsPort = this.mWsUri.getPort() == -1 ? (this.mWsScheme.equals("ws") ? 80 : 443) : this.mWsUri.getPort();
            if (this.mWsUri.getHost() == null) {
                throw new WebSocketException("no host specified in WebSockets URI");
            }
            this.mWsHost = this.mWsUri.getHost();
            this.mWsPath = this.mWsUri.getRawPath() == null || this.mWsUri.getRawPath().equals("") ? "/" : this.mWsUri.getRawPath();
            this.mWsQuery = this.mWsUri.getRawQuery() == null || this.mWsUri.getRawQuery().equals("") ? null : this.mWsUri.getRawQuery();
        }
        catch (URISyntaxException e) {
            throw new WebSocketException("invalid WebSockets URI");
        }
        this.mWsSubprotocols = wsSubprotocols;
        this.mWsHeaders = headers;
        this.mWsHandler = wsHandler;
        this.mOptions = new WebSocketOptions(options);
        this.mActive = true;
        this.onCloseCalled = false;
        new WebSocketConnector().start();
    }

    @Override
    public void sendClose() {
        this.sendClose(1000);
    }

    @Override
    public void sendClose(int code) {
        this.sendClose(code, null);
    }

    @Override
    public void sendClose(int code, String reason) {
        if (this.mWriter != null) {
            this.mWriter.forward(new Close(code, reason));
        } else {
            LOGGER.d("could not send Close .. writer already NULL");
        }
        this.onCloseCalled = false;
        this.mActive = false;
        this.mPrevConnected = false;
    }

    public boolean reconnect() {
        if (!this.isConnected() && this.mWsUri != null) {
            this.onCloseCalled = false;
            new WebSocketConnector().start();
            return true;
        }
        return false;
    }

    private boolean scheduleReconnect() {
        boolean need;
        int interval = this.mOptions.getReconnectInterval();
        boolean bl = need = this.mActive && this.mPrevConnected && interval > 0;
        if (need) {
            LOGGER.d("Reconnection scheduled");
            this.mMasterHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    LOGGER.d("Reconnecting...");
                    WebSocketConnection.this.reconnect();
                }
            }, (long)interval);
        }
        return need;
    }

    private void onClose(int code, String reason) {
        block7: {
            boolean reconnecting = false;
            if (code == 2 || code == 3) {
                reconnecting = this.scheduleReconnect();
            }
            if (this.mExecutor != null) {
                this.mExecutor.shutdown();
            }
            if (this.mWsHandler != null) {
                try {
                    if (reconnecting) {
                        this.mWsHandler.onClose(7, reason);
                        break block7;
                    }
                    this.mWsHandler.onClose(code, reason);
                }
                catch (Exception e) {
                    LOGGER.v(e.getMessage(), e);
                }
            } else {
                LOGGER.d("mWsHandler already NULL");
            }
        }
        this.onCloseCalled = true;
    }

    private void closeAndCleanup() {
        this.closeReaderThread(false);
        this.closeWriterThread();
        if (this.isConnected()) {
            try {
                this.closeUnderlyingSocket();
            }
            catch (IOException | InterruptedException e) {
                LOGGER.v(e.getMessage(), e);
            }
        }
        this.closeReaderThread(true);
        this.onCloseCalled = false;
    }

    private <T> T getOrDefault(Map<?, ?> obj, Object key, T default_value) {
        if (obj.containsKey(key)) {
            return (T)obj.get(key);
        }
        return default_value;
    }

    private void createHandler() {
        this.mMasterHandler = new Handler(Looper.getMainLooper()){

            public void handleMessage(Message msg) {
                if (WebSocketConnection.this.onCloseCalled) {
                    LOGGER.d("onClose called already, ignore message.");
                    return;
                }
                if (msg.obj instanceof TextMessage) {
                    TextMessage textMessage = (TextMessage)msg.obj;
                    if (WebSocketConnection.this.mWsHandler != null) {
                        WebSocketConnection.this.mWsHandler.onMessage(textMessage.mPayload);
                    } else {
                        LOGGER.d("could not call onTextMessage() .. handler already NULL");
                    }
                } else if (msg.obj instanceof RawTextMessage) {
                    RawTextMessage rawTextMessage = (RawTextMessage)msg.obj;
                    if (WebSocketConnection.this.mWsHandler != null) {
                        WebSocketConnection.this.mWsHandler.onMessage(rawTextMessage.mPayload, false);
                    } else {
                        LOGGER.d("could not call onRawTextMessage() .. handler already NULL");
                    }
                } else if (msg.obj instanceof BinaryMessage) {
                    BinaryMessage binaryMessage = (BinaryMessage)msg.obj;
                    if (WebSocketConnection.this.mWsHandler != null) {
                        WebSocketConnection.this.mWsHandler.onMessage(binaryMessage.mPayload, true);
                    } else {
                        LOGGER.d("could not call onBinaryMessage() .. handler already NULL");
                    }
                } else if (msg.obj instanceof Ping) {
                    Ping ping = (Ping)msg.obj;
                    LOGGER.d("WebSockets Ping received");
                    if (ping.mPayload == null) {
                        WebSocketConnection.this.mWsHandler.onPing();
                    } else {
                        WebSocketConnection.this.mWsHandler.onPing(ping.mPayload);
                    }
                } else if (msg.obj instanceof Pong) {
                    Pong pong = (Pong)msg.obj;
                    if (pong.mPayload == null) {
                        WebSocketConnection.this.mWsHandler.onPong();
                    } else {
                        WebSocketConnection.this.mWsHandler.onPong(pong.mPayload);
                    }
                    LOGGER.d("WebSockets Pong received");
                } else if (msg.obj instanceof Close) {
                    int crossbarCloseCode;
                    Close close = (Close)msg.obj;
                    int n = crossbarCloseCode = close.mCode == 1000 ? 1 : 3;
                    if (close.mIsReply) {
                        LOGGER.d("WebSockets Close received (" + close.mCode + " - " + close.mReason + ")");
                        WebSocketConnection.this.closeAndCleanup();
                        WebSocketConnection.this.onClose(crossbarCloseCode, close.mReason);
                    } else if (WebSocketConnection.this.mActive) {
                        WebSocketConnection.this.closeReaderThread(false);
                        WebSocketConnection.this.mWriter.forward(new Close(1000, true));
                        WebSocketConnection.this.mActive = false;
                    } else {
                        LOGGER.d("WebSockets Close received (" + close.mCode + " - " + close.mReason + ")");
                        WebSocketConnection.this.closeAndCleanup();
                        WebSocketConnection.this.onClose(crossbarCloseCode, close.mReason);
                    }
                } else if (msg.obj instanceof ServerHandshake) {
                    ServerHandshake serverHandshake = (ServerHandshake)msg.obj;
                    LOGGER.d("opening handshake received");
                    if (serverHandshake.mSuccess) {
                        if (WebSocketConnection.this.mWsHandler != null) {
                            WebSocketConnection.this.mExecutor.scheduleAtFixedRate(WebSocketConnection.this.mAutoPinger, 10L, 10L, TimeUnit.SECONDS);
                            String protocol = (String)WebSocketConnection.this.getOrDefault(serverHandshake.headers, "Sec-WebSocket-Protocol", null);
                            WebSocketConnection.this.mWsHandler.setConnection(WebSocketConnection.this);
                            WebSocketConnection.this.mWsHandler.onConnect(new ConnectionResponse(protocol));
                            WebSocketConnection.this.mWsHandler.onOpen();
                            LOGGER.d("onOpen() called, ready to rock.");
                        } else {
                            LOGGER.d("could not call onOpen() .. handler already NULL");
                        }
                    }
                } else if (msg.obj instanceof CannotConnect) {
                    CannotConnect cannotConnect = (CannotConnect)msg.obj;
                    WebSocketConnection.this.failConnection(2, cannotConnect.reason);
                } else if (msg.obj instanceof ConnectionLost) {
                    ConnectionLost connnectionLost = (ConnectionLost)msg.obj;
                    WebSocketConnection.this.failConnection(3, connnectionLost.reason);
                } else if (msg.obj instanceof ProtocolViolation) {
                    ProtocolViolation protocolViolation = (ProtocolViolation)msg.obj;
                    WebSocketConnection.this.failConnection(4, "WebSockets protocol violation");
                } else if (msg.obj instanceof Error) {
                    Error error = (Error)msg.obj;
                    WebSocketConnection.this.failConnection(5, "WebSockets internal error (" + error.mException.toString() + ")");
                } else if (msg.obj instanceof ServerError) {
                    ServerError error = (ServerError)msg.obj;
                    WebSocketConnection.this.failConnection(6, "Server error " + error.mStatusCode + " (" + error.mStatusMessage + ")");
                } else {
                    WebSocketConnection.this.processAppMessage(msg.obj);
                }
            }
        };
    }

    private void processAppMessage(Object message) {
    }

    private void createWriter() throws IOException {
        this.mWriterThread = new HandlerThread("WebSocketWriter");
        this.mWriterThread.start();
        this.mWriter = new WebSocketWriter(this.mWriterThread.getLooper(), this.mMasterHandler, this.mSocket, this.mOptions);
        LOGGER.d("WS writer created and started");
    }

    private void createReader() throws IOException {
        this.mReader = new WebSocketReader(this.mMasterHandler, this.mSocket, this.mOptions, "WebSocketReader");
        this.mReader.start();
        LOGGER.d("WS reader created and started");
    }

    private class WebSocketConnector
    extends Thread {
        private WebSocketConnector() {
        }

        @Override
        public void run() {
            Thread.currentThread().setName("WebSocketConnector");
            try {
                if (WebSocketConnection.this.mWsScheme.equals("wss")) {
                    WebSocketConnection.this.mSocket = SSLSocketFactory.getDefault().createSocket();
                } else {
                    WebSocketConnection.this.mSocket = SocketFactory.getDefault().createSocket();
                }
                WebSocketConnection.this.mSocket.connect(new InetSocketAddress(WebSocketConnection.this.mWsHost, WebSocketConnection.this.mWsPort), WebSocketConnection.this.mOptions.getSocketConnectTimeout());
                WebSocketConnection.this.mSocket.setSoTimeout(WebSocketConnection.this.mOptions.getSocketReceiveTimeout());
                WebSocketConnection.this.mSocket.setTcpNoDelay(WebSocketConnection.this.mOptions.getTcpNoDelay());
            }
            catch (IOException e) {
                WebSocketConnection.this.forward(new CannotConnect(e.getMessage()));
                return;
            }
            if (WebSocketConnection.this.mExecutor == null || WebSocketConnection.this.mExecutor.isShutdown()) {
                WebSocketConnection.this.mExecutor = Executors.newSingleThreadScheduledExecutor();
            }
            if (WebSocketConnection.this.isConnected()) {
                try {
                    WebSocketConnection.this.createReader();
                    WebSocketConnection.this.createWriter();
                    ClientHandshake hs = new ClientHandshake(WebSocketConnection.this.mWsHost + ":" + WebSocketConnection.this.mWsPort);
                    hs.mPath = WebSocketConnection.this.mWsPath;
                    hs.mQuery = WebSocketConnection.this.mWsQuery;
                    hs.mSubprotocols = WebSocketConnection.this.mWsSubprotocols;
                    hs.mHeaderList = WebSocketConnection.this.mWsHeaders;
                    WebSocketConnection.this.mWriter.forward(hs);
                    WebSocketConnection.this.mPrevConnected = true;
                }
                catch (Exception e) {
                    WebSocketConnection.this.forward(new Error(e));
                }
            } else {
                WebSocketConnection.this.forward(new CannotConnect("Could not connect to WebSocket server"));
            }
        }
    }
}

