/*
 * Decompiled with CFR 0.152.
 */
package master.flame.danmaku.danmaku.model;

import master.flame.danmaku.danmaku.model.BaseDanmaku;
import master.flame.danmaku.danmaku.model.Duration;
import master.flame.danmaku.danmaku.model.IDisplayer;

public class R2LDanmaku
extends BaseDanmaku {
    protected static final long MAX_RENDERING_TIME = 100L;
    protected static final long CORDON_RENDERING_TIME = 40L;
    protected float x = 0.0f;
    protected float y = -1.0f;
    protected int mDistance;
    protected float[] RECT = null;
    protected float mStepX;
    protected long mLastTime;

    public R2LDanmaku(Duration duration) {
        this.duration = duration;
    }

    @Override
    public void layout(IDisplayer displayer, float x, float y) {
        if (this.mTimer != null) {
            long currMS = this.mTimer.currMillisecond;
            long deltaDuration = currMS - this.time;
            if (deltaDuration > 0L && deltaDuration < this.duration.value) {
                this.x = this.getAccurateLeft(displayer, currMS);
                if (!this.isShown()) {
                    this.y = y;
                    this.setVisibility(true);
                }
                this.mLastTime = currMS;
                return;
            }
            this.mLastTime = currMS;
        }
        this.setVisibility(false);
    }

    protected float getAccurateLeft(IDisplayer displayer, long currTime) {
        long elapsedTime = currTime - this.time;
        if (elapsedTime >= this.duration.value) {
            return -this.paintWidth;
        }
        return (float)displayer.getWidth() - (float)elapsedTime * this.mStepX;
    }

    @Override
    public float[] getRectAtTime(IDisplayer displayer, long time) {
        if (!this.isMeasured()) {
            return null;
        }
        float left = this.getAccurateLeft(displayer, time);
        if (this.RECT == null) {
            this.RECT = new float[4];
        }
        this.RECT[0] = left;
        this.RECT[1] = this.y;
        this.RECT[2] = left + this.paintWidth;
        this.RECT[3] = this.y + this.paintHeight;
        return this.RECT;
    }

    @Override
    public float getLeft() {
        return this.x;
    }

    @Override
    public float getTop() {
        return this.y;
    }

    @Override
    public float getRight() {
        return this.x + this.paintWidth;
    }

    @Override
    public float getBottom() {
        return this.y + this.paintHeight;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public void measure(IDisplayer displayer, boolean fromWorkerThread) {
        super.measure(displayer, fromWorkerThread);
        this.mDistance = (int)((float)displayer.getWidth() + this.paintWidth);
        this.mStepX = (float)this.mDistance / (float)this.duration.value;
    }
}

