/*
 * Decompiled with CFR 0.152.
 */
package com.github.cthawanapong.view;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.support.v4.widget.TextViewCompat;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.TextView;
import com.github.cthawanapong.adapter.StyleableTextWatcherAdapter;
import com.github.cthawanapong.styleableviews.R;
import com.github.cthawanapong.view.StyleableEditText;

public class StyleableClearableEditText
extends StyleableEditText
implements View.OnFocusChangeListener,
View.OnTouchListener,
StyleableTextWatcherAdapter.StyleableTextWatcherListener {
    private static final String a = StyleableClearableEditText.class.getSimpleName();
    private Location b = Location.RIGHT;
    private Drawable c;
    private Listener d;
    private View.OnTouchListener e;
    private View.OnFocusChangeListener f;

    public StyleableClearableEditText(Context context) {
        super(context);
        this.a();
    }

    public StyleableClearableEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.a();
    }

    public StyleableClearableEditText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.a();
    }

    public void setListener(Listener listener) {
        this.d = listener;
    }

    public void setIconLocation(Location loc) {
        this.b = loc;
        this.b();
    }

    public void setOnTouchListener(View.OnTouchListener l) {
        this.e = l;
    }

    public void setOnFocusChangeListener(View.OnFocusChangeListener f) {
        this.f = f;
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (this.getDisplayedDrawable() != null) {
            boolean bl;
            int n = (int)event.getX();
            int n2 = (int)event.getY();
            int n3 = this.b == Location.LEFT ? 0 : this.getWidth() - this.getPaddingRight() - this.c.getIntrinsicWidth();
            int n4 = this.b == Location.LEFT ? this.getPaddingLeft() + this.c.getIntrinsicWidth() : this.getWidth();
            boolean bl2 = bl = n >= n3 && n <= n4 && n2 >= 0 && n2 <= this.getBottom() - this.getTop();
            if (bl) {
                if (event.getAction() == 1) {
                    this.setText("");
                    if (this.d != null) {
                        this.d.didClearText();
                    }
                }
                return true;
            }
        }
        if (this.e != null) {
            return this.e.onTouch(v, event);
        }
        return false;
    }

    public void onFocusChange(View v, boolean hasFocus) {
        if (hasFocus) {
            this.setClearIconVisible(!TextUtils.isEmpty((CharSequence)this.getText().toString()));
        } else {
            this.setClearIconVisible(false);
        }
        if (this.f != null) {
            this.f.onFocusChange(v, hasFocus);
        }
    }

    @Override
    public void onTextChanged(StyleableEditText view, String text) {
        if (this.isFocused()) {
            this.setClearIconVisible(!TextUtils.isEmpty((CharSequence)text));
        }
    }

    public void setCompoundDrawables(Drawable left, Drawable top, Drawable right, Drawable bottom) {
        super.setCompoundDrawables(left, top, right, bottom);
        this.b();
    }

    private void a() {
        super.setOnTouchListener((View.OnTouchListener)this);
        super.setOnFocusChangeListener((View.OnFocusChangeListener)this);
        this.addTextChangedListener(new StyleableTextWatcherAdapter(this, this));
        this.b();
        this.setClearIconVisible(false);
    }

    private void b() {
        this.c = null;
        if (this.b != null) {
            this.c = this.getCompoundDrawables()[this.b.a];
        }
        if (this.c == null) {
            this.c = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.ic_cancel_text_input);
        }
        this.c.setBounds(0, 0, this.c.getIntrinsicWidth(), this.c.getIntrinsicHeight());
        int n = this.getPaddingTop() + this.c.getIntrinsicHeight() + this.getPaddingBottom();
        if (this.getSuggestedMinimumHeight() < n) {
            this.setMinimumHeight(n);
        }
    }

    private Drawable getDisplayedDrawable() {
        return this.b != null ? this.getCompoundDrawables()[this.b.a] : null;
    }

    protected void setClearIconVisible(boolean visible) {
        boolean bl;
        Drawable[] drawableArray = this.getCompoundDrawables();
        Drawable drawable2 = this.getDisplayedDrawable();
        boolean bl2 = bl = drawable2 != null;
        if (visible != bl) {
            Drawable drawable3 = visible ? this.c : null;
            TextViewCompat.setCompoundDrawablesRelativeWithIntrinsicBounds((TextView)this, (Drawable)(this.b == Location.LEFT ? drawable3 : drawableArray[0]), (Drawable)drawableArray[1], (Drawable)(this.b == Location.RIGHT ? drawable3 : drawableArray[2]), (Drawable)drawableArray[3]);
        }
    }

    public static interface Listener {
        public void didClearText();
    }

    public static enum Location {
        LEFT(0),
        RIGHT(2);

        final int a;

        private Location(int idx) {
            this.a = idx;
        }
    }
}

