/*
 * Decompiled with CFR 0.152.
 */
package com.github.cthawanapong.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.github.cthawanapong.model.BundleSavedState;
import com.github.cthawanapong.styleableviews.R;
import com.github.cthawanapong.view.StyleableTextView;

public class StyleableButton
extends FrameLayout
implements View.OnClickListener {
    private static final String TAG = StyleableButton.class.getSimpleName();
    private static final String ARG_CHILD_STATES = "childrenStates";
    private static final String ARG_BUTTON_TEXT = "ARG_BUTTON_TEXT";
    private static final String ARG_BUTTON_PADDING = "ARG_BUTTON_PADDING";
    private static final String ARG_TEXT_SIZE = "ARG_TEXT_SIZE";
    private static final String ARG_BUTTON_BACKGROUND = "ARG_BUTTON_BACKGROUND";
    private static final String ARG_TEXT_COLOR = "ARG_TEXT_COLOR";
    private static final String ARG_DRAWABLE_PADDING = "ARG_DRAWABLE_PADDING";
    private static final String ARG_HORIZONTAL_PADDING = "ARG_HORIZONTAL_PADDING";
    private ViewGroup mLayoutButton;
    private ViewGroup mLayoutText;
    private ViewGroup mLayoutWrapper;
    private StyleableTextView mTextView;
    private String mButtonText;
    private int mPadding;
    private float mTextSize;
    private int mBackgroundColor;
    private int mTextColor;
    private Drawable mLeftIcon;
    private int mButtonDrawablePadding;
    private int mButtonHorizontalPadding;
    private OnClickListener mListener;

    public StyleableButton(Context context) {
        super(context);
        this.initInflate();
        this.initInstance(context, null);
    }

    public StyleableButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initInflate();
        this.initInstance(context, attrs);
    }

    public StyleableButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initInflate();
        this.initInstance(context, attrs);
    }

    @TargetApi(value=21)
    public StyleableButton(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initInflate();
        this.initInstance(context, attrs);
    }

    private void initInflate() {
        StyleableButton.inflate((Context)this.getContext(), (int)R.layout.view_button, (ViewGroup)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initInstance(Context context, AttributeSet attrs) {
        this.mLayoutButton = (ViewGroup)this.findViewById(R.id.layout_button);
        this.mLayoutText = (ViewGroup)this.findViewById(R.id.layout_text);
        this.mLayoutWrapper = (ViewGroup)this.findViewById(R.id.layout_wrapper);
        this.mTextView = (StyleableTextView)this.findViewById(R.id.txt_view);
        this.mButtonText = "";
        if (attrs != null) {
            TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.StyleableButton, 0, 0);
            try {
                this.mButtonText = ta.getString(R.styleable.StyleableButton_buttonText);
                this.mPadding = ta.getDimensionPixelSize(R.styleable.StyleableButton_buttonPadding, 0);
                this.mTextSize = ta.getDimension(R.styleable.StyleableButton_buttonTextSize, this.getContext().getResources().getDimension(R.dimen.default_button_text_size));
                this.mBackgroundColor = ta.getColor(R.styleable.StyleableButton_buttonBackgroundColor, -1);
                this.mTextColor = ta.getColor(R.styleable.StyleableButton_buttonTextColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.default_text_color));
                this.mLeftIcon = ta.getDrawable(R.styleable.StyleableButton_buttonLeftDrawable);
                this.mButtonDrawablePadding = ta.getDimensionPixelSize(R.styleable.StyleableButton_buttonDrawablePadding, 0);
                this.mButtonHorizontalPadding = ta.getDimensionPixelSize(R.styleable.StyleableButton_buttonHorizontalPadding, 0);
            }
            finally {
                ta.recycle();
            }
        }
        this.mLayoutButton.setPadding(this.mPadding, this.mPadding, this.mPadding, this.mPadding);
        this.mLayoutText.setBackgroundColor(this.mBackgroundColor);
        this.mTextView.setTextColor(this.mTextColor);
        this.mTextView.setTextSize(0, this.mTextSize);
        this.mTextView.setCompoundDrawablesWithIntrinsicBounds(this.mLeftIcon, null, null, null);
        this.mTextView.setCompoundDrawablePadding(this.mButtonDrawablePadding);
        this.mLayoutWrapper.setPadding(this.mButtonHorizontalPadding, 0, this.mButtonHorizontalPadding, 0);
        this.mLayoutWrapper.setOnClickListener((View.OnClickListener)this);
        this.setDisplayButtonText();
    }

    private void setDisplayButtonText() {
        this.mTextView.setText(this.mButtonText);
    }

    protected void dispatchSaveInstanceState(SparseArray<Parcelable> container) {
        this.dispatchFreezeSelfOnly(container);
    }

    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> container) {
        this.dispatchThawSelfOnly(container);
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        Bundle childrenStates = new Bundle();
        for (int i = 0; i < this.getChildCount(); ++i) {
            int id2 = this.getChildAt(i).getId();
            if (id2 == 0) continue;
            SparseArray childrenState = new SparseArray();
            this.getChildAt(i).saveHierarchyState(childrenState);
            childrenStates.putSparseParcelableArray(String.valueOf(id2), childrenState);
        }
        Bundle bundle = new Bundle();
        bundle.putBundle(ARG_CHILD_STATES, childrenStates);
        bundle.putString(ARG_BUTTON_TEXT, this.mButtonText);
        bundle.putInt(ARG_BUTTON_PADDING, this.mPadding);
        bundle.putFloat(ARG_TEXT_SIZE, this.mTextSize);
        bundle.putInt(ARG_BUTTON_BACKGROUND, this.mBackgroundColor);
        bundle.putInt(ARG_TEXT_COLOR, this.mTextColor);
        bundle.putInt(ARG_DRAWABLE_PADDING, this.mButtonDrawablePadding);
        bundle.putInt(ARG_HORIZONTAL_PADDING, this.mButtonHorizontalPadding);
        BundleSavedState ss = new BundleSavedState(superState);
        ss.setBundle(bundle);
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        BundleSavedState ss = (BundleSavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        Bundle bundle = ss.getBundle();
        Bundle childStates = bundle.getBundle(ARG_CHILD_STATES);
        for (int i = 0; i < this.getChildCount(); ++i) {
            int id2 = this.getChildAt(i).getId();
            if (id2 == 0 || !childStates.containsKey(String.valueOf(id2))) continue;
            SparseArray childrenState = childStates.getSparseParcelableArray(String.valueOf(id2));
            this.getChildAt(i).restoreHierarchyState(childrenState);
        }
        this.mButtonText = bundle.getString(ARG_BUTTON_TEXT);
        this.mPadding = bundle.getInt(ARG_BUTTON_PADDING);
        this.mTextSize = bundle.getFloat(ARG_TEXT_SIZE);
        this.mBackgroundColor = bundle.getInt(ARG_BUTTON_BACKGROUND);
        this.mTextColor = bundle.getInt(ARG_TEXT_COLOR);
        this.mButtonDrawablePadding = bundle.getInt(ARG_DRAWABLE_PADDING);
        this.mButtonHorizontalPadding = bundle.getInt(ARG_HORIZONTAL_PADDING);
    }

    public void setListener(OnClickListener mListener) {
        this.mListener = mListener;
    }

    public void setButtonText(String mButtonText) {
        this.mButtonText = mButtonText;
        this.setDisplayButtonText();
    }

    public void onClick(View v) {
        if (this.mListener != null && v instanceof ViewGroup) {
            this.mListener.onClick((ViewGroup)v);
        }
    }

    public static interface OnClickListener {
        public void onClick(ViewGroup var1);
    }
}

