/*
 * Decompiled with CFR 0.152.
 */
package manager;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.text.TextUtils;
import android.util.Log;
import java.util.HashMap;
import java.util.Map;

public class TypeFaceManager {
    private static final String TAG = TypeFaceManager.class.getSimpleName();
    private static TypeFaceManager instance;
    private Context mContext;
    private AssetManager mAssetManager;
    private Map<String, Typeface> mFontList;

    private TypeFaceManager() {
    }

    public static TypeFaceManager getInstance() {
        if (instance == null) {
            instance = new TypeFaceManager();
        }
        return instance;
    }

    public void init(Context applicationContext) {
        this.mContext = applicationContext;
        this.mAssetManager = this.mContext.getAssets();
        this.mFontList = new HashMap<String, Typeface>();
    }

    public Typeface getFont(String asset) {
        if (this.mFontList.containsKey(asset)) {
            return this.mFontList.get(asset);
        }
        Typeface font = null;
        try {
            font = Typeface.createFromAsset((AssetManager)this.mAssetManager, (String)asset);
            this.mFontList.put(asset, font);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"getFont: ", (Throwable)e);
        }
        if (font == null) {
            try {
                String fixedAsset = this.fixAssetFilename(asset);
                font = Typeface.createFromAsset((AssetManager)this.mAssetManager, (String)fixedAsset);
                this.mFontList.put(asset, font);
                this.mFontList.put(fixedAsset, font);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"getFont: ", (Throwable)e);
            }
        }
        return font;
    }

    private String fixAssetFilename(String asset) {
        if (TextUtils.isEmpty((CharSequence)asset)) {
            return asset;
        }
        if (!asset.endsWith(".ttf") && !asset.endsWith(".ttc")) {
            asset = String.format("%s.ttf", asset);
        }
        return asset;
    }
}

