/*
 * Decompiled with CFR 0.152.
 */
package apijson.router;

import apijson.JSON;
import apijson.Log;
import apijson.RequestMethod;
import apijson.StringUtil;
import apijson.framework.APIJSONConstant;
import apijson.framework.APIJSONController;
import apijson.framework.APIJSONCreator;
import apijson.framework.APIJSONParser;
import apijson.orm.AbstractVerifier;
import apijson.orm.Parser;
import apijson.orm.SQLConfig;
import apijson.orm.SQLCreator;
import apijson.orm.Verifier;
import apijson.router.APIJSONRouterVerifier;
import com.alibaba.fastjson.JSONObject;
import jakarta.servlet.http.HttpSession;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class APIJSONRouterController<T>
extends APIJSONController<T> {
    public static final String TAG = "APIJSONRouterController";

    public String router(String method, String tag, Map<String, String> params, String request, HttpSession session) {
        return this.router(method, tag, params, request, session, Log.DEBUG);
    }

    public String router(String method, String tag, Map<String, String> params, String request, HttpSession session, boolean compatCommonAPI) {
        Integer version;
        String t;
        if (!APIJSONConstant.METHODS.contains(method)) {
            return APIJSONParser.newErrorResult((Exception)new IllegalArgumentException("URL \u8def\u5f84 /{method}/{tag} \u4e2d method \u503c " + method + " \u9519\u8bef\uff01\u53ea\u5141\u8bb8 " + APIJSONConstant.METHODS + " \u4e2d\u7684\u4e00\u4e2a\uff01")).toJSONString();
        }
        String string = t = compatCommonAPI && tag != null && tag.endsWith("[]") ? tag.substring(0, tag.length() - 2) : tag;
        if (!StringUtil.isName((String)t)) {
            return APIJSONParser.newErrorResult((Exception)new IllegalArgumentException("URL \u8def\u5f84 /" + method + "/{tag} \u7684 tag \u4e2d " + t + " \u9519\u8bef\uff01tag \u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e14\u53ea\u5141\u8bb8\u53d8\u91cf\u547d\u540d\u683c\u5f0f\uff01")).toJSONString();
        }
        String versionStr = params == null ? null : params.remove("version");
        try {
            version = StringUtil.isEmpty((String)versionStr, (boolean)false) ? null : Integer.valueOf(versionStr);
        }
        catch (Exception e) {
            return APIJSONParser.newErrorResult((Exception)new IllegalArgumentException("URL \u8def\u5f84 /" + method + "/" + tag + "?version=value \u4e2d value \u503c " + versionStr + " \u9519\u8bef\uff01\u5fc5\u987b\u7b26\u5408\u6574\u6570\u683c\u5f0f\uff01")).toJSONString();
        }
        if (version == null) {
            version = 0;
        }
        try {
            Set rawSet;
            JSONObject apijsonReq;
            RequestMethod requestMethod;
            Parser parser;
            String apijson;
            JSONObject result;
            String cacheKey = AbstractVerifier.getCacheKeyForRequest((String)method, (String)tag);
            SortedMap<Integer, JSONObject> versionedMap = APIJSONRouterVerifier.DOCUMENT_MAP.get(cacheKey);
            JSONObject jSONObject = result = versionedMap == null ? null : (JSONObject)versionedMap.get(version);
            if (result == null) {
                Set<Map.Entry<Integer, JSONObject>> set;
                Set<Map.Entry<Integer, JSONObject>> set2 = set = versionedMap == null ? null : versionedMap.entrySet();
                if (set != null && !set.isEmpty()) {
                    Map.Entry<Integer, JSONObject> maxEntry = null;
                    for (Map.Entry<Integer, JSONObject> entry : set) {
                        if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
                        if (version == null || version <= 0 || version == entry.getKey()) {
                            maxEntry = entry;
                            break;
                        }
                        if (entry.getKey() < version) break;
                        maxEntry = entry;
                    }
                    JSONObject jSONObject2 = result = maxEntry == null ? null : (JSONObject)maxEntry.getValue();
                }
                if (result != null) {
                    if (versionedMap == null) {
                        versionedMap = new TreeMap<Integer, JSONObject>((o1, o2) -> o2 == null ? -1 : o2.compareTo((Integer)o1));
                    }
                    versionedMap.put(version, result);
                    APIJSONRouterVerifier.DOCUMENT_MAP.put(cacheKey, versionedMap);
                }
            }
            APIJSONCreator creator = APIJSONParser.APIJSON_CREATOR;
            if (result == null && Log.DEBUG && APIJSONRouterVerifier.DOCUMENT_MAP.isEmpty()) {
                SQLConfig config = creator.createSQLConfig().setMethod(RequestMethod.GET).setTable(APIJSONConstant.DOCUMENT_);
                config.setPrepared(false);
                config.setColumn(Arrays.asList("request,apijson"));
                HashMap<String, Object> where = new HashMap<String, Object>();
                where.put("url", "/" + method + "/" + tag);
                where.put("apijson{}", "length(apijson)>0");
                if (version > 0) {
                    where.put("version>=", version);
                }
                config.setWhere(where);
                config.setOrder("version" + (version > 0 ? "+" : "-"));
                config.setCount(1);
                result = creator.createSQLExecutor().execute(config, false);
            }
            String string2 = apijson = result == null ? null : result.getString("apijson");
            if (StringUtil.isEmpty((String)apijson, (boolean)true)) {
                if (compatCommonAPI) {
                    return this.crudByTag(method, tag, params, request, session);
                }
                throw new IllegalArgumentException("URL \u8def\u5f84 /" + method + "/" + tag + (String)(versionStr == null ? "" : "?version=" + versionStr) + " \u5bf9\u5e94\u7684\u63a5\u53e3\u4e0d\u5b58\u5728\uff01");
            }
            JSONObject rawReq = JSON.parseObject((String)request);
            if (rawReq == null) {
                rawReq = new JSONObject(true);
            }
            if (params != null && !params.isEmpty()) {
                rawReq.putAll(params);
            }
            if ((parser = this.newParser(session, requestMethod = RequestMethod.valueOf((String)method.toUpperCase()))).isNeedVerifyContent()) {
                Verifier verifier = creator.createVerifier();
                JSONObject object = parser.getStructure("Request", method.toUpperCase(), tag, version.intValue());
                if (object == null) {
                    throw new UnsupportedOperationException("\u627e\u4e0d\u5230 version: " + version + ", method: " + method.toUpperCase() + ", tag: " + tag + " \u5bf9\u5e94\u7684 structure \uff01\u975e\u5f00\u653e\u8bf7\u6c42\u5fc5\u987b\u662f\u540e\u7aef Request \u8868\u4e2d\u6821\u9a8c\u89c4\u5219\u5141\u8bb8\u7684\u64cd\u4f5c\uff01\u5982\u679c\u9700\u8981\u5219\u5728 Request \u8868\u4e2d\u65b0\u589e\u914d\u7f6e\uff01");
                }
                JSONObject target = object;
                verifier.verifyRequest(requestMethod, "", target, rawReq, 0, null, null, (SQLCreator)creator);
            }
            if ((apijsonReq = JSON.parseObject((String)apijson)) == null) {
                apijsonReq = new JSONObject(true);
            }
            if ((rawSet = rawReq.entrySet()) != null && !rawSet.isEmpty()) {
                for (Map.Entry entry : rawSet) {
                    String key;
                    String string3 = key = entry == null ? null : (String)entry.getKey();
                    if (key == null) continue;
                    String[] pathKeys = key.split("\\.");
                    int last = pathKeys.length - 1;
                    JSONObject parent = apijsonReq;
                    for (int i = 0; i < last; ++i) {
                        JSONObject p = parent.getJSONObject(pathKeys[i]);
                        if (p == null) {
                            p = new JSONObject(true);
                            parent.put(key, (Object)p);
                        }
                        parent = p;
                    }
                    parent.put(pathKeys[last], entry.getValue());
                }
            }
            return parser.setNeedVerifyContent(false).parse(apijsonReq);
        }
        catch (Exception e) {
            return APIJSONParser.newErrorResult((Exception)e).toJSONString();
        }
    }
}

