/* Copyright (c) 2008, Nathan Sweet
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following
 * conditions are met:
 * 
 * - Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following
 * disclaimer in the documentation and/or other materials provided with the distribution.
 * - Neither the name of Esoteric Software nor the names of its contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. */

package com.esotericsoftware.kryonet.serialization;

import java.nio.ByteBuffer;

import com.esotericsoftware.kryonet.Connection;

/**
 * Controls how objects are transmitted over the network.
 * <p>
 * The server as well as each client holds <i>one</i> serialization instance.
 * Therefore all implementing classes have to be synchronized or made
 * thread-safe otherwise.
 */
public interface Serialization {

	/**
	 * @param connection
	 *            May be <code>null</code>.
	 * @param buffer
	 * @param object
	 */
	public void write(Connection connection, ByteBuffer buffer, Object object);

	/**
	 * @param connection
	 *            May be <code>null</code>.
	 * @param buffer
	 * @return
	 */
	public Object read(Connection connection, ByteBuffer buffer);

	/**
	 * The length of the header indicating the length of the following data,
	 * i.e. the fixed number of bytes that will be written by
	 * {@link #writeLength(ByteBuffer, int)} and read by
	 * {@link #readLength(ByteBuffer)}.
	 */
	public int getLengthLength();

	public void writeLength(ByteBuffer buffer, int length);

	public int readLength(ByteBuffer buffer);
}
