/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryonet.serialization;

import com.esotericsoftware.jsonbeans.Json;
import com.esotericsoftware.jsonbeans.JsonException;
import com.esotericsoftware.kryo.io.ByteBufferInputStream;
import com.esotericsoftware.kryo.io.ByteBufferOutputStream;
import com.esotericsoftware.kryonet.Connection;
import com.esotericsoftware.kryonet.FrameworkMessage;
import com.esotericsoftware.kryonet.serialization.Serialization;
import com.esotericsoftware.minlog.Log;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.ByteBuffer;

public class JsonSerialization
implements Serialization {
    private final Json json = new Json();
    private final ByteBufferInputStream byteBufferInputStream = new ByteBufferInputStream();
    private final ByteBufferOutputStream byteBufferOutputStream = new ByteBufferOutputStream();
    private final OutputStreamWriter writer = new OutputStreamWriter((OutputStream)this.byteBufferOutputStream);
    private boolean logging = true;
    private boolean prettyPrint = true;
    private byte[] logBuffer = new byte[0];

    public JsonSerialization() {
        this.json.addClassTag("RegisterTCP", FrameworkMessage.RegisterTCP.class);
        this.json.addClassTag("RegisterUDP", FrameworkMessage.RegisterUDP.class);
        this.json.addClassTag("KeepAlive", FrameworkMessage.KeepAlive.class);
        this.json.addClassTag("DiscoverHost", FrameworkMessage.DiscoverHost.class);
        this.json.addClassTag("Ping", FrameworkMessage.Ping.class);
        this.json.setWriter((Writer)this.writer);
    }

    public void setLogging(boolean logging, boolean prettyPrint) {
        this.logging = logging;
        this.prettyPrint = prettyPrint;
    }

    @Override
    public synchronized void write(Connection connection, ByteBuffer buffer, Object object) {
        this.byteBufferOutputStream.setByteBuffer(buffer);
        int start = buffer.position();
        try {
            this.json.writeValue(object, Object.class, null);
            this.writer.flush();
        }
        catch (Exception ex) {
            throw new JsonException("Error writing object: " + object, (Throwable)ex);
        }
        if (Log.INFO && this.logging) {
            int end = buffer.position();
            buffer.position(start);
            buffer.limit(end);
            int length = end - start;
            if (this.logBuffer.length < length) {
                this.logBuffer = new byte[length];
            }
            buffer.get(this.logBuffer, 0, length);
            buffer.position(end);
            buffer.limit(buffer.capacity());
            String message = new String(this.logBuffer, 0, length);
            if (this.prettyPrint) {
                message = this.json.prettyPrint(message);
            }
            Log.info((String)("Wrote: " + message));
        }
    }

    @Override
    public synchronized Object read(Connection connection, ByteBuffer buffer) {
        this.byteBufferInputStream.setByteBuffer(buffer);
        return this.json.fromJson(Object.class, (InputStream)this.byteBufferInputStream);
    }

    @Override
    public void writeLength(ByteBuffer buffer, int length) {
        buffer.putInt(length);
    }

    @Override
    public int readLength(ByteBuffer buffer) {
        return buffer.getInt();
    }

    @Override
    public int getLengthLength() {
        return 4;
    }
}

