/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryonet;

import com.esotericsoftware.kryonet.Connection;
import com.esotericsoftware.kryonet.KryoNetException;
import com.esotericsoftware.kryonet.serialization.Serialization;
import com.esotericsoftware.minlog.Log;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;

class TcpConnection {
    private static final int IPTOS_LOWDELAY = 16;
    SocketChannel socketChannel;
    int keepAliveMillis = 8000;
    final ByteBuffer readBuffer;
    final ByteBuffer writeBuffer;
    boolean bufferPositionFix;
    int timeoutMillis = 12000;
    float idleThreshold = 0.1f;
    final Serialization serialization;
    private SelectionKey selectionKey;
    private volatile long lastWriteTime;
    private volatile long lastReadTime;
    private int currentObjectLength;
    private final Object writeLock = new Object();

    public TcpConnection(Serialization serialization, int writeBufferSize, int objectBufferSize) {
        this.serialization = serialization;
        this.writeBuffer = ByteBuffer.allocate(writeBufferSize);
        this.readBuffer = ByteBuffer.allocate(objectBufferSize);
        this.readBuffer.flip();
    }

    public SelectionKey accept(Selector selector, SocketChannel socketChannel) throws IOException {
        this.writeBuffer.clear();
        this.readBuffer.clear();
        this.readBuffer.flip();
        this.currentObjectLength = 0;
        try {
            this.socketChannel = socketChannel;
            socketChannel.configureBlocking(false);
            Socket socket = socketChannel.socket();
            socket.setTcpNoDelay(true);
            this.selectionKey = socketChannel.register(selector, 1);
            if (Log.DEBUG) {
                Log.debug((String)"kryonet", (String)("Port " + socketChannel.socket().getLocalPort() + "/TCP connected to: " + socketChannel.socket().getRemoteSocketAddress()));
            }
            this.lastReadTime = this.lastWriteTime = System.currentTimeMillis();
            return this.selectionKey;
        }
        catch (IOException ex) {
            this.close();
            throw ex;
        }
    }

    public void connect(Selector selector, SocketAddress remoteAddress, int timeout) throws IOException {
        this.close();
        this.writeBuffer.clear();
        this.readBuffer.clear();
        this.readBuffer.flip();
        this.currentObjectLength = 0;
        try {
            SocketChannel socketChannel = selector.provider().openSocketChannel();
            Socket socket = socketChannel.socket();
            socket.setTcpNoDelay(true);
            socket.connect(remoteAddress, timeout);
            socketChannel.configureBlocking(false);
            this.socketChannel = socketChannel;
            this.selectionKey = socketChannel.register(selector, 1);
            this.selectionKey.attach(this);
            if (Log.DEBUG) {
                Log.debug((String)"kryonet", (String)("Port " + socketChannel.socket().getLocalPort() + "/TCP connected to: " + socketChannel.socket().getRemoteSocketAddress()));
            }
            this.lastReadTime = this.lastWriteTime = System.currentTimeMillis();
        }
        catch (IOException ex) {
            this.close();
            IOException ioEx = new IOException("Unable to connect to: " + remoteAddress);
            ioEx.initCause(ex);
            throw ioEx;
        }
    }

    public Object readObject(Connection connection) throws IOException {
        Object object;
        int bytesRead;
        SocketChannel socketChannel = this.socketChannel;
        if (socketChannel == null) {
            throw new SocketException("Connection is closed.");
        }
        if (this.currentObjectLength == 0) {
            int lengthLength = this.serialization.getLengthLength();
            if (this.readBuffer.remaining() < lengthLength) {
                this.readBuffer.compact();
                bytesRead = socketChannel.read(this.readBuffer);
                this.readBuffer.flip();
                if (bytesRead == -1) {
                    throw new SocketException("Connection is closed.");
                }
                this.lastReadTime = System.currentTimeMillis();
                if (this.readBuffer.remaining() < lengthLength) {
                    return null;
                }
            }
            this.currentObjectLength = this.serialization.readLength(this.readBuffer);
            if (this.currentObjectLength <= 0) {
                throw new KryoNetException("Invalid object length: " + this.currentObjectLength);
            }
            if (this.currentObjectLength > this.readBuffer.capacity()) {
                throw new KryoNetException("Unable to read object larger than read buffer: " + this.currentObjectLength);
            }
        }
        int length = this.currentObjectLength;
        if (this.readBuffer.remaining() < length) {
            this.readBuffer.compact();
            bytesRead = socketChannel.read(this.readBuffer);
            this.readBuffer.flip();
            if (bytesRead == -1) {
                throw new SocketException("Connection is closed.");
            }
            this.lastReadTime = System.currentTimeMillis();
            if (this.readBuffer.remaining() < length) {
                return null;
            }
        }
        this.currentObjectLength = 0;
        int startPosition = this.readBuffer.position();
        int oldLimit = this.readBuffer.limit();
        this.readBuffer.limit(startPosition + length);
        try {
            object = this.serialization.read(connection, this.readBuffer);
        }
        catch (Exception ex) {
            throw new KryoNetException("Error during deserialization.", ex);
        }
        this.readBuffer.limit(oldLimit);
        if (this.readBuffer.position() - startPosition != length) {
            throw new KryoNetException("Incorrect number of bytes (" + (startPosition + length - this.readBuffer.position()) + " remaining) used to deserialize object: " + object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeOperation() throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            if (this.writeToSocket()) {
                this.selectionKey.interestOps(1);
            }
            this.lastWriteTime = System.currentTimeMillis();
        }
    }

    private boolean writeToSocket() throws IOException {
        SocketChannel socketChannel = this.socketChannel;
        if (socketChannel == null) {
            throw new SocketException("Connection is closed.");
        }
        ByteBuffer buffer = this.writeBuffer;
        buffer.flip();
        while (buffer.hasRemaining()) {
            if (this.bufferPositionFix) {
                buffer.compact();
                buffer.flip();
            }
            if (socketChannel.write(buffer) != 0) continue;
        }
        buffer.compact();
        return buffer.position() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send(Connection connection, Object object) throws IOException {
        SocketChannel socketChannel = this.socketChannel;
        if (socketChannel == null) {
            throw new SocketException("Connection is closed.");
        }
        Object object2 = this.writeLock;
        synchronized (object2) {
            int start = this.writeBuffer.position();
            int lengthLength = this.serialization.getLengthLength();
            try {
                this.writeBuffer.position(this.writeBuffer.position() + lengthLength);
                this.serialization.write(connection, this.writeBuffer, object);
            }
            catch (Throwable ex) {
                throw new KryoNetException("Error serializing object of type: " + object.getClass().getName(), ex);
            }
            int end = this.writeBuffer.position();
            this.writeBuffer.position(start);
            this.serialization.writeLength(this.writeBuffer, end - lengthLength - start);
            this.writeBuffer.position(end);
            if (start == 0 && !this.writeToSocket()) {
                this.selectionKey.interestOps(5);
            } else {
                this.selectionKey.selector().wakeup();
            }
            if (Log.DEBUG || Log.TRACE) {
                float percentage = (float)this.writeBuffer.position() / (float)this.writeBuffer.capacity();
                if (Log.DEBUG && percentage > 0.75f) {
                    Log.debug((String)"kryonet", (String)(" TCP write buffer is approaching capacity: " + percentage + "%"));
                } else if (Log.TRACE && percentage > 0.25f) {
                    Log.trace((String)"kryonet", (String)(" TCP write buffer utilization: " + percentage + "%"));
                }
            }
            this.lastWriteTime = System.currentTimeMillis();
            return end - start;
        }
    }

    public void close() {
        block4: {
            try {
                if (this.socketChannel != null) {
                    this.socketChannel.close();
                    this.socketChannel = null;
                    if (this.selectionKey != null) {
                        this.selectionKey.selector().wakeup();
                    }
                }
            }
            catch (IOException ex) {
                if (!Log.DEBUG) break block4;
                Log.debug((String)"kryonet", (String)"Unable to close TCP connection.", (Throwable)ex);
            }
        }
    }

    public boolean needsKeepAlive(long time) {
        return this.socketChannel != null && this.keepAliveMillis > 0 && time - this.lastWriteTime > (long)this.keepAliveMillis;
    }

    public boolean isTimedOut(long time) {
        return this.socketChannel != null && this.timeoutMillis > 0 && time - this.lastReadTime > (long)this.timeoutMillis;
    }
}

