/*
 * Decompiled with CFR 0.152.
 */
package one.credify.crypto;

import crypto.Crypto;
import crypto.EncryptionKey;
import crypto.EncryptionKeyPair;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import one.credify.crypto.Base64Option;
import one.credify.crypto.CryptoHelper;
import one.credify.crypto.Encryption;
import one.credify.crypto.EncryptionImpl$WhenMappings;
import one.credify.crypto.KeyPair;
import one.credify.crypto.PreconditionKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 !2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001!B\u0007\b\u0012\u00a2\u0006\u0002\u0010\u0004B'\b\u0012\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000eH\u0016J\u0018\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000eH\u0016J\u0018\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010 \u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0016R\u0016\u0010\n\u001a\u0004\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\fR\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\fR\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0010R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\f\u00a8\u0006\""}, d2={"Lone/credify/crypto/EncryptionImpl;", "Lone/credify/crypto/KeyPair;", "Lcrypto/EncryptionKey;", "Lone/credify/crypto/Encryption;", "()V", "privateKeyPem", "", "publicKeyPem", "password", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "privateKeyAsBase64Url", "getPrivateKeyAsBase64Url", "()Ljava/lang/String;", "privateKeyAsBytes", "", "getPrivateKeyAsBytes", "()[B", "privateKeyAsPKCS8", "getPrivateKeyAsPKCS8", "publicKeyAsBase64Url", "getPublicKeyAsBase64Url", "publicKeyAsBytes", "getPublicKeyAsBytes", "publicKeyAsPKSC8", "getPublicKeyAsPKSC8", "decrypt", "message", "decryptBase64", "option", "Lone/credify/crypto/Base64Option;", "encrypt", "encryptAsBase64", "exportPrivateKey", "Companion", "credify-crypto-android_release"})
public final class EncryptionImpl
extends KeyPair<EncryptionKey, EncryptionKey>
implements Encryption {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    public String getPrivateKeyAsPKCS8() {
        EncryptionKey encryptionKey = (EncryptionKey)this.getMPrivateKey();
        return encryptionKey != null ? encryptionKey.string() : null;
    }

    @Override
    @Nullable
    public String getPrivateKeyAsBase64Url() {
        EncryptionKey encryptionKey = (EncryptionKey)this.getMPrivateKey();
        return encryptionKey != null ? encryptionKey.stringParam() : null;
    }

    @Override
    @Nullable
    public byte[] getPrivateKeyAsBytes() {
        EncryptionKey encryptionKey = (EncryptionKey)this.getMPrivateKey();
        return (byte[])(encryptionKey != null ? encryptionKey.bytes() : null);
    }

    @Override
    @Nullable
    public String getPublicKeyAsPKSC8() {
        EncryptionKey encryptionKey = (EncryptionKey)this.getMPublicKey();
        return encryptionKey != null ? encryptionKey.string() : null;
    }

    @Override
    @Nullable
    public String getPublicKeyAsBase64Url() {
        EncryptionKey encryptionKey = (EncryptionKey)this.getMPublicKey();
        return encryptionKey != null ? encryptionKey.stringParam() : null;
    }

    @Override
    @Nullable
    public byte[] getPublicKeyAsBytes() {
        EncryptionKey encryptionKey = (EncryptionKey)this.getMPublicKey();
        return (byte[])(encryptionKey != null ? encryptionKey.bytes() : null);
    }

    @Override
    @NotNull
    public String exportPrivateKey(@NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Object PI = this.getMPrivateKey();
        boolean bl = false;
        boolean bl2 = false;
        if (PI == null) {
            boolean bl3 = false;
            String string = "Private key must not be null";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Object PI2 = this.getMPrivateKey();
        Intrinsics.checkNotNull(PI2);
        String string = ((EncryptionKey)PI2).export(password);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mPrivateKey!!.export(password)");
        return string;
    }

    @Override
    @NotNull
    public byte[] encrypt(@NotNull byte[] message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        EncryptionKey publicKey = (EncryptionKey)this.getMPublicKey();
        boolean bl = false;
        boolean bl2 = false;
        if (publicKey == null) {
            boolean bl3 = false;
            String string = "Public key must not be null";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        byte[] byArray = publicKey.encrypt(message);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"publicKey.encrypt(message)");
        return byArray;
    }

    @Override
    @NotNull
    public String encryptAsBase64(@NotNull String message, @NotNull Base64Option option) {
        String string;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)option), (String)"option");
        EncryptionKey publicKey = (EncryptionKey)this.getMPublicKey();
        boolean bl = false;
        boolean bl2 = false;
        if (publicKey == null) {
            boolean bl3 = false;
            String string2 = "Public key must not be null";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        String string3 = message;
        Charset charset = Charsets.UTF_8;
        boolean bl4 = false;
        byte[] byArray = string3.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] messageByteArr = byArray;
        switch (EncryptionImpl$WhenMappings.$EnumSwitchMapping$0[option.ordinal()]) {
            case 1: {
                String string4 = publicKey.encryptAsBase64(messageByteArr);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"publicKey.encryptAsBase64(messageByteArr)");
                break;
            }
            default: {
                string = CryptoHelper.INSTANCE.encodeBase64(this.encrypt(messageByteArr), option);
            }
        }
        return string;
    }

    @Override
    @NotNull
    public byte[] decrypt(@NotNull byte[] message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        EncryptionKey privateKey = (EncryptionKey)this.getMPrivateKey();
        boolean bl = false;
        boolean bl2 = false;
        if (privateKey == null) {
            boolean bl3 = false;
            String string = "Private key must not be null";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        byte[] byArray = privateKey.decrypt(message);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"privateKey.decrypt(message)");
        return byArray;
    }

    @Override
    @NotNull
    public String decryptBase64(@NotNull String message, @NotNull Base64Option option) {
        String string;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)option), (String)"option");
        EncryptionKey privateKey = (EncryptionKey)this.getMPrivateKey();
        boolean bl = false;
        boolean bl2 = false;
        if (privateKey == null) {
            boolean bl3 = false;
            String string2 = "Private key must not be null";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        switch (EncryptionImpl$WhenMappings.$EnumSwitchMapping$1[option.ordinal()]) {
            case 1: {
                byte[] byArray = privateKey.decryptBase64(message);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"privateKey.decryptBase64(message)");
                byte[] byArray2 = byArray;
                Charset charset = Charsets.UTF_8;
                boolean bl4 = false;
                boolean bl5 = false;
                string = new String(byArray2, charset);
                break;
            }
            default: {
                byte[] byArray = this.decrypt(CryptoHelper.INSTANCE.decodeBase64(message, option));
                Charset charset = Charsets.UTF_8;
                boolean bl6 = false;
                boolean bl7 = false;
                string = new String(byArray, charset);
            }
        }
        return string;
    }

    private EncryptionImpl() {
        EncryptionKeyPair keyPair;
        EncryptionKeyPair encryptionKeyPair = keyPair = Crypto.generateEncryptionKeyPair();
        Intrinsics.checkNotNullExpressionValue((Object)encryptionKeyPair, (String)"keyPair");
        this.setMPrivateKey(encryptionKeyPair.getPrivateKey());
        this.setMPublicKey(keyPair.getPublicKey());
    }

    private EncryptionImpl(String privateKeyPem, String publicKeyPem, String password) {
        block1: {
            String it;
            boolean bl;
            boolean bl2;
            String string;
            String string2 = privateKeyPem;
            if (string2 != null) {
                string = string2;
                bl2 = false;
                bl = false;
                it = string;
                boolean bl3 = false;
                PreconditionKt.requireStringNotEmpty(privateKeyPem, (Function0<? extends Object>)((Function0)new Function0<Object>(it){
                    final /* synthetic */ String $it;

                    @NotNull
                    public final Object invoke() {
                        return "Invalid private key: " + this.$it;
                    }
                    {
                        this.$it = string;
                        super(0);
                    }
                }));
                this.setMPrivateKey(password == null ? Crypto.encryptionPrivateKeyFromPem(privateKeyPem) : Crypto.decryptEncryptionPrivateKey(privateKeyPem, password));
            }
            String string3 = publicKeyPem;
            if (string3 == null) break block1;
            string = string3;
            bl2 = false;
            bl = false;
            it = string;
            boolean bl4 = false;
            PreconditionKt.requireStringNotEmpty(publicKeyPem, (Function0<? extends Object>)((Function0)new Function0<Object>(it){
                final /* synthetic */ String $it;

                @NotNull
                public final Object invoke() {
                    return "Invalid public key: " + this.$it;
                }
                {
                    this.$it = string;
                    super(0);
                }
            }));
            this.setMPublicKey(Crypto.encryptionPublicKeyFromPem(publicKeyPem));
        }
    }

    /* synthetic */ EncryptionImpl(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        this(string, string2, string3);
    }

    public /* synthetic */ EncryptionImpl(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public /* synthetic */ EncryptionImpl(String privateKeyPem, String publicKeyPem, String password, DefaultConstructorMarker $constructor_marker) {
        this(privateKeyPem, publicKeyPem, password);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0006J\u001a\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0006J\u001a\u0010\n\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u000b"}, d2={"Lone/credify/crypto/EncryptionImpl$Companion;", "", "()V", "create", "Lone/credify/crypto/Encryption;", "privateKeyPem", "", "publicKeyPem", "password", "createWithPrivateKey", "createWithPublicKey", "credify-crypto-android_release"})
    public static final class Companion {
        @NotNull
        public final Encryption create() {
            return new EncryptionImpl(null);
        }

        @NotNull
        public final Encryption create(@NotNull String privateKeyPem, @NotNull String publicKeyPem, @Nullable String password) {
            Intrinsics.checkNotNullParameter((Object)privateKeyPem, (String)"privateKeyPem");
            Intrinsics.checkNotNullParameter((Object)publicKeyPem, (String)"publicKeyPem");
            return new EncryptionImpl(privateKeyPem, publicKeyPem, password, null);
        }

        public static /* synthetic */ Encryption create$default(Companion companion, String string, String string2, String string3, int n, Object object) {
            if ((n & 4) != 0) {
                string3 = null;
            }
            return companion.create(string, string2, string3);
        }

        @NotNull
        public final Encryption createWithPrivateKey(@NotNull String privateKeyPem, @Nullable String password) {
            Intrinsics.checkNotNullParameter((Object)privateKeyPem, (String)"privateKeyPem");
            return new EncryptionImpl(privateKeyPem, null, password, null);
        }

        public static /* synthetic */ Encryption createWithPrivateKey$default(Companion companion, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            return companion.createWithPrivateKey(string, string2);
        }

        @NotNull
        public final Encryption createWithPublicKey(@NotNull String publicKeyPem, @Nullable String password) {
            Intrinsics.checkNotNullParameter((Object)publicKeyPem, (String)"publicKeyPem");
            return new EncryptionImpl(null, publicKeyPem, password, null);
        }

        public static /* synthetic */ Encryption createWithPublicKey$default(Companion companion, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            return companion.createWithPublicKey(string, string2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

