/*
 * Decompiled with CFR 0.152.
 */
package one.credify.crypto;

import android.util.Base64;
import crypto.Crypto;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import one.credify.crypto.Base64Option;
import one.credify.crypto.CryptoHelper$WhenMappings;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\n\u001a\u00020\u0004J\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u000e"}, d2={"Lone/credify/crypto/CryptoHelper;", "", "()V", "decodeBase64", "", "message", "", "option", "Lone/credify/crypto/Base64Option;", "encodeBase64", "generateSalt", "generateSaltAsBase64", "hash", "hashAsBase64", "credify-crypto-android_release"})
public final class CryptoHelper {
    @NotNull
    public static final CryptoHelper INSTANCE;

    @NotNull
    public final String encodeBase64(@NotNull byte[] message, @NotNull Base64Option option) {
        String string;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)option), (String)"option");
        switch (CryptoHelper$WhenMappings.$EnumSwitchMapping$0[option.ordinal()]) {
            case 1: {
                String string2 = Base64.encodeToString((byte[])message, (int)0);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"Base64.encodeToString(message, Base64.DEFAULT)");
                break;
            }
            case 2: {
                String string3 = Crypto.encodeBase64(message);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"Crypto.encodeBase64(message)");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @NotNull
    public final byte[] decodeBase64(@NotNull String message, @NotNull Base64Option option) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)option), (String)"option");
        switch (CryptoHelper$WhenMappings.$EnumSwitchMapping$1[option.ordinal()]) {
            case 1: {
                byte[] byArray2 = Base64.decode((String)message, (int)0);
                byArray = byArray2;
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"Base64.decode(message, Base64.DEFAULT)");
                break;
            }
            case 2: {
                byte[] byArray3 = Crypto.decodeBase64(message);
                byArray = byArray3;
                Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"Crypto.decodeBase64(message)");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return byArray;
    }

    @NotNull
    public final byte[] generateSalt() {
        byte[] byArray = Crypto.generateSalt();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Crypto.generateSalt()");
        return byArray;
    }

    @NotNull
    public final String generateSaltAsBase64(@NotNull Base64Option option) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)option), (String)"option");
        switch (CryptoHelper$WhenMappings.$EnumSwitchMapping$2[option.ordinal()]) {
            case 1: {
                String string2 = Base64.encodeToString((byte[])this.generateSalt(), (int)0);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"Base64.encodeToString(ge\u2026teSalt(), Base64.DEFAULT)");
                break;
            }
            case 2: {
                String string3 = Crypto.generateSaltAsBase64();
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"Crypto.generateSaltAsBase64()");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @NotNull
    public final byte[] hash(@NotNull byte[] message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        byte[] byArray = Crypto.hash(message);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Crypto.hash(message)");
        return byArray;
    }

    @NotNull
    public final byte[] hash(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String string = message;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return this.hash(byArray);
    }

    @NotNull
    public final String hashAsBase64(@NotNull byte[] message, @NotNull Base64Option option) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)option), (String)"option");
        return this.encodeBase64(this.hash(message), option);
    }

    @NotNull
    public final String hashAsBase64(@NotNull String message, @NotNull Base64Option option) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)option), (String)"option");
        String string = message;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return this.hashAsBase64(byArray, option);
    }

    private CryptoHelper() {
    }

    static {
        CryptoHelper cryptoHelper;
        INSTANCE = cryptoHelper = new CryptoHelper();
    }
}

