/*
 * Decompiled with CFR 0.152.
 */
package crypto;

import crypto.EncryptionKey;
import crypto.EncryptionKeyPair;
import crypto.LoginClaims;
import crypto.Serializable;
import crypto.SigningKey;
import crypto.SigningKeyPair;
import crypto.VerificationKey;
import go.Seq;

public abstract class Crypto {
    public static final String Ed25519SigningAlgorithm = "EdDSA";
    public static final String EncryptedPrivateKeyBlockType = "ENCRYPTED PRIVATE KEY";
    public static final String PrivateKeyBlockType = "PRIVATE KEY";
    public static final String PublicKeyBlockType = "PUBLIC KEY";
    public static final long RsaKeyLength = 3072L;

    private Crypto() {
    }

    public static void touch() {
    }

    private static native void _init();

    public static native byte[] decodeBase64(String var0) throws Exception;

    public static native EncryptionKey decryptEncryptionPrivateKey(String var0, String var1) throws Exception;

    public static native SigningKey decryptSigningKey(String var0, String var1) throws Exception;

    public static native String encodeBase64(byte[] var0);

    public static native EncryptionKey encryptionPrivateKeyFromPem(String var0);

    public static native EncryptionKey encryptionPublicKeyFromPem(String var0);

    public static native EncryptionKeyPair generateEncryptionKeyPair() throws Exception;

    public static native byte[] generateSalt() throws Exception;

    public static native String generateSaltAsBase64() throws Exception;

    public static native SigningKeyPair generateSigningKeyPair() throws Exception;

    public static native byte[] hash(byte[] var0);

    public static native String loginToken(SigningKey var0, VerificationKey var1);

    public static native String newApprovalToken(SigningKey var0, String var1, String var2, String var3, String var4);

    public static native String newIdentityToken(SigningKey var0, String var1, String var2, String var3);

    public static native String newRequestToken(SigningKey var0, String var1, String var2, String var3, String var4);

    public static native EncryptionKey parseBase64EncryptionPrivateKey(String var0) throws Exception;

    public static native EncryptionKey parseBase64EncryptionPublicKey(String var0) throws Exception;

    public static native SigningKey parseBase64SigningKey(String var0) throws Exception;

    public static native VerificationKey parseBase64VerificationKey(String var0) throws Exception;

    public static native EncryptionKey parseEncryptionPrivateKey(String var0) throws Exception;

    public static native EncryptionKey parseEncryptionPublicKey(String var0) throws Exception;

    public static native LoginClaims parseLoginToken(String var0) throws Exception;

    public static native SigningKey parseSigningKey(String var0) throws Exception;

    public static native VerificationKey parseVerificationKey(String var0) throws Exception;

    public static native SigningKey signingKeyFromPEM(String var0);

    public static native VerificationKey verificationKeyFromPem(String var0);

    public static native boolean verifyHash(byte[] var0, byte[] var1);

    static {
        Seq.touch();
        Crypto._init();
    }

    private static final class proxyVerificationKey
    implements Seq.Proxy,
    VerificationKey {
        private final int refnum;

        @Override
        public final int incRefnum() {
            Seq.incGoRef(this.refnum, this);
            return this.refnum;
        }

        proxyVerificationKey(int n) {
            this.refnum = n;
            Seq.trackGoRef(n, this);
        }

        @Override
        public native byte[] bytes();

        @Override
        public native String string();

        @Override
        public native String stringParam();

        @Override
        public native boolean verify(byte[] var1, byte[] var2) throws Exception;

        @Override
        public native boolean verifyBase64(String var1, byte[] var2) throws Exception;
    }

    private static final class proxySigningKey
    implements Seq.Proxy,
    SigningKey {
        private final int refnum;

        @Override
        public final int incRefnum() {
            Seq.incGoRef(this.refnum, this);
            return this.refnum;
        }

        proxySigningKey(int n) {
            this.refnum = n;
            Seq.trackGoRef(n, this);
        }

        @Override
        public native byte[] bytes();

        @Override
        public native String export(String var1) throws Exception;

        @Override
        public native byte[] sign(byte[] var1) throws Exception;

        @Override
        public native String signAsBase64(byte[] var1) throws Exception;

        @Override
        public native String string();

        @Override
        public native String stringParam();
    }

    private static final class proxySerializable
    implements Seq.Proxy,
    Serializable {
        private final int refnum;

        @Override
        public final int incRefnum() {
            Seq.incGoRef(this.refnum, this);
            return this.refnum;
        }

        proxySerializable(int n) {
            this.refnum = n;
            Seq.trackGoRef(n, this);
        }

        @Override
        public native byte[] bytes();

        @Override
        public native String string();

        @Override
        public native String stringParam();
    }

    private static final class proxyEncryptionKey
    implements Seq.Proxy,
    EncryptionKey {
        private final int refnum;

        @Override
        public final int incRefnum() {
            Seq.incGoRef(this.refnum, this);
            return this.refnum;
        }

        proxyEncryptionKey(int n) {
            this.refnum = n;
            Seq.trackGoRef(n, this);
        }

        @Override
        public native byte[] bytes();

        @Override
        public native byte[] decrypt(byte[] var1) throws Exception;

        @Override
        public native byte[] decryptBase64(String var1) throws Exception;

        @Override
        public native byte[] encrypt(byte[] var1) throws Exception;

        @Override
        public native String encryptAsBase64(byte[] var1) throws Exception;

        @Override
        public native String export(String var1) throws Exception;

        @Override
        public native String string();

        @Override
        public native String stringParam();
    }
}

