/*
 * Decompiled with CFR 0.152.
 */
package one.credify.crypto;

import crypto.Crypto;
import crypto.SigningKey;
import crypto.SigningKeyPair;
import crypto.VerificationKey;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import one.credify.crypto.Base64Option;
import one.credify.crypto.CryptoHelper;
import one.credify.crypto.KeyPair;
import one.credify.crypto.PreconditionKt;
import one.credify.crypto.Signing;
import one.credify.crypto.SigningImpl$WhenMappings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u000f\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 -2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004:\u0001-B\u0007\b\u0012\u00a2\u0006\u0002\u0010\u0005B'\b\u0012\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0016J0\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00072\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0007H\u0016J\b\u0010!\u001a\u00020\u0007H\u0016J0\u0010\"\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u00072\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0007H\u0016J\u0010\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u000fH\u0016J\u0018\u0010&\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020(H\u0016J\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u000fH\u0016J \u0010,\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020(H\u0016R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\rR\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\rR\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0011R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\r\u00a8\u0006."}, d2={"Lone/credify/crypto/SigningImpl;", "Lone/credify/crypto/KeyPair;", "Lcrypto/SigningKey;", "Lcrypto/VerificationKey;", "Lone/credify/crypto/Signing;", "()V", "privateKeyPem", "", "publicKeyPem", "password", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "privateKeyAsBase64Url", "getPrivateKeyAsBase64Url", "()Ljava/lang/String;", "privateKeyAsBytes", "", "getPrivateKeyAsBytes", "()[B", "privateKeyAsPKCS8", "getPrivateKeyAsPKCS8", "publicKeyAsBase64Url", "getPublicKeyAsBase64Url", "publicKeyAsBytes", "getPublicKeyAsBytes", "publicKeyAsPKSC8", "getPublicKeyAsPKSC8", "exportPrivateKey", "generateApprovalToken", "id", "clientId", "scopeList", "", "offerCode", "generateLoginToken", "generateRequestToken", "encryptionPublicKey", "sign", "message", "signAsBase64", "option", "Lone/credify/crypto/Base64Option;", "verify", "", "signature", "verifyBase64", "Companion", "credify-crypto-android_release"})
public final class SigningImpl
extends KeyPair<SigningKey, VerificationKey>
implements Signing {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    public String getPrivateKeyAsPKCS8() {
        SigningKey signingKey = (SigningKey)this.getMPrivateKey();
        return signingKey != null ? signingKey.string() : null;
    }

    @Override
    @Nullable
    public String getPrivateKeyAsBase64Url() {
        SigningKey signingKey = (SigningKey)this.getMPrivateKey();
        return signingKey != null ? signingKey.stringParam() : null;
    }

    @Override
    @Nullable
    public byte[] getPrivateKeyAsBytes() {
        SigningKey signingKey = (SigningKey)this.getMPrivateKey();
        return (byte[])(signingKey != null ? signingKey.bytes() : null);
    }

    @Override
    @Nullable
    public String getPublicKeyAsPKSC8() {
        VerificationKey verificationKey = (VerificationKey)this.getMPublicKey();
        return verificationKey != null ? verificationKey.string() : null;
    }

    @Override
    @Nullable
    public String getPublicKeyAsBase64Url() {
        VerificationKey verificationKey = (VerificationKey)this.getMPublicKey();
        return verificationKey != null ? verificationKey.stringParam() : null;
    }

    @Override
    @Nullable
    public byte[] getPublicKeyAsBytes() {
        VerificationKey verificationKey = (VerificationKey)this.getMPublicKey();
        return (byte[])(verificationKey != null ? verificationKey.bytes() : null);
    }

    @Override
    @NotNull
    public byte[] sign(@NotNull byte[] message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        SigningKey privateKey = (SigningKey)this.getMPrivateKey();
        boolean bl = false;
        boolean bl2 = false;
        if (privateKey == null) {
            boolean bl3 = false;
            String string = "Private key must not be null";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        byte[] byArray = privateKey.sign(message);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"privateKey.sign(message)");
        return byArray;
    }

    @Override
    @NotNull
    public String signAsBase64(@NotNull byte[] message, @NotNull Base64Option option) {
        String string;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)option), (String)"option");
        SigningKey privateKey = (SigningKey)this.getMPrivateKey();
        boolean bl = false;
        boolean bl2 = false;
        if (privateKey == null) {
            boolean bl3 = false;
            String string2 = "Private key must not be null";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        switch (SigningImpl$WhenMappings.$EnumSwitchMapping$0[option.ordinal()]) {
            case 1: {
                String string3 = privateKey.signAsBase64(message);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"privateKey.signAsBase64(message)");
                break;
            }
            default: {
                string = CryptoHelper.INSTANCE.encodeBase64(this.sign(message), option);
            }
        }
        return string;
    }

    @Override
    public boolean verify(@NotNull byte[] signature, @NotNull byte[] message) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        VerificationKey publicKey = (VerificationKey)this.getMPublicKey();
        boolean bl = false;
        boolean bl2 = false;
        if (publicKey == null) {
            boolean bl3 = false;
            String string = "Public key must not be null";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return publicKey.verify(signature, message);
    }

    @Override
    public boolean verifyBase64(@NotNull String signature, @NotNull byte[] message, @NotNull Base64Option option) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)option), (String)"option");
        VerificationKey publicKey = (VerificationKey)this.getMPublicKey();
        boolean bl2 = false;
        boolean bl3 = false;
        if (publicKey == null) {
            boolean bl4 = false;
            String string = "Public key must not be null";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        switch (SigningImpl$WhenMappings.$EnumSwitchMapping$1[option.ordinal()]) {
            case 1: {
                bl = publicKey.verifyBase64(signature, message);
                break;
            }
            default: {
                bl = this.verify(CryptoHelper.INSTANCE.decodeBase64(signature, option), message);
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public String exportPrivateKey(@NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Object PI = this.getMPrivateKey();
        boolean bl = false;
        boolean bl2 = false;
        if (PI == null) {
            boolean bl3 = false;
            String string = "Private key must not be null";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Object PI2 = this.getMPrivateKey();
        Intrinsics.checkNotNull(PI2);
        String string = ((SigningKey)PI2).export(password);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mPrivateKey!!.export(password)");
        return string;
    }

    @Override
    @NotNull
    public String generateLoginToken() {
        Object object = this.getMPrivateKey();
        boolean bl = false;
        boolean bl2 = false;
        if (object == null) {
            boolean bl3 = false;
            String string = "Private key must not be null";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        object = this.getMPublicKey();
        bl = false;
        bl2 = false;
        if (object == null) {
            boolean bl4 = false;
            String string = "Public key must not be null";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        String string = Crypto.loginToken((SigningKey)((SigningKey)this.getMPrivateKey()), (VerificationKey)((VerificationKey)this.getMPublicKey()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Crypto.loginToken(mPrivateKey, mPublicKey)");
        return string;
    }

    @Override
    @NotNull
    public String generateApprovalToken(@NotNull String id, @NotNull String clientId, @NotNull List<String> scopeList, @Nullable String offerCode) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter(scopeList, (String)"scopeList");
        SigningKey privateKey = (SigningKey)this.getMPrivateKey();
        boolean bl = false;
        boolean bl2 = false;
        if (privateKey == null) {
            boolean bl3 = false;
            String string = "Private key must not be null";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        String scopeString = CollectionsKt.joinToString$default((Iterable)scopeList, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        String string = Crypto.newApprovalToken((SigningKey)privateKey, (String)id, (String)clientId, (String)scopeString, (String)offerCode);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Crypto.newApprovalToken(\u2026, scopeString, offerCode)");
        return string;
    }

    @Override
    @NotNull
    public String generateRequestToken(@NotNull String clientId, @NotNull String encryptionPublicKey, @NotNull List<String> scopeList, @Nullable String offerCode) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)encryptionPublicKey, (String)"encryptionPublicKey");
        Intrinsics.checkNotNullParameter(scopeList, (String)"scopeList");
        SigningKey privateKey = (SigningKey)this.getMPrivateKey();
        boolean bl = false;
        boolean bl2 = false;
        if (privateKey == null) {
            boolean bl3 = false;
            String string = "Private key must not be null";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        String scopeString = CollectionsKt.joinToString$default((Iterable)scopeList, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        String string = Crypto.newRequestToken((SigningKey)privateKey, (String)clientId, (String)encryptionPublicKey, (String)scopeString, (String)offerCode);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Crypto.newRequestToken(p\u2026, scopeString, offerCode)");
        return string;
    }

    private SigningImpl() {
        SigningKeyPair keyPair;
        SigningKeyPair signingKeyPair = keyPair = Crypto.generateSigningKeyPair();
        Intrinsics.checkNotNullExpressionValue((Object)signingKeyPair, (String)"keyPair");
        this.setMPrivateKey(signingKeyPair.getSigningKey());
        this.setMPublicKey(keyPair.getVerificationKey());
    }

    private SigningImpl(String privateKeyPem, String publicKeyPem, String password) {
        block1: {
            String it;
            boolean bl;
            boolean bl2;
            String string;
            String string2 = privateKeyPem;
            if (string2 != null) {
                string = string2;
                bl2 = false;
                bl = false;
                it = string;
                boolean bl3 = false;
                PreconditionKt.requireStringNotEmpty(privateKeyPem, (Function0<? extends Object>)((Function0)new Function0<Object>(it){
                    final /* synthetic */ String $it;

                    @NotNull
                    public final Object invoke() {
                        return "Invalid private key: " + this.$it;
                    }
                    {
                        this.$it = string;
                        super(0);
                    }
                }));
                this.setMPrivateKey(password == null ? Crypto.signingKeyFromPEM((String)privateKeyPem) : Crypto.decryptSigningKey((String)privateKeyPem, (String)password));
            }
            String string3 = publicKeyPem;
            if (string3 == null) break block1;
            string = string3;
            bl2 = false;
            bl = false;
            it = string;
            boolean bl4 = false;
            PreconditionKt.requireStringNotEmpty(publicKeyPem, (Function0<? extends Object>)((Function0)new Function0<Object>(it){
                final /* synthetic */ String $it;

                @NotNull
                public final Object invoke() {
                    return "Invalid public key: " + this.$it;
                }
                {
                    this.$it = string;
                    super(0);
                }
            }));
            this.setMPublicKey(Crypto.verificationKeyFromPem((String)publicKeyPem));
        }
    }

    /* synthetic */ SigningImpl(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        this(string, string2, string3);
    }

    public /* synthetic */ SigningImpl(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public /* synthetic */ SigningImpl(String privateKeyPem, String publicKeyPem, String password, DefaultConstructorMarker $constructor_marker) {
        this(privateKeyPem, publicKeyPem, password);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0006J\u001a\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0006J\u001a\u0010\n\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u000b"}, d2={"Lone/credify/crypto/SigningImpl$Companion;", "", "()V", "create", "Lone/credify/crypto/Signing;", "privateKeyPem", "", "publicKeyPem", "password", "createWithPrivateKey", "createWithPublicKey", "credify-crypto-android_release"})
    public static final class Companion {
        @NotNull
        public final Signing create() {
            return new SigningImpl(null);
        }

        @NotNull
        public final Signing create(@NotNull String privateKeyPem, @NotNull String publicKeyPem, @Nullable String password) {
            Intrinsics.checkNotNullParameter((Object)privateKeyPem, (String)"privateKeyPem");
            Intrinsics.checkNotNullParameter((Object)publicKeyPem, (String)"publicKeyPem");
            return new SigningImpl(privateKeyPem, publicKeyPem, password, null);
        }

        public static /* synthetic */ Signing create$default(Companion companion, String string, String string2, String string3, int n, Object object) {
            if ((n & 4) != 0) {
                string3 = null;
            }
            return companion.create(string, string2, string3);
        }

        @NotNull
        public final Signing createWithPrivateKey(@NotNull String privateKeyPem, @Nullable String password) {
            Intrinsics.checkNotNullParameter((Object)privateKeyPem, (String)"privateKeyPem");
            return new SigningImpl(privateKeyPem, null, password, null);
        }

        public static /* synthetic */ Signing createWithPrivateKey$default(Companion companion, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            return companion.createWithPrivateKey(string, string2);
        }

        @NotNull
        public final Signing createWithPublicKey(@NotNull String publicKeyPem, @Nullable String password) {
            Intrinsics.checkNotNullParameter((Object)publicKeyPem, (String)"publicKeyPem");
            return new SigningImpl(null, publicKeyPem, password, null);
        }

        public static /* synthetic */ Signing createWithPublicKey$default(Companion companion, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            return companion.createWithPublicKey(string, string2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

