/*
 * Decompiled with CFR 0.152.
 */
package com.crabshue.commons.validations.path.validators;

import com.crabshue.commons.validations.path.annotations.PathAccessMode;
import com.crabshue.commons.validations.path.annotations.ValidFilePath;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class FilePathValidator
implements ConstraintValidator<ValidFilePath, Path> {
    private PathAccessMode[] accessModes;

    public void initialize(ValidFilePath constraintAnnotation) {
        this.accessModes = constraintAnnotation.accessModes();
    }

    public boolean isValid(Path path, ConstraintValidatorContext constraintValidatorContext) {
        if (path != null) {
            if (!Files.exists(path, new LinkOption[0])) {
                this.setErrorMessage(constraintValidatorContext, "The file '${validatedValue}' does not exist");
                return false;
            }
            if (!Files.isRegularFile(path, new LinkOption[0])) {
                this.setErrorMessage(constraintValidatorContext, "'${validatedValue}' is not a file");
                return false;
            }
            for (PathAccessMode accessMode : this.accessModes) {
                if (accessMode.canAccessInMode(path).booleanValue()) continue;
                this.setErrorMessage(constraintValidatorContext, "The file '${validatedValue}' cannot be accessed in " + accessMode.getAccessMode());
                return false;
            }
        }
        return true;
    }

    private void setErrorMessage(ConstraintValidatorContext constraintValidatorContext, String message) {
        constraintValidatorContext.disableDefaultConstraintViolation();
        constraintValidatorContext.buildConstraintViolationWithTemplate(message).addConstraintViolation();
    }
}

