/*
 * Decompiled with CFR 0.152.
 */
package com.crabshue.commons.validations.path.annotations;

import com.crabshue.commons.validations.path.annotations.AccessModeValidator;
import java.nio.file.Files;
import java.nio.file.Path;

public enum PathAccessMode implements AccessModeValidator
{
    READ("read mode"){

        @Override
        public Boolean canAccessInMode(Path path) {
            return Files.isReadable(path);
        }
    }
    ,
    WRITE("write mode"){

        @Override
        public Boolean canAccessInMode(Path path) {
            return Files.isWritable(path);
        }
    }
    ,
    EXEC("execute mode"){

        @Override
        public Boolean canAccessInMode(Path path) {
            return Files.isExecutable(path);
        }
    };

    private String accessMode;

    public String getAccessMode() {
        return this.accessMode;
    }

    private PathAccessMode(String accessMode) {
        this.accessMode = accessMode;
    }
}

